/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import java.util.List;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;

public class AwsBatchConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    The path where the AWS command line tool is installed in the host AMI.\n")
    public String cliPath;
    @ConfigOption
    @Description(value="    Delay between download attempts from S3 (default: `10 sec`).\n")
    public Duration delayBetweenAttempts;
    @ConfigOption
    @Description(value="    The AWS Batch Execution Role ARN that needs to be used to execute the Batch Job.\n\n    [Read more](https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html)\n")
    public String executionRole;
    @ConfigOption
    @Description(value="    The AWS Batch Job Role ARN that needs to be used to execute the Batch Job.\n")
    public String jobRole;
    @ConfigOption
    @Description(value="    The name of the logs group used by Batch Jobs (default: `/aws/batch`).\n")
    public String logsGroup;
    @ConfigOption
    @Description(value="    Max parallel upload/download transfer operations *per job* (default: `4`).\n")
    public int maxParallelTransfers;
    @ConfigOption
    @Description(value="    Max number of execution attempts of a job interrupted by a EC2 spot reclaim event (default: `5`)\n")
    public int maxSpotAttempts;
    @ConfigOption
    @Description(value="    Max number of downloads attempts from S3 (default: `1`).\n")
    public int maxTransferAttempts;
    @ConfigOption
    @Description(value="    The compute platform type used by AWS Batch. Can be either `ec2` or `fargate`.\n")
    public String platformType;
    @ConfigOption
    @Description(value="    The retry mode used to accommodate rate-limiting on AWS services. Can be one of `standard`, `legacy`, `adaptive`, or `built-in` (default: `standard`).\n\n    [Read more](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-retries.html)\n")
    public String retryMode;
    @ConfigOption
    @Description(value="    The scheduling priority for all tasks when using fair-share scheduling for AWS Batch (default: `0`).\n\n    [Read more](https://aws.amazon.com/blogs/hpc/introducing-fair-share-scheduling-for-aws-batch/)\n")
    public int schedulingPriority;
    @ConfigOption
    @Description(value="    The share identifier for all tasks when using fair-share scheduling for AWS Batch.\n\n    [Read more](https://aws.amazon.com/blogs/hpc/introducing-fair-share-scheduling-for-aws-batch/)\n")
    public String shareIdentifier;
    @ConfigOption
    @Description(value="    When true, jobs that cannot be scheduled for lack of resources or misconfiguration are terminated automatically (default: `false`).\n")
    public boolean terminateUnschedulableJobs;
    @ConfigOption
    @Description(value="    One or more container mounts. Mounts can be specified as simple e.g. `/some/path` or canonical format e.g. `/host/path:/mount/path[:ro|rw]`.\n")
    public List<String> volumes;
}

