/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;

public class ApptainerConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    When `true` Nextflow automatically mounts host paths in the executed container. It requires the `user bind control` feature to be enabled in your Apptainer installation (default: `true`).\n")
    public boolean autoMounts;
    @ConfigOption
    @Description(value="    The directory where remote Apptainer images are stored. When using a computing cluster it must be a shared folder accessible to all compute nodes.\n")
    public String cacheDir;
    @ConfigOption
    @Description(value="    Enable Apptainer execution (default: `false`).\n")
    public boolean enabled;
    @ConfigOption
    @Description(value="    This attribute can be used to provide any option supported by the Apptainer engine i.e. `apptainer [OPTIONS]`.\n")
    public String engineOptions;
    @ConfigOption
    @Description(value="    Comma separated list of environment variable names to be included in the container environment.\n")
    public String envWhitelist;
    @ConfigOption
    @Description(value="    Directory where remote Apptainer images are retrieved. When using a computing cluster it must be a shared folder accessible to all compute nodes.\n")
    public String libraryDir;
    @ConfigOption
    @Description(value="    Pull the Apptainer image with http protocol (default: `false`).\n")
    public boolean noHttps;
    @ConfigOption
    @Description(value="    When enabled, OCI (and Docker) container images are pulled and converted to the SIF format by the Apptainer run command, instead of Nextflow (default: `false`).\n")
    public boolean ociAutoPull;
    @ConfigOption
    @Description(value="    The amount of time the Apptainer pull can last, exceeding which the process is terminated (default: `20 min`).\n")
    public Duration pullTimeout;
    @ConfigOption
    @Description(value="    The registry from where Docker images are pulled. It should be only used to specify a private registry server. It should NOT include the protocol prefix i.e. `http://`.\n")
    public String registry;
    @ConfigOption
    @Description(value="    This attribute can be used to provide any extra command line options supported by `apptainer exec`.\n")
    public String runOptions;
}

