/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.schema;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.config.schema.PlaceholderName;
import nextflow.config.scopes.Config;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.DslScope;
import nextflow.script.dsl.FeatureFlag;
import nextflow.script.dsl.FeatureFlagDsl;
import nextflow.script.dsl.ProcessDsl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SchemaNode {
    public static final Scope ROOT = SchemaNode.rootScope();

    public String description();

    private static Scope rootScope() {
        Scope result = Scope.of(Config.class, "");
        result.children().put("nextflow", SchemaNode.nextflowScope());
        result.children().put("process", SchemaNode.processScope());
        return result;
    }

    private static SchemaNode nextflowScope() {
        HashMap<String, SchemaNode> enableOpts = new HashMap<String, SchemaNode>();
        HashMap<String, SchemaNode> previewOpts = new HashMap<String, SchemaNode>();
        for (Field field : FeatureFlagDsl.class.getDeclaredFields()) {
            String fqName = field.getAnnotation(FeatureFlag.class).value();
            String[] names = fqName.split("\\.");
            String simpleName = names[names.length - 1];
            String desc = SchemaNode.annotatedDescription(field, "");
            if (fqName.startsWith("nextflow.enable.")) {
                enableOpts.put(simpleName, new Option(desc, SchemaNode.optionType(field)));
                continue;
            }
            if (fqName.startsWith("nextflow.preview.")) {
                previewOpts.put(simpleName, new Option(desc, SchemaNode.optionType(field)));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new Scope("", Map.ofEntries(Map.entry("enable", new Scope("", enableOpts)), Map.entry("preview", new Scope("", previewOpts))));
    }

    private static SchemaNode processScope() {
        String description = "    The `process` scope allows you to specify default directives for processes in your pipeline.\n\n    [Read more](https://nextflow.io/docs/latest/config.html#process-configuration)\n";
        HashMap<String, SchemaNode> children = new HashMap<String, SchemaNode>();
        for (Method method : ProcessDsl.DirectiveDsl.class.getDeclaredMethods()) {
            String desc = SchemaNode.annotatedDescription(method, "");
            children.put(method.getName(), new Option(desc, SchemaNode.optionType(method)));
        }
        return new Scope(description, children);
    }

    private static String annotatedDescription(AnnotatedElement el, String defaultValue) {
        Description annot = el.getAnnotation(Description.class);
        return annot != null ? annot.value() : defaultValue;
    }

    private static Class optionType(AnnotatedElement element) {
        if (element instanceof Field) {
            Field field = (Field)element;
            return field.getType();
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE) {
                return returnType;
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length > 0) {
                return paramTypes[paramTypes.length - 1];
            }
        }
        return null;
    }

    public record Scope(String description, Map<String, SchemaNode> children) implements SchemaNode
    {
        public SchemaNode getChild(List<String> names) {
            SchemaNode node = this;
            for (String name : names) {
                if (node instanceof Scope) {
                    Scope sn = node;
                    node = sn.children().get(name);
                    continue;
                }
                if (node instanceof Placeholder) {
                    Placeholder pn = (Placeholder)node;
                    node = pn.scope();
                    continue;
                }
                return null;
            }
            return node;
        }

        public DslOption getDslOption(List<String> names) {
            DslOption option;
            SchemaNode schemaNode = this.getChild(names);
            return schemaNode instanceof DslOption ? (option = (DslOption)schemaNode) : null;
        }

        public Option getOption(List<String> names) {
            Option option;
            SchemaNode schemaNode = this.getChild(names);
            return schemaNode instanceof Option ? (option = (Option)schemaNode) : null;
        }

        public Scope getScope(List<String> names) {
            Scope scope;
            SchemaNode schemaNode = this.getChild(names);
            return schemaNode instanceof Scope ? (scope = (Scope)schemaNode) : null;
        }

        public static Scope of(Class<? extends ConfigScope> scope, String description) {
            HashMap<String, SchemaNode> children = new HashMap<String, SchemaNode>();
            for (Field field : scope.getDeclaredFields()) {
                String name = field.getName();
                Class<?> type = field.getType();
                String desc = SchemaNode.annotatedDescription(field, description);
                PlaceholderName placeholderName = field.getAnnotation(PlaceholderName.class);
                if (field.getAnnotation(ConfigOption.class) != null) {
                    if (DslScope.class.isAssignableFrom(type)) {
                        children.put(name, new DslOption(desc, type));
                        continue;
                    }
                    children.put(name, new Option(desc, SchemaNode.optionType(field)));
                    continue;
                }
                if (ConfigScope.class.isAssignableFrom(type)) {
                    children.put(name, Scope.of(type, desc));
                    continue;
                }
                if (!Map.class.isAssignableFrom(type) || placeholderName == null) continue;
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class valueType = (Class)pt.getActualTypeArguments()[1];
                children.put(name, new Placeholder(desc, placeholderName.value(), Scope.of(valueType, desc)));
            }
            return new Scope(description, children);
        }
    }

    public record Option(String description, Class type) implements SchemaNode
    {
    }

    public record Placeholder(String description, String placeholderName, Scope scope) implements SchemaNode
    {
    }

    public record DslOption(String description, Class dsl) implements SchemaNode
    {
    }
}

