/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.parser;

import groovy.lang.Tuple2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import nextflow.config.ast.ConfigApplyBlockNode;
import nextflow.config.ast.ConfigApplyNode;
import nextflow.config.ast.ConfigAssignNode;
import nextflow.config.ast.ConfigBlockNode;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigIncompleteNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigStatement;
import nextflow.config.parser.ConfigLexer;
import nextflow.config.parser.ConfigParser;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.parser.DescriptiveErrorStrategy;
import nextflow.script.parser.PositionConfigureUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.groovy.parser.antlr4.GroovySyntaxError;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.NodeMetaDataHandler;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class ConfigAstBuilder {
    private SourceUnit sourceUnit;
    private ConfigNode moduleNode;
    private ConfigLexer lexer;
    private ConfigParser parser;
    private Tuple2<ParserRuleContext, Exception> numberFormatError;
    private static final String CALL_STR = "call";
    private static final String SLASH_STR = "/";
    private static final String TDQ_STR = "\"\"\"";
    private static final String TSQ_STR = "'''";
    private static final String SQ_STR = "'";
    private static final String DQ_STR = "\"";
    private static final List<String> GROOVY_KEYWORDS = List.of(Types.getText((int)510), Types.getText((int)585), Types.getText((int)574), Types.getText((int)577), Types.getText((int)531), Types.getText((int)700), Types.getText((int)575), Types.getText((int)578), Types.getText((int)570), Types.getText((int)541), Types.getText((int)511), Types.getText((int)582), Types.getText((int)572), Types.getText((int)701), Types.getText((int)540), Types.getText((int)551), Types.getText((int)532), Types.getText((int)512), Types.getText((int)550), Types.getText((int)500), Types.getText((int)501), Types.getText((int)502), Types.getText((int)521), Types.getText((int)543), Types.getText((int)576), Types.getText((int)520), Types.getText((int)542), Types.getText((int)584), Types.getText((int)513), Types.getText((int)600), Types.getText((int)514), Types.getText((int)571));

    public ConfigAstBuilder(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.moduleNode = new ConfigNode(sourceUnit);
        CharStream charStream = this.createCharStream(sourceUnit);
        this.lexer = new ConfigLexer(charStream);
        this.parser = new ConfigParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        this.parser.setErrorHandler((ANTLRErrorStrategy)new DescriptiveErrorStrategy(charStream));
    }

    private CharStream createCharStream(SourceUnit sourceUnit) {
        try {
            return CharStreams.fromReader((Reader)new BufferedReader(sourceUnit.getSource().getReader()), (String)sourceUnit.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred when reading source code.", e);
        }
    }

    private ConfigParser.CompilationUnitContext buildCST() {
        try {
            TokenStream tokenStream = this.parser.getInputStream();
            try {
                return this.buildCST(PredictionMode.SLL);
            }
            catch (Throwable t) {
                GroovySyntaxError gse;
                if (t instanceof GroovySyntaxError && (gse = (GroovySyntaxError)t).getSource() == 0) {
                    throw t;
                }
                tokenStream.seek(0);
                return this.buildCST(PredictionMode.LL);
            }
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
    }

    private ConfigParser.CompilationUnitContext buildCST(PredictionMode predictionMode) {
        ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(predictionMode);
        this.removeErrorListeners();
        if (predictionMode == PredictionMode.LL) {
            this.addErrorListeners();
        }
        return this.parser.compilationUnit();
    }

    private CompilationFailedException convertException(Throwable t) {
        if (t instanceof CompilationFailedException) {
            CompilationFailedException cfe = (CompilationFailedException)t;
            return cfe;
        }
        if (t instanceof ParseCancellationException) {
            return this.createParsingFailedException(t.getCause());
        }
        return this.createParsingFailedException(t);
    }

    public ModuleNode buildAST() {
        try {
            return this.compilationUnit(this.buildCST());
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
    }

    private ModuleNode compilationUnit(ConfigParser.CompilationUnitContext ctx) {
        for (ConfigParser.ConfigStatementContext configStatementContext : ctx.configStatement()) {
            this.configStatement(configStatementContext);
        }
        this.moduleNode.addStatement((Statement)EmptyStatement.INSTANCE);
        if (this.numberFormatError != null) {
            throw this.createParsingFailedException(((Exception)this.numberFormatError.getV2()).getMessage(), (ParserRuleContext)this.numberFormatError.getV1());
        }
        return this.moduleNode;
    }

    private void configStatement(ConfigParser.ConfigStatementContext ctx) {
        ConfigStatement result;
        if (ctx instanceof ConfigParser.ConfigIncludeStmtAltContext) {
            ConfigParser.ConfigIncludeStmtAltContext ciac = (ConfigParser.ConfigIncludeStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configInclude(ciac.configInclude()), ciac);
        } else if (ctx instanceof ConfigParser.ConfigApplyBlockStmtAltContext) {
            ConfigParser.ConfigApplyBlockStmtAltContext cbac = (ConfigParser.ConfigApplyBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configApplyBlock(cbac.configApplyBlock()), cbac);
        } else if (ctx instanceof ConfigParser.ConfigAssignStmtAltContext) {
            ConfigParser.ConfigAssignStmtAltContext caac = (ConfigParser.ConfigAssignStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configAssign(caac.configAssign()), caac);
        } else if (ctx instanceof ConfigParser.ConfigBlockStmtAltContext) {
            ConfigParser.ConfigBlockStmtAltContext cbac = (ConfigParser.ConfigBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configBlock(cbac.configBlock()), cbac);
        } else if (ctx instanceof ConfigParser.ConfigIncompleteStmtAltContext) {
            ConfigParser.ConfigIncompleteStmtAltContext ciac = (ConfigParser.ConfigIncompleteStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configIncomplete(ciac.configIncomplete()), ciac);
        } else {
            if (ctx instanceof ConfigParser.ConfigInvalidStmtAltContext) {
                ConfigParser.ConfigInvalidStmtAltContext ciac = (ConfigParser.ConfigInvalidStmtAltContext)ctx;
                this.invalidStatement(ciac.invalidStatement());
                return;
            }
            throw this.createParsingFailedException("Invalid statement: " + ctx.getText(), ctx);
        }
        this.saveLeadingComments((ASTNode)result, ctx);
        this.moduleNode.addConfigStatement(result);
    }

    private ConfigStatement configInclude(ConfigParser.ConfigIncludeContext ctx) {
        Expression source = this.expression(ctx.expression());
        return new ConfigIncludeNode(source);
    }

    private ConfigApplyBlockNode configApplyBlock(ConfigParser.ConfigApplyBlockContext ctx) {
        String name = this.configPrimary(ctx.configPrimary());
        List<ConfigApplyNode> statements = ctx.configApply().stream().map(this::configApply).toList();
        ConfigApplyBlockNode result = PositionConfigureUtils.ast(new ConfigApplyBlockNode(name, statements), ctx);
        if (!"plugins".equals(name)) {
            this.collectSyntaxError(new SyntaxException("Config settings must be assigned with an equals sign (`=`)", (ASTNode)result));
        }
        return result;
    }

    private ConfigApplyNode configApply(ConfigParser.ConfigApplyContext ctx) {
        ConstantExpression method = PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.identifier(ctx.identifier())), ctx.identifier());
        Expression arguments = this.argumentList(ctx.argumentList());
        return PositionConfigureUtils.ast(new ConfigApplyNode((Expression)method, arguments), ctx);
    }

    private ConfigStatement configAssign(ConfigParser.ConfigAssignContext ctx) {
        List<String> names = ctx.configAssignPath().configPrimary().stream().map(this::configPrimary).toList();
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(new ConfigAssignNode(names, value), ctx);
    }

    private String configPrimary(ConfigParser.ConfigPrimaryContext ctx) {
        if (ctx.identifier() != null) {
            return this.identifier(ctx.identifier());
        }
        if (ctx.stringLiteral() != null) {
            return this.stringLiteral(ctx.stringLiteral());
        }
        if (ctx.builtInType() != null) {
            return ctx.builtInType().getText();
        }
        throw new IllegalStateException();
    }

    private ConfigStatement configBlock(ConfigParser.ConfigBlockContext ctx) {
        String name = this.configPrimary(ctx.configPrimary());
        List<ConfigStatement> statements = ctx.configBlockStatement().stream().map(this::configBlockStatement).filter(stmt -> stmt != null).toList();
        return new ConfigBlockNode(name, statements);
    }

    private ConfigStatement configBlockStatement(ConfigParser.ConfigBlockStatementContext ctx) {
        ConfigStatement result;
        if (ctx instanceof ConfigParser.ConfigIncludeBlockStmtAltContext) {
            ConfigParser.ConfigIncludeBlockStmtAltContext ciac = (ConfigParser.ConfigIncludeBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configInclude(ciac.configInclude()), ciac);
        } else if (ctx instanceof ConfigParser.ConfigApplyBlockBlockStmtAltContext) {
            ConfigParser.ConfigApplyBlockBlockStmtAltContext cbac = (ConfigParser.ConfigApplyBlockBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configApplyBlock(cbac.configApplyBlock()), cbac);
        } else if (ctx instanceof ConfigParser.ConfigAssignBlockStmtAltContext) {
            ConfigParser.ConfigAssignBlockStmtAltContext caac = (ConfigParser.ConfigAssignBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configAssign(caac.configAssign()), caac);
        } else if (ctx instanceof ConfigParser.ConfigBlockBlockStmtAltContext) {
            ConfigParser.ConfigBlockBlockStmtAltContext cbac = (ConfigParser.ConfigBlockBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configBlock(cbac.configBlock()), cbac);
        } else if (ctx instanceof ConfigParser.ConfigSelectorBlockStmtAltContext) {
            ConfigParser.ConfigSelectorBlockStmtAltContext csac = (ConfigParser.ConfigSelectorBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configSelector(csac.configSelector()), csac);
        } else if (ctx instanceof ConfigParser.ConfigIncompleteBlockStmtAltContext) {
            ConfigParser.ConfigIncompleteBlockStmtAltContext ciac = (ConfigParser.ConfigIncompleteBlockStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.configIncomplete(ciac.configIncomplete()), ciac);
        } else {
            if (ctx instanceof ConfigParser.ConfigInvalidBlockStmtAltContext) {
                ConfigParser.ConfigInvalidBlockStmtAltContext ciac = (ConfigParser.ConfigInvalidBlockStmtAltContext)ctx;
                this.invalidStatement(ciac.invalidStatement());
                return null;
            }
            throw this.createParsingFailedException("Invalid statement in config block: " + ctx.getText(), ctx);
        }
        this.saveLeadingComments((ASTNode)result, ctx);
        return result;
    }

    private ConfigStatement configSelector(ConfigParser.ConfigSelectorContext ctx) {
        String kind = ctx.kind.getText();
        String target = this.configPrimary(ctx.target);
        List<ConfigStatement> statements = ctx.configAssign().stream().map(this::configAssign).toList();
        return new ConfigBlockNode(kind, target, statements);
    }

    private ConfigStatement configIncomplete(ConfigParser.ConfigIncompleteContext ctx) {
        ConfigIncompleteNode result = PositionConfigureUtils.ast(new ConfigIncompleteNode(ctx.getText()), ctx);
        this.collectSyntaxError(new SyntaxException("Incomplete statement", (ASTNode)result));
        return result;
    }

    private void invalidStatement(ConfigParser.InvalidStatementContext ctx) {
        String message = ctx.ifElseStatement() != null ? "If statements cannot be mixed with config statements" : (ctx.tryCatchStatement() != null ? "Try-catch blocks cannot be mixed with config statements" : (ctx.variableDeclaration() != null ? "Variable declarations cannot be mixed with config statements" : "Invalid config statement"));
        this.collectSyntaxError(new SyntaxException(message, (ASTNode)PositionConfigureUtils.ast(new EmptyStatement(), ctx)));
    }

    private Statement statement(ConfigParser.StatementContext ctx) {
        Statement result;
        if (ctx instanceof ConfigParser.IfElseStmtAltContext) {
            ConfigParser.IfElseStmtAltContext ieac = (ConfigParser.IfElseStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.ifElseStatement(ieac.ifElseStatement()), ieac);
        } else if (ctx instanceof ConfigParser.TryCatchStmtAltContext) {
            ConfigParser.TryCatchStmtAltContext tcac = (ConfigParser.TryCatchStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.tryCatchStatement(tcac.tryCatchStatement()), tcac);
        } else if (ctx instanceof ConfigParser.ReturnStmtAltContext) {
            ConfigParser.ReturnStmtAltContext rac = (ConfigParser.ReturnStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.returnStatement(rac.expression()), rac);
        } else if (ctx instanceof ConfigParser.ThrowStmtAltContext) {
            ConfigParser.ThrowStmtAltContext tac = (ConfigParser.ThrowStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.throwStatement(tac.expression()), tac);
        } else if (ctx instanceof ConfigParser.AssertStmtAltContext) {
            ConfigParser.AssertStmtAltContext aac = (ConfigParser.AssertStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assertStatement(aac.assertStatement()), aac);
        } else if (ctx instanceof ConfigParser.VariableDeclarationStmtAltContext) {
            ConfigParser.VariableDeclarationStmtAltContext vdac = (ConfigParser.VariableDeclarationStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.variableDeclaration(vdac.variableDeclaration()), vdac);
        } else if (ctx instanceof ConfigParser.MultipleAssignmentStmtAltContext) {
            ConfigParser.MultipleAssignmentStmtAltContext maac = (ConfigParser.MultipleAssignmentStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assignment(maac.multipleAssignmentStatement()), maac);
        } else if (ctx instanceof ConfigParser.AssignmentStmtAltContext) {
            ConfigParser.AssignmentStmtAltContext aac = (ConfigParser.AssignmentStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assignment(aac.assignmentStatement()), aac);
        } else if (ctx instanceof ConfigParser.ExpressionStmtAltContext) {
            ConfigParser.ExpressionStmtAltContext eac = (ConfigParser.ExpressionStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.expressionStatement(eac.expressionStatement()), eac);
        } else {
            if (ctx instanceof ConfigParser.EmptyStmtAltContext) {
                return EmptyStatement.INSTANCE;
            }
            throw this.createParsingFailedException("Invalid statement: " + ctx.getText(), ctx);
        }
        this.saveLeadingComments((ASTNode)result, ctx);
        return result;
    }

    private Statement ifElseStatement(ConfigParser.IfElseStatementContext ctx) {
        Expression expression = PositionConfigureUtils.ast(this.parExpression(ctx.parExpression()), ctx.parExpression());
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)expression), (ASTNode)expression);
        Statement thenStmt = this.statementOrBlock(ctx.tb);
        EmptyStatement elseStmt = ctx.ELSE() != null ? this.statementOrBlock(ctx.fb) : EmptyStatement.INSTANCE;
        return GeneralUtils.ifElseS((Expression)condition, (Statement)thenStmt, (Statement)elseStmt);
    }

    private Statement statementOrBlock(ConfigParser.StatementOrBlockContext ctx) {
        return ctx.statement() != null ? this.statement(ctx.statement()) : this.blockStatements(ctx.blockStatements());
    }

    private BlockStatement blockStatements(ConfigParser.BlockStatementsContext ctx) {
        if (ctx == null) {
            return GeneralUtils.block((VariableScope)new VariableScope(), Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).toList();
        return PositionConfigureUtils.ast(GeneralUtils.block((VariableScope)new VariableScope(), statements), ctx);
    }

    private Statement tryCatchStatement(ConfigParser.TryCatchStatementContext ctx) {
        Statement tryStatement = this.statementOrBlock(ctx.statementOrBlock());
        List<List> catchClauses = ctx.catchClause().stream().map(this::catchClause).toList();
        TryCatchStatement result = GeneralUtils.tryCatchS((Statement)tryStatement);
        for (List clause : catchClauses) {
            for (CatchStatement stmt : clause) {
                result.addCatch(stmt);
            }
        }
        return result;
    }

    private List<CatchStatement> catchClause(ConfigParser.CatchClauseContext ctx) {
        List<ClassNode> types = this.catchTypes(ctx.catchTypes());
        return types.stream().map((? super T type) -> {
            String name = this.identifier(ctx.identifier());
            Parameter variable = PositionConfigureUtils.ast(GeneralUtils.param((ClassNode)type, (String)name), ctx.identifier());
            this.checkInvalidVarName(name, (ASTNode)variable);
            Statement code = this.statementOrBlock(ctx.statementOrBlock());
            return PositionConfigureUtils.ast(new CatchStatement(variable, code), ctx);
        }).toList();
    }

    private List<ClassNode> catchTypes(ConfigParser.CatchTypesContext ctx) {
        if (ctx == null) {
            return Collections.singletonList(ClassHelper.dynamicType());
        }
        return ctx.qualifiedClassName().stream().map(this::qualifiedClassName).toList();
    }

    private Statement returnStatement(ConfigParser.ExpressionContext ctx) {
        ConstantExpression result = ctx != null ? this.expression(ctx) : ConstantExpression.EMPTY_EXPRESSION;
        return GeneralUtils.returnS((Expression)result);
    }

    private Statement throwStatement(ConfigParser.ExpressionContext ctx) {
        ConstantExpression result = ctx != null ? this.expression(ctx) : ConstantExpression.EMPTY_EXPRESSION;
        return GeneralUtils.throwS((Expression)result);
    }

    private Statement assertStatement(ConfigParser.AssertStatementContext ctx) {
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)this.expression(ctx.condition)), ctx.condition);
        return ctx.message != null ? new AssertStatement(condition, this.expression(ctx.message)) : new AssertStatement(condition);
    }

    private Statement variableDeclaration(ConfigParser.VariableDeclarationContext ctx) {
        if (ctx.variableNames() != null) {
            List<Expression> variables = ctx.variableNames().identifier().stream().map((? super T ident) -> this.variableName((ConfigParser.IdentifierContext)((Object)ident))).toList();
            ArgumentListExpression target = new ArgumentListExpression(variables);
            Expression initializer = this.expression(ctx.initializer);
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.declX((Expression)target, (Expression)initializer), ctx)));
        }
        Expression target = this.variableName(ctx.identifier());
        EmptyExpression initializer = ctx.initializer != null ? this.expression(ctx.initializer) : EmptyExpression.INSTANCE;
        return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.declX((Expression)target, (Expression)initializer), ctx)));
    }

    private Expression variableNames(ConfigParser.VariableNamesContext ctx) {
        List<Expression> vars = ctx.identifier().stream().map(this::variableName).toList();
        return (Expression)PositionConfigureUtils.ast(new TupleExpression(vars), ctx);
    }

    private Expression variableName(ConfigParser.IdentifierContext ctx) {
        String name = this.identifier(ctx);
        VariableExpression result = PositionConfigureUtils.ast(GeneralUtils.varX((String)name), ctx);
        this.checkInvalidVarName(name, (ASTNode)result);
        return result;
    }

    private void checkInvalidVarName(String name, ASTNode node) {
        if (GROOVY_KEYWORDS.contains(name)) {
            this.collectSyntaxError(new SyntaxException("`" + name + "` is not allowed as an identifier because it is a Groovy keyword", node));
        }
    }

    private Statement assignment(ConfigParser.MultipleAssignmentStatementContext ctx) {
        Expression target = this.variableNames(ctx.variableNames());
        Expression source = this.expression(ctx.expression());
        return GeneralUtils.stmt((Expression)PositionConfigureUtils.ast(GeneralUtils.assignX((Expression)target, (Expression)source), ctx));
    }

    private Statement assignment(ConfigParser.AssignmentStatementContext ctx) {
        Expression target = this.expression(ctx.target);
        if (target instanceof VariableExpression && this.isInsideParentheses((NodeMetaDataHandler)target)) {
            if (((Number)target.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL)).intValue() > 1) {
                throw this.createParsingFailedException("Nested parenthesis is not allowed in multiple assignment, e.g. ((a)) = b", ctx);
            }
            TupleExpression tuple = PositionConfigureUtils.ast(new TupleExpression(target), ctx.target);
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.binX((Expression)tuple, (Token)this.token(ctx.op), (Expression)this.expression(ctx.source)), ctx)));
        }
        if (this.isValidAssignmentTarget(target)) {
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.binX((Expression)target, (Token)this.token(ctx.op), (Expression)this.expression(ctx.source)), ctx)));
        }
        throw this.createParsingFailedException("Invalid assignment target -- must be a variable, index, or property expression", ctx);
    }

    private boolean isValidAssignmentTarget(Expression target) {
        BinaryExpression be;
        if (target instanceof VariableExpression && !this.isInsideParentheses((NodeMetaDataHandler)target)) {
            return true;
        }
        if (target instanceof PropertyExpression) {
            return true;
        }
        return target instanceof BinaryExpression && (be = (BinaryExpression)target).getOperation().getType() == 30;
    }

    private Statement expressionStatement(ConfigParser.ExpressionStatementContext ctx) {
        Expression base = this.expression(ctx.expression());
        Expression expression = ctx.argumentList() != null ? this.methodCall(base, this.argumentList(ctx.argumentList())) : base;
        return PositionConfigureUtils.ast(GeneralUtils.stmt((Expression)expression), ctx);
    }

    private Expression expression(ConfigParser.ExpressionContext ctx) {
        if (ctx instanceof ConfigParser.AddSubExprAltContext) {
            ConfigParser.AddSubExprAltContext asac = (ConfigParser.AddSubExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(asac.left, asac.op, asac.right), asac);
        }
        if (ctx instanceof ConfigParser.BitwiseAndExprAltContext) {
            ConfigParser.BitwiseAndExprAltContext baac = (ConfigParser.BitwiseAndExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(baac.left, baac.op, baac.right), baac);
        }
        if (ctx instanceof ConfigParser.BitwiseOrExprAltContext) {
            ConfigParser.BitwiseOrExprAltContext boac = (ConfigParser.BitwiseOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(boac.left, boac.op, boac.right), boac);
        }
        if (ctx instanceof ConfigParser.ConditionalExprAltContext) {
            ConfigParser.ConditionalExprAltContext cac = (ConfigParser.ConditionalExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.ternary(cac), cac);
        }
        if (ctx instanceof ConfigParser.EqualityExprAltContext) {
            ConfigParser.EqualityExprAltContext eac = (ConfigParser.EqualityExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(eac.left, eac.op, eac.right), eac);
        }
        if (ctx instanceof ConfigParser.ExclusiveOrExprAltContext) {
            ConfigParser.ExclusiveOrExprAltContext eoac = (ConfigParser.ExclusiveOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(eoac.left, eoac.op, eoac.right), eoac);
        }
        if (ctx instanceof ConfigParser.LogicalAndExprAltContext) {
            ConfigParser.LogicalAndExprAltContext laac = (ConfigParser.LogicalAndExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(laac.left, laac.op, laac.right), laac);
        }
        if (ctx instanceof ConfigParser.LogicalOrExprAltContext) {
            ConfigParser.LogicalOrExprAltContext loac = (ConfigParser.LogicalOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(loac.left, loac.op, loac.right), loac);
        }
        if (ctx instanceof ConfigParser.MultDivExprAltContext) {
            ConfigParser.MultDivExprAltContext mdac = (ConfigParser.MultDivExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(mdac.left, mdac.op, mdac.right), mdac);
        }
        if (ctx instanceof ConfigParser.PathExprAltContext) {
            ConfigParser.PathExprAltContext pac = (ConfigParser.PathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathExpression(pac), pac);
        }
        if (ctx instanceof ConfigParser.PowerExprAltContext) {
            ConfigParser.PowerExprAltContext pac = (ConfigParser.PowerExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(pac.left, pac.op, pac.right), pac);
        }
        if (ctx instanceof ConfigParser.RegexExprAltContext) {
            ConfigParser.RegexExprAltContext rac = (ConfigParser.RegexExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(rac.left, rac.op, rac.right), rac);
        }
        if (ctx instanceof ConfigParser.RelationalExprAltContext) {
            ConfigParser.RelationalExprAltContext rac = (ConfigParser.RelationalExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(rac.left, rac.op, rac.right), rac);
        }
        if (ctx instanceof ConfigParser.RelationalCastExprAltContext) {
            ConfigParser.RelationalCastExprAltContext rcac = (ConfigParser.RelationalCastExprAltContext)ctx;
            Expression operand = this.expression(rcac.expression());
            ClassNode type = this.type(rcac.type());
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.asX((ClassNode)type, (Expression)operand), rcac);
        }
        if (ctx instanceof ConfigParser.RelationalTypeExprAltContext) {
            ConfigParser.RelationalTypeExprAltContext rtac = (ConfigParser.RelationalTypeExprAltContext)ctx;
            ClassExpression right = PositionConfigureUtils.ast(new ClassExpression(this.type(rtac.type(), false)), rtac.type());
            return PositionConfigureUtils.ast(this.binary(rtac.left, rtac.op, (Expression)right), rtac);
        }
        if (ctx instanceof ConfigParser.ShiftExprAltContext) {
            ConfigParser.ShiftExprAltContext sac = (ConfigParser.ShiftExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.shift(sac), sac);
        }
        if (ctx instanceof ConfigParser.UnaryAddExprAltContext) {
            ConfigParser.UnaryAddExprAltContext uaac = (ConfigParser.UnaryAddExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.unaryAdd(this.expression(uaac.expression()), uaac.op), uaac);
        }
        if (ctx instanceof ConfigParser.UnaryNotExprAltContext) {
            ConfigParser.UnaryNotExprAltContext unac = (ConfigParser.UnaryNotExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.unaryNot(this.expression(unac.expression()), unac.op), unac);
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression binary(ConfigParser.ExpressionContext left, org.antlr.v4.runtime.Token op, ConfigParser.ExpressionContext right) {
        return GeneralUtils.binX((Expression)this.expression(left), (Token)this.token(op), (Expression)this.expression(right));
    }

    private Expression binary(ConfigParser.ExpressionContext left, org.antlr.v4.runtime.Token op, Expression right) {
        return GeneralUtils.binX((Expression)this.expression(left), (Token)this.token(op), (Expression)right);
    }

    private Expression shift(ConfigParser.ShiftExprAltContext ctx) {
        Expression left = this.expression(ctx.left);
        Expression right = this.expression(ctx.right);
        if (ctx.riOp != null) {
            return new RangeExpression(left, right, true);
        }
        if (ctx.reOp != null) {
            return new RangeExpression(left, right, false, true);
        }
        Token op = null;
        if (ctx.dlOp != null) {
            op = this.token(ctx.dlOp, 2);
        }
        if (ctx.dgOp != null) {
            op = this.token(ctx.dgOp, 2);
        }
        if (ctx.tgOp != null) {
            op = this.token(ctx.tgOp, 3);
        }
        return GeneralUtils.binX((Expression)left, (Token)op, (Expression)right);
    }

    private Expression ternary(ConfigParser.ConditionalExprAltContext ctx) {
        if (ctx.ELVIS() != null) {
            return GeneralUtils.elvisX((Expression)this.expression(ctx.condition), (Expression)this.expression(ctx.fb));
        }
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)this.expression(ctx.condition)), ctx.condition);
        return GeneralUtils.ternaryX((Expression)condition, (Expression)this.expression(ctx.tb), (Expression)this.expression(ctx.fb));
    }

    private Expression unaryAdd(Expression expression, org.antlr.v4.runtime.Token op) {
        if (op.getType() == 64) {
            return new UnaryPlusExpression(expression);
        }
        if (op.getType() == 65) {
            return new UnaryMinusExpression(expression);
        }
        throw new IllegalStateException();
    }

    private Expression unaryNot(Expression expression, org.antlr.v4.runtime.Token op) {
        if (op.getType() == 54) {
            return new NotExpression(expression);
        }
        if (op.getType() == 55) {
            return new BitwiseNegationExpression(expression);
        }
        throw new IllegalStateException();
    }

    private Expression pathExpression(ConfigParser.PathExprAltContext ctx) {
        try {
            Expression primary = this.primary(ctx.primary());
            return (Expression)ctx.pathElement().stream().map((? super T el) -> el).reduce(primary, (acc, el) -> this.pathElement((Expression)acc, (ConfigParser.PathElementContext)((Object)((Object)el))));
        }
        catch (IllegalStateException e) {
            throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
        }
    }

    private Expression pathElement(Expression expression, ConfigParser.PathElementContext ctx) {
        if (ctx instanceof ConfigParser.PropertyPathExprAltContext) {
            ConfigParser.PropertyPathExprAltContext pac = (ConfigParser.PropertyPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathPropertyElement(expression, pac), (ASTNode)expression, pac);
        }
        if (ctx instanceof ConfigParser.ClosurePathExprAltContext) {
            ConfigParser.ClosurePathExprAltContext cac = (ConfigParser.ClosurePathExprAltContext)ctx;
            Expression closure = this.closure(cac.closure());
            return PositionConfigureUtils.ast(this.pathClosureElement(expression, closure), (ASTNode)expression, cac);
        }
        if (ctx instanceof ConfigParser.ArgumentsPathExprAltContext) {
            ConfigParser.ArgumentsPathExprAltContext aac = (ConfigParser.ArgumentsPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathArgumentsElement(expression, aac.arguments()), (ASTNode)expression, aac);
        }
        if (ctx instanceof ConfigParser.IndexPathExprAltContext) {
            ConfigParser.IndexPathExprAltContext iac = (ConfigParser.IndexPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathIndexElement(expression, iac.indexPropertyArgs()), (ASTNode)expression, iac);
        }
        throw new IllegalStateException();
    }

    private Expression pathPropertyElement(Expression expression, ConfigParser.PropertyPathExprAltContext ctx) {
        Expression property = this.namedProperty(ctx.namedProperty());
        boolean safe = ctx.SAFE_DOT() != null || ctx.SPREAD_DOT() != null;
        PropertyExpression result = new PropertyExpression(expression, property, safe);
        if (ctx.SPREAD_DOT() != null) {
            result.setSpreadSafe(true);
        }
        return result;
    }

    private Expression namedProperty(ConfigParser.NamedPropertyContext ctx) {
        if (ctx.keywords() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.keywords(ctx.keywords())), ctx);
        }
        if (ctx.identifier() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.identifier(ctx.identifier())), ctx);
        }
        if (ctx.stringLiteral() != null) {
            return (Expression)PositionConfigureUtils.ast(this.string(ctx.stringLiteral()), ctx);
        }
        throw new IllegalStateException();
    }

    private Expression pathClosureElement(Expression expression, Expression closure) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)expression;
            if (!(mce.getArguments() instanceof ArgumentListExpression)) {
                throw new IllegalStateException();
            }
            ArgumentListExpression arguments = (ArgumentListExpression)mce.getArguments();
            arguments.addExpression(closure);
            return mce;
        }
        ArgumentListExpression arguments = PositionConfigureUtils.ast(GeneralUtils.args((Expression[])new Expression[]{closure}), (ASTNode)closure);
        if (expression instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)expression;
            return this.propMethodCall(pe, (Expression)arguments);
        }
        if (this.isConstMethodName(expression)) {
            return this.thisMethodCall(expression, (Expression)arguments);
        }
        return this.callMethodCall(expression, (Expression)arguments);
    }

    private Expression pathArgumentsElement(Expression caller, ConfigParser.ArgumentsContext ctx) {
        Expression arguments = this.argumentList(ctx.argumentList());
        if (ctx.COMMA() != null) {
            arguments.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return PositionConfigureUtils.ast(this.methodCall(caller, arguments), (ASTNode)caller, ctx);
    }

    private Expression pathIndexElement(Expression expression, ConfigParser.IndexPropertyArgsContext ctx) {
        Expression index;
        List<Expression> elements = this.expressionList(ctx.expressionList());
        if (elements.size() > 1) {
            ListExpression list = GeneralUtils.listX(elements);
            list.setWrapped(true);
            index = list;
        } else {
            index = elements.get(0);
        }
        return GeneralUtils.indexX((Expression)expression, (Expression)PositionConfigureUtils.ast(index, ctx));
    }

    private Expression primary(ConfigParser.PrimaryContext ctx) {
        if (ctx instanceof ConfigParser.IdentifierPrmrAltContext) {
            ConfigParser.IdentifierPrmrAltContext iac = (ConfigParser.IdentifierPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.variableName(iac.identifier()), iac);
        }
        if (ctx instanceof ConfigParser.LiteralPrmrAltContext) {
            ConfigParser.LiteralPrmrAltContext lac = (ConfigParser.LiteralPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.literal(lac.literal()), lac);
        }
        if (ctx instanceof ConfigParser.GstringPrmrAltContext) {
            ConfigParser.GstringPrmrAltContext gac = (ConfigParser.GstringPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.gstring(gac.gstring()), gac);
        }
        if (ctx instanceof ConfigParser.NewPrmrAltContext) {
            ConfigParser.NewPrmrAltContext nac = (ConfigParser.NewPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.creator(nac.creator()), nac);
        }
        if (ctx instanceof ConfigParser.ParenPrmrAltContext) {
            ConfigParser.ParenPrmrAltContext pac = (ConfigParser.ParenPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.parExpression(pac.parExpression()), pac);
        }
        if (ctx instanceof ConfigParser.ClosurePrmrAltContext) {
            ConfigParser.ClosurePrmrAltContext cac = (ConfigParser.ClosurePrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.closure(cac.closure()), cac);
        }
        if (ctx instanceof ConfigParser.ListPrmrAltContext) {
            ConfigParser.ListPrmrAltContext lac = (ConfigParser.ListPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.list(lac.list()), lac);
        }
        if (ctx instanceof ConfigParser.MapPrmrAltContext) {
            ConfigParser.MapPrmrAltContext mac = (ConfigParser.MapPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.map(mac.map()), mac);
        }
        if (ctx instanceof ConfigParser.BuiltInTypePrmrAltContext) {
            ConfigParser.BuiltInTypePrmrAltContext bac = (ConfigParser.BuiltInTypePrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.builtInType(bac.builtInType()), bac);
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression builtInType(ConfigParser.BuiltInTypeContext ctx) {
        return GeneralUtils.varX((String)ctx.getText());
    }

    private String identifier(ConfigParser.IdentifierContext ctx) {
        return ctx.getText();
    }

    private String keywords(ConfigParser.KeywordsContext ctx) {
        return ctx.getText();
    }

    private Expression literal(ConfigParser.LiteralContext ctx) {
        if (ctx instanceof ConfigParser.IntegerLiteralAltContext) {
            ConfigParser.IntegerLiteralAltContext iac = (ConfigParser.IntegerLiteralAltContext)ctx;
            return PositionConfigureUtils.ast(this.integerLiteral(iac), iac);
        }
        if (ctx instanceof ConfigParser.FloatingPointLiteralAltContext) {
            ConfigParser.FloatingPointLiteralAltContext fac = (ConfigParser.FloatingPointLiteralAltContext)ctx;
            return PositionConfigureUtils.ast(this.floatingPointLiteral(fac), fac);
        }
        if (ctx instanceof ConfigParser.StringLiteralAltContext) {
            ConfigParser.StringLiteralAltContext sac = (ConfigParser.StringLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(this.string(sac.stringLiteral()), sac);
        }
        if (ctx instanceof ConfigParser.BooleanLiteralAltContext) {
            ConfigParser.BooleanLiteralAltContext bac = (ConfigParser.BooleanLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)"true".equals(bac.getText())), bac);
        }
        if (ctx instanceof ConfigParser.NullLiteralAltContext) {
            ConfigParser.NullLiteralAltContext nac = (ConfigParser.NullLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX(null), nac);
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression integerLiteral(ConfigParser.IntegerLiteralAltContext ctx) {
        String text = ctx.getText();
        Number num = null;
        try {
            num = Numbers.parseInteger((String)text);
        }
        catch (Exception e) {
            this.numberFormatError = new Tuple2((Object)ctx, (Object)e);
        }
        ConstantExpression result = GeneralUtils.constX((Object)num, (boolean)true);
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private Expression floatingPointLiteral(ConfigParser.FloatingPointLiteralAltContext ctx) {
        String text = ctx.getText();
        Number num = null;
        try {
            num = Numbers.parseDecimal((String)text);
        }
        catch (Exception e) {
            this.numberFormatError = new Tuple2((Object)ctx, (Object)e);
        }
        ConstantExpression result = GeneralUtils.constX((Object)num, (boolean)true);
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private ConstantExpression string(ParserRuleContext ctx) {
        String text = ctx.getText();
        ConstantExpression result = GeneralUtils.constX((Object)this.stringLiteral(text));
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private String stringLiteral(ConfigParser.StringLiteralContext ctx) {
        return this.stringLiteral(ctx.getText());
    }

    private String stringLiteral(String text) {
        boolean startsWithSlash = text.startsWith(SLASH_STR);
        if (text.startsWith(TSQ_STR) || text.startsWith(TDQ_STR)) {
            text = StringUtils.removeCR((String)text);
            text = StringUtils.trimQuotations((String)text, (int)3);
        } else if (text.startsWith(SQ_STR) || text.startsWith(DQ_STR) || startsWithSlash) {
            if (startsWithSlash) {
                text = StringUtils.removeCR((String)text);
            }
            text = StringUtils.trimQuotations((String)text, (int)1);
        }
        int slashyType = startsWithSlash ? 1 : 0;
        return StringUtils.replaceEscapes((String)text, (int)slashyType);
    }

    private Expression gstring(ConfigParser.GstringContext ctx) {
        ParserRuleContext eac;
        ParserRuleContext pac;
        ParserRuleContext tac;
        String text = ctx.getText();
        String beginQuotation = this.beginQuotation(text);
        String verbatimText = this.stringLiteral(text);
        GStringBuilder builder = new GStringBuilder();
        for (ConfigParser.GstringDqPartContext gstringDqPartContext : ctx.gstringDqPart()) {
            if (gstringDqPartContext instanceof ConfigParser.GstringDqTextAltContext) {
                tac = (ConfigParser.GstringDqTextAltContext)gstringDqPartContext;
                builder.appendString(PositionConfigureUtils.ast(this.gstringText(tac, beginQuotation), tac));
            }
            if (gstringDqPartContext instanceof ConfigParser.GstringDqPathAltContext) {
                pac = (ConfigParser.GstringDqPathAltContext)gstringDqPartContext;
                builder.appendValue(PositionConfigureUtils.ast(this.gstringPath(pac), pac));
            }
            if (!(gstringDqPartContext instanceof ConfigParser.GstringDqExprAltContext)) continue;
            eac = (ConfigParser.GstringDqExprAltContext)gstringDqPartContext;
            builder.appendValue(this.expression(eac.expression()));
        }
        for (ConfigParser.GstringTdqPartContext gstringTdqPartContext : ctx.gstringTdqPart()) {
            if (gstringTdqPartContext instanceof ConfigParser.GstringTdqTextAltContext) {
                tac = (ConfigParser.GstringTdqTextAltContext)gstringTdqPartContext;
                builder.appendString(PositionConfigureUtils.ast(this.gstringText(tac, beginQuotation), tac));
            }
            if (gstringTdqPartContext instanceof ConfigParser.GstringTdqPathAltContext) {
                pac = (ConfigParser.GstringTdqPathAltContext)gstringTdqPartContext;
                builder.appendValue(PositionConfigureUtils.ast(this.gstringPath(pac), pac));
            }
            if (!(gstringTdqPartContext instanceof ConfigParser.GstringTdqExprAltContext)) continue;
            eac = (ConfigParser.GstringTdqExprAltContext)gstringTdqPartContext;
            builder.appendValue(this.expression(eac.expression()));
        }
        GStringExpression result = builder.build(verbatimText);
        result.putNodeMetaData((Object)ASTNodeMarker.QUOTE_CHAR, (Object)beginQuotation);
        return result;
    }

    private String beginQuotation(String text) {
        if (text.startsWith(TDQ_STR)) {
            return TDQ_STR;
        }
        if (text.startsWith(DQ_STR)) {
            return DQ_STR;
        }
        throw new IllegalStateException();
    }

    private ConstantExpression gstringText(ParserRuleContext ctx, String beginQuotation) {
        String text = ctx.getText();
        String quotedText = new StringBuilder(text).insert(0, beginQuotation).append(beginQuotation).toString();
        ConstantExpression result = GeneralUtils.constX((Object)this.stringLiteral(quotedText));
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private Expression gstringPath(ParserRuleContext ctx) {
        String[] names = ctx.getText().split("\\.");
        int currentLine = ctx.getStart().getLine();
        int currentChar = ctx.getStart().getCharPositionInLine() + 1;
        String varName = names[0].substring(1);
        VariableExpression result = GeneralUtils.varX((String)varName);
        result.setLineNumber(currentLine);
        result.setColumnNumber(++currentChar);
        result.setLastLineNumber(currentLine);
        result.setLastColumnNumber(currentChar += varName.length());
        for (int i = 1; i < names.length; ++i) {
            String propName = names[i];
            ConstantExpression property = GeneralUtils.constX((Object)propName);
            property.setLineNumber(currentLine);
            property.setColumnNumber(++currentChar);
            property.setLastLineNumber(currentLine);
            property.setLastColumnNumber(currentChar += propName.length());
            result = (Expression)PositionConfigureUtils.ast(GeneralUtils.propX((Expression)result, (Expression)property), (ASTNode)result, (ASTNode)property);
        }
        return result;
    }

    private Expression creator(ConfigParser.CreatorContext ctx) {
        ClassNode type = this.createdName(ctx.createdName());
        Expression arguments = this.argumentList(ctx.arguments().argumentList());
        if (ctx.arguments().COMMA() != null) {
            arguments.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return GeneralUtils.ctorX((ClassNode)type, (Expression)arguments);
    }

    private Expression parExpression(ConfigParser.ParExpressionContext ctx) {
        Expression expression = this.expression(ctx.expression());
        ((AtomicInteger)expression.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL, k -> new AtomicInteger())).getAndAdd(1);
        return expression;
    }

    private Expression closure(ConfigParser.ClosureContext ctx) {
        Parameter[] params = this.formalParameterList(ctx.formalParameterList());
        BlockStatement code = this.blockStatements(ctx.blockStatements());
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.closureX((Parameter[])params, (Statement)code), ctx);
    }

    private Expression list(ConfigParser.ListContext ctx) {
        if (ctx.COMMA() != null && ctx.expressionList() == null) {
            throw this.createParsingFailedException("Empty list literal should not contain any comma(,)", ctx.COMMA());
        }
        ListExpression result = GeneralUtils.listX(this.expressionList(ctx.expressionList()));
        if (ctx.COMMA() != null) {
            result.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return result;
    }

    private List<Expression> expressionList(ConfigParser.ExpressionListContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        return ctx.expression().stream().map(this::expression).toList();
    }

    private Expression map(ConfigParser.MapContext ctx) {
        if (ctx.mapEntryList() == null) {
            return new MapExpression();
        }
        List<MapEntryExpression> entries = ctx.mapEntryList().mapEntry().stream().map(this::mapEntry).toList();
        MapExpression result = GeneralUtils.mapX(entries);
        if (ctx.COMMA() != null) {
            result.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return result;
    }

    private MapEntryExpression mapEntry(ConfigParser.MapEntryContext ctx) {
        Expression key = this.mapEntryLabel(ctx.mapEntryLabel());
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(GeneralUtils.entryX((Expression)key, (Expression)value), ctx);
    }

    private Expression mapEntryLabel(ConfigParser.MapEntryLabelContext ctx) {
        if (ctx.keywords() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.keywords(ctx.keywords())), ctx);
        }
        if (ctx.primary() != null) {
            VariableExpression ve;
            Expression expression = this.primary(ctx.primary());
            return expression instanceof VariableExpression && !this.isInsideParentheses((NodeMetaDataHandler)(ve = (VariableExpression)expression)) ? (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)ve.getName()), (ASTNode)ve) : PositionConfigureUtils.ast(expression, ctx);
        }
        throw this.createParsingFailedException("Unsupported map entry label: " + ctx.getText(), ctx);
    }

    private Expression methodCall(Expression caller, Expression arguments) {
        if (this.isInsideParentheses((NodeMetaDataHandler)caller)) {
            return this.callMethodCall(caller, arguments);
        }
        if (caller instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)caller;
            return this.propMethodCall(pe, arguments);
        }
        if (this.isConstMethodName(caller)) {
            return this.thisMethodCall(caller, arguments);
        }
        return this.callMethodCall(caller, arguments);
    }

    private boolean isConstMethodName(Expression caller) {
        ConstantExpression ce;
        if (caller instanceof VariableExpression) {
            return true;
        }
        return caller instanceof ConstantExpression && (ce = (ConstantExpression)caller).getValue() instanceof String;
    }

    private Expression propMethodCall(PropertyExpression caller, Expression arguments) {
        MethodCallExpression result = GeneralUtils.callX((Expression)caller.getObjectExpression(), (Expression)caller.getProperty(), (Expression)arguments);
        result.setImplicitThis(false);
        result.setSafe(caller.isSafe());
        result.setSpreadSafe(caller.isSpreadSafe());
        if (caller.isSpreadSafe()) {
            result.setSafe(false);
        }
        return (Expression)PositionConfigureUtils.ast(result, (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression thisMethodCall(Expression caller, Expression arguments) {
        Expression expression;
        VariableExpression object = VariableExpression.THIS_EXPRESSION;
        object.setColumnNumber(caller.getColumnNumber());
        object.setLineNumber(caller.getLineNumber());
        if (caller instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)caller;
            expression = (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)ve.getText()), (ASTNode)ve);
        } else {
            expression = caller;
        }
        Expression name = expression;
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.callX((Expression)object, (Expression)name, (Expression)arguments), (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression callMethodCall(Expression caller, Expression arguments) {
        MethodCallExpression call = GeneralUtils.callX((Expression)caller, (String)CALL_STR, (Expression)arguments);
        call.setImplicitThis(false);
        return (Expression)PositionConfigureUtils.ast(call, (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression argumentList(ConfigParser.ArgumentListContext ctx) {
        if (ctx == null) {
            return new ArgumentListExpression();
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        ArrayList<MapEntryExpression> namedArgs = new ArrayList<MapEntryExpression>();
        for (ConfigParser.ArgumentListElementContext argumentListElementContext : ctx.argumentListElement()) {
            if (argumentListElementContext.expression() != null) {
                arguments.add(this.expression(argumentListElementContext.expression()));
                continue;
            }
            if (argumentListElementContext.namedArg() == null) continue;
            MapEntryExpression namedArg = this.namedArg(argumentListElementContext.namedArg());
            this.checkDuplicateNamedArg(namedArgs, namedArg);
            namedArgs.add(namedArg);
        }
        if (!namedArgs.isEmpty()) {
            arguments.add(0, new NamedArgumentListExpression(namedArgs));
        }
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.args(arguments), ctx);
    }

    private MapEntryExpression namedArg(ConfigParser.NamedArgContext ctx) {
        Expression key = this.namedProperty(ctx.namedProperty());
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(new MapEntryExpression(key, value), ctx);
    }

    private void checkDuplicateNamedArg(List<MapEntryExpression> namedArgs, MapEntryExpression namedArg) {
        String name = namedArg.getKeyExpression().getText();
        for (MapEntryExpression arg : namedArgs) {
            if (!arg.getKeyExpression().getText().equals(name)) continue;
            throw this.createParsingFailedException("Duplicated named argument '" + name + "' found", (ASTNode)namedArg);
        }
    }

    private Parameter[] formalParameterList(ConfigParser.FormalParameterListContext ctx) {
        if (ctx == null) {
            return Parameter.EMPTY_ARRAY;
        }
        List<Parameter> params = ctx.formalParameter().stream().map(this::formalParameter).toList();
        int n = params.size();
        for (int i = n - 1; i >= 0; --i) {
            Parameter param = params.get(i);
            for (Parameter other : params) {
                if (other == param || !other.getName().equals(param.getName())) continue;
                throw this.createParsingFailedException("Duplicated parameter '" + param.getName() + "' found", (ASTNode)param);
            }
        }
        return params.toArray(Parameter.EMPTY_ARRAY);
    }

    private Parameter formalParameter(ConfigParser.FormalParameterContext ctx) {
        ClassNode type = ClassHelper.dynamicType();
        String name = this.identifier(ctx.identifier());
        Expression defaultValue = ctx.expression() != null ? this.expression(ctx.expression()) : null;
        Parameter result = PositionConfigureUtils.ast(GeneralUtils.param((ClassNode)type, (String)name, (Expression)defaultValue), ctx);
        this.checkInvalidVarName(name, (ASTNode)result);
        result.putNodeMetaData((Object)"_START_NAME", (Object)PositionConfigureUtils.tokenPosition(ctx.identifier()));
        return result;
    }

    private Token token(org.antlr.v4.runtime.Token token) {
        return this.token(token, 1);
    }

    private Token token(org.antlr.v4.runtime.Token token, int cardinality) {
        String tokenText = token.getText();
        int tokenType = token.getType();
        String text = cardinality == 1 ? tokenText : tokenText.repeat(cardinality);
        int type = tokenType == 31 || tokenType == 30 ? 1104 : Types.lookup((String)text, (int)1000);
        return new Token(type, text, token.getLine(), token.getCharPositionInLine() + 1);
    }

    private ClassNode createdName(ConfigParser.CreatedNameContext ctx) {
        if (ctx.qualifiedClassName() != null) {
            ClassNode classNode = this.qualifiedClassName(ctx.qualifiedClassName());
            if (ctx.typeArguments() != null) {
                classNode.setGenericsTypes(this.typeArguments(ctx.typeArguments()));
            }
            return classNode;
        }
        if (ctx.primitiveType() != null) {
            return this.primitiveType(ctx.primitiveType());
        }
        throw this.createParsingFailedException("Unrecognized created name: " + ctx.getText(), ctx);
    }

    private ClassNode primitiveType(ConfigParser.PrimitiveTypeContext ctx) {
        ClassNode classNode = ClassHelper.make((String)ctx.getText()).getPlainNodeReference(false);
        return PositionConfigureUtils.ast(classNode, ctx);
    }

    private ClassNode qualifiedClassName(ConfigParser.QualifiedClassNameContext ctx) {
        return this.qualifiedClassName(ctx, true);
    }

    private ClassNode qualifiedClassName(ConfigParser.QualifiedClassNameContext ctx, boolean allowProxy) {
        String text = ctx.getText();
        ClassNode classNode = ClassHelper.make((String)text);
        if (text.contains(".")) {
            classNode.putNodeMetaData((Object)ASTNodeMarker.FULLY_QUALIFIED, (Object)true);
        }
        if (classNode.isUsingGenerics() && allowProxy) {
            ClassNode proxy = ClassHelper.makeWithoutCaching((String)classNode.getName());
            proxy.setRedirect(classNode);
            return proxy;
        }
        return PositionConfigureUtils.ast(classNode, ctx);
    }

    private ClassNode type(ConfigParser.TypeContext ctx) {
        return this.type(ctx, true);
    }

    private ClassNode type(ConfigParser.TypeContext ctx, boolean allowProxy) {
        if (ctx == null) {
            return ClassHelper.dynamicType();
        }
        if (ctx.qualifiedClassName() != null) {
            ClassNode classNode = this.qualifiedClassName(ctx.qualifiedClassName(), allowProxy);
            if (ctx.typeArguments() != null) {
                classNode.setGenericsTypes(this.typeArguments(ctx.typeArguments()));
            }
            return classNode;
        }
        if (ctx.primitiveType() != null) {
            return this.primitiveType(ctx.primitiveType());
        }
        throw this.createParsingFailedException("Unrecognized type: " + ctx.getText(), ctx);
    }

    private GenericsType[] typeArguments(ConfigParser.TypeArgumentsContext ctx) {
        return (GenericsType[])ctx.type().stream().map(this::genericsType).toArray(GenericsType[]::new);
    }

    private GenericsType genericsType(ConfigParser.TypeContext ctx) {
        return PositionConfigureUtils.ast(new GenericsType(this.type(ctx)), ctx);
    }

    private void saveLeadingComments(ASTNode node, ParserRuleContext ctx) {
        ArrayList<String> comments = new ArrayList<String>();
        ParserRuleContext child = ctx;
        while (this.saveLeadingComments0(child, comments)) {
            child = child.getParent();
        }
        if (!comments.isEmpty()) {
            node.putNodeMetaData((Object)ASTNodeMarker.LEADING_COMMENTS, comments);
        }
    }

    private boolean saveLeadingComments0(ParserRuleContext ctx, List<String> comments) {
        String last;
        ParseTree sibling;
        int i;
        ParserRuleContext parent = ctx.getParent();
        if (parent == null) {
            return false;
        }
        List siblings = parent.children;
        for (i = 0; i < siblings.size() && siblings.get(i) != ctx; ++i) {
        }
        if (i == 0) {
            return true;
        }
        boolean added = false;
        for (int j = i - 1; j >= 0 && ((sibling = (ParseTree)siblings.get(j)) instanceof ConfigParser.NlsContext || sibling instanceof ConfigParser.SepContext); --j) {
            List<? extends TerminalNode> newlines = sibling instanceof ConfigParser.NlsContext ? ((ConfigParser.NlsContext)sibling).NL() : ((ConfigParser.SepContext)sibling).NL();
            for (int k = newlines.size() - 1; k >= 0; --k) {
                String text = newlines.get(k).getText();
                comments.add(text);
                added = true;
            }
        }
        if (added && "\n".equals(last = comments.get(comments.size() - 1))) {
            comments.remove(comments.size() - 1);
        }
        return false;
    }

    private boolean isInsideParentheses(NodeMetaDataHandler nodeMetaDataHandler) {
        Number insideParenLevel = (Number)nodeMetaDataHandler.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL);
        return insideParenLevel != null && insideParenLevel.intValue() > 0;
    }

    private CompilationFailedException createParsingFailedException(String msg, ParserRuleContext ctx) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, ctx.start.getLine(), ctx.start.getCharPositionInLine() + 1, ctx.stop.getLine(), ctx.stop.getCharPositionInLine() + 1 + ctx.stop.getText().length()));
    }

    private CompilationFailedException createParsingFailedException(String msg, Tuple2<Integer, Integer> start, Tuple2<Integer, Integer> end) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, ((Integer)start.getV1()).intValue(), ((Integer)start.getV2()).intValue(), ((Integer)end.getV1()).intValue(), ((Integer)end.getV2()).intValue()));
    }

    private CompilationFailedException createParsingFailedException(String msg, ASTNode node) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()));
    }

    private CompilationFailedException createParsingFailedException(String msg, TerminalNode node) {
        return this.createParsingFailedException(msg, node.getSymbol());
    }

    private CompilationFailedException createParsingFailedException(String msg, org.antlr.v4.runtime.Token token) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, token.getLine(), token.getCharPositionInLine() + 1, token.getLine(), token.getCharPositionInLine() + 1 + token.getText().length()));
    }

    private CompilationFailedException createParsingFailedException(Throwable t) {
        if (t instanceof SyntaxException) {
            SyntaxException se = (SyntaxException)t;
            this.collectSyntaxError(se);
        } else if (t instanceof GroovySyntaxError) {
            GroovySyntaxError gse = (GroovySyntaxError)t;
            this.collectSyntaxError(new SyntaxException(gse.getMessage(), (Throwable)gse, gse.getLine(), gse.getColumn()));
        } else if (t instanceof Exception) {
            Exception e = (Exception)t;
            this.collectException(e);
        }
        return new CompilationFailedException(CompilePhase.PARSING.getPhaseNumber(), (ProcessingUnit)this.sourceUnit, t);
    }

    private void collectSyntaxError(SyntaxException e) {
        this.sourceUnit.getErrorCollector().addFatalError((Message)new SyntaxErrorMessage(e, this.sourceUnit));
    }

    private void collectException(Exception e) {
        this.sourceUnit.getErrorCollector().addException(e, this.sourceUnit);
    }

    private void removeErrorListeners() {
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
    }

    private void addErrorListeners() {
        this.lexer.addErrorListener(this.createANTLRErrorListener());
        this.parser.addErrorListener(this.createANTLRErrorListener());
    }

    private ANTLRErrorListener createANTLRErrorListener() {
        return new ANTLRErrorListener(){

            public void syntaxError(Recognizer recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                ConfigAstBuilder.this.collectSyntaxError(new SyntaxException(msg, line, charPositionInLine + 1));
            }
        };
    }

    private static class GStringBuilder {
        private final List<ConstantExpression> strings = new ArrayList<ConstantExpression>();
        private final List<Expression> values = new ArrayList<Expression>();
        private boolean appendEmptyString = true;

        private GStringBuilder() {
        }

        public void appendString(ConstantExpression string) {
            this.strings.add(string);
            this.appendEmptyString = false;
        }

        public void appendValue(Expression value) {
            if (this.appendEmptyString) {
                this.appendString(GeneralUtils.constX((Object)""));
            }
            this.values.add(value);
            this.appendEmptyString = true;
        }

        public GStringExpression build(String verbatimText) {
            return new GStringExpression(verbatimText, this.strings, this.values);
        }
    }
}

