/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.formatter;

import java.util.regex.Pattern;
import nextflow.config.ast.ConfigApplyBlockNode;
import nextflow.config.ast.ConfigApplyNode;
import nextflow.config.ast.ConfigAssignNode;
import nextflow.config.ast.ConfigBlockNode;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigStatement;
import nextflow.config.ast.ConfigVisitorSupport;
import nextflow.script.formatter.Formatter;
import nextflow.script.formatter.FormattingOptions;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;

public class ConfigFormattingVisitor
extends ConfigVisitorSupport {
    private SourceUnit sourceUnit;
    private FormattingOptions options;
    private Formatter fmt;
    private static final Pattern IDENTIFIER = Pattern.compile("[a-zA-Z_]+[a-zA-Z0-9_]*");
    private int currentAlignmentWidth = 0;

    public ConfigFormattingVisitor(SourceUnit sourceUnit, FormattingOptions options) {
        this.sourceUnit = sourceUnit;
        this.options = options;
        this.fmt = new Formatter(options);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ConfigNode) {
            ConfigNode cn = (ConfigNode)moduleNode;
            super.visit(cn);
        }
    }

    public String toString() {
        return this.fmt.toString();
    }

    @Override
    public void visitConfigApplyBlock(ConfigApplyBlockNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.appendIndent();
        this.fmt.append(node.name);
        this.fmt.append(" {");
        this.fmt.appendNewLine();
        this.fmt.incIndent();
        super.visitConfigApplyBlock(node);
        this.fmt.decIndent();
        this.fmt.appendIndent();
        this.fmt.append('}');
        this.fmt.appendNewLine();
    }

    @Override
    public void visitConfigApply(ConfigApplyNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.visitDirective(node);
    }

    @Override
    public void visitConfigAssign(ConfigAssignNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.appendIndent();
        String name = String.join((CharSequence)".", node.names);
        this.fmt.append(name);
        if (this.currentAlignmentWidth > 0) {
            int padding = this.currentAlignmentWidth - name.length();
            this.fmt.append(" ".repeat(padding));
        }
        this.fmt.append(" = ");
        this.fmt.visit(node.value);
        this.fmt.appendNewLine();
    }

    @Override
    public void visitConfigBlock(ConfigBlockNode node) {
        String name;
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.appendIndent();
        if (node.kind != null) {
            this.fmt.append(node.kind);
            this.fmt.append(": ");
        }
        if (IDENTIFIER.matcher(name = node.name).matches()) {
            this.fmt.append(name);
        } else {
            this.fmt.append('\'');
            this.fmt.append(name);
            this.fmt.append('\'');
        }
        this.fmt.append(" {");
        this.fmt.appendNewLine();
        int caw = this.currentAlignmentWidth;
        if (this.options.harshilAlignment()) {
            int maxWidth = 0;
            for (ConfigStatement stmt : node.statements) {
                if (!(stmt instanceof ConfigAssignNode)) continue;
                ConfigAssignNode can = (ConfigAssignNode)stmt;
                int width = String.join((CharSequence)".", can.names).length();
                if (maxWidth >= width) continue;
                maxWidth = width;
            }
            this.currentAlignmentWidth = maxWidth;
        }
        this.fmt.incIndent();
        super.visitConfigBlock(node);
        this.fmt.decIndent();
        if (this.options.harshilAlignment()) {
            this.currentAlignmentWidth = caw;
        }
        this.fmt.appendIndent();
        this.fmt.append('}');
        this.fmt.appendNewLine();
    }

    @Override
    public void visitConfigInclude(ConfigIncludeNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.appendIndent();
        this.fmt.append("includeConfig ");
        this.fmt.visit(node.source);
        this.fmt.appendNewLine();
    }
}

