/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import nextflow.config.ast.ConfigApplyBlockNode;
import nextflow.config.ast.ConfigApplyNode;
import nextflow.config.ast.ConfigAssignNode;
import nextflow.config.ast.ConfigBlockNode;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigVisitorSupport;
import nextflow.config.dsl.ConfigDsl;
import nextflow.config.schema.SchemaNode;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.control.VariableScopeChecker;
import nextflow.script.dsl.ProcessDsl;
import nextflow.script.dsl.ScriptDsl;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Types;

class VariableScopeVisitor
extends ConfigVisitorSupport {
    private SourceUnit sourceUnit;
    private VariableScopeChecker vsc;
    private Stack<String> configScopes = new Stack();
    private static final List<String> KEYWORDS = List.of("case", "for", "switch", "while");

    public VariableScopeVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.vsc = new VariableScopeChecker(sourceUnit, new ClassNode(ConfigDsl.class));
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ConfigNode) {
            ConfigNode cn = (ConfigNode)moduleNode;
            super.visit(cn);
            this.vsc.checkUnusedVariables();
        }
    }

    @Override
    public void visitConfigApplyBlock(ConfigApplyBlockNode node) {
        this.configScopes.add(node.name);
        List<String> names = this.currentConfigScopes();
        SchemaNode.DslOption option = SchemaNode.ROOT.getDslOption(names);
        if (option != null) {
            this.vsc.pushScope(option.dsl());
            super.visitConfigApplyBlock(node);
            this.vsc.popScope();
        }
        this.configScopes.pop();
    }

    @Override
    public void visitConfigApply(ConfigApplyNode node) {
        this.checkMethodCall(node);
    }

    @Override
    public void visitConfigAssign(ConfigAssignNode node) {
        for (int i = 0; i < node.names.size() - 1; ++i) {
            this.configScopes.add(node.names.get(i));
        }
        List<String> scopes = this.currentConfigScopes();
        boolean inProcess = !scopes.isEmpty() && "process".equals(scopes.get(0));
        boolean inClosure = node.value instanceof ClosureExpression;
        if (inClosure && !inProcess && !VariableScopeVisitor.isWorkflowHandler(scopes, node)) {
            this.vsc.addError("Dynamic config options are only allowed in the `process` scope", (ASTNode)node);
        }
        if (inClosure) {
            this.vsc.pushScope(ScriptDsl.class);
            if (inProcess) {
                this.vsc.pushScope(ProcessDsl.class);
            }
        }
        super.visitConfigAssign(node);
        if (inClosure) {
            if (inProcess) {
                this.vsc.popScope();
            }
            this.vsc.popScope();
        }
        for (int i = 0; i < node.names.size() - 1; ++i) {
            this.configScopes.pop();
        }
    }

    private static boolean isWorkflowHandler(List<String> scopes, ConfigAssignNode node) {
        String option = node.names.get(node.names.size() - 1);
        return scopes.size() == 1 && "workflow".equals(scopes.get(0)) && List.of("onComplete", "onError").contains(option);
    }

    @Override
    public void visitConfigBlock(ConfigBlockNode node) {
        boolean newScope;
        boolean bl = newScope = node.kind == null;
        if (newScope) {
            this.configScopes.add(node.name);
        }
        super.visitConfigBlock(node);
        if (newScope) {
            this.configScopes.remove(this.configScopes.size() - 1);
        }
    }

    @Override
    public void visitConfigInclude(ConfigIncludeNode node) {
        this.checkConfigInclude(node);
        this.visit(node.source);
    }

    private void checkConfigInclude(ConfigIncludeNode node) {
        if (this.configScopes.isEmpty()) {
            return;
        }
        if (this.configScopes.size() == 2 && "profiles".equals(this.configScopes.get(0))) {
            return;
        }
        this.vsc.addError("Config includes are only allowed at the top-level or in a profile", (ASTNode)node);
    }

    public void visitBlockStatement(BlockStatement node) {
        boolean newScope;
        boolean bl = newScope = node.getVariableScope() != null;
        if (newScope) {
            this.vsc.pushScope();
        }
        node.setVariableScope(this.currentScope());
        super.visitBlockStatement(node);
        if (newScope) {
            this.vsc.popScope();
        }
    }

    public void visitCatchStatement(CatchStatement node) {
        this.vsc.pushScope();
        this.vsc.declare((Variable)node.getVariable(), (ASTNode)node);
        super.visitCatchStatement(node);
        this.vsc.popScope();
    }

    public void visitExpressionStatement(ExpressionStatement node) {
        BinaryExpression be;
        Expression exp = node.getExpression();
        if (exp instanceof BinaryExpression && Types.isAssignment((int)(be = (BinaryExpression)exp).getOperation().getType())) {
            Expression source = be.getRightExpression();
            Expression target = be.getLeftExpression();
            this.visit(source);
            if (!this.checkImplicitDeclaration(target)) {
                this.visit(target);
            }
            return;
        }
        super.visitExpressionStatement(node);
    }

    private boolean checkImplicitDeclaration(Expression node) {
        if (node instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)node;
            boolean result = false;
            for (Expression el : te.getExpressions()) {
                result |= this.declareAssignedVariable((VariableExpression)el);
            }
            return result;
        }
        if (node instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)node;
            return this.declareAssignedVariable(ve);
        }
        return false;
    }

    private boolean declareAssignedVariable(VariableExpression ve) {
        Variable variable = this.vsc.findVariableDeclaration(ve.getName(), (ASTNode)ve);
        if (variable != null) {
            ve.setAccessedVariable(variable);
            return false;
        }
        this.vsc.addError("`" + ve.getName() + "` was assigned but not declared", (ASTNode)ve);
        return true;
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression node) {
        this.checkMethodCall(node);
        super.visitMethodCallExpression(node);
    }

    private void checkMethodCall(MethodCallExpression node) {
        if (!node.isImplicitThis()) {
            return;
        }
        String name = node.getMethodAsString();
        MethodNode defNode = this.vsc.findDslFunction(name, (ASTNode)node);
        if (defNode != null) {
            node.putNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET, (Object)defNode);
        } else if (!KEYWORDS.contains(name)) {
            this.vsc.addError("`" + name + "` is not defined", (ASTNode)node.getMethod());
        }
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.visit(node.getRightExpression());
        if (node.isMultipleAssignmentDeclaration()) {
            for (Expression el : node.getTupleExpression()) {
                this.vsc.declare((VariableExpression)el);
            }
        } else {
            this.vsc.declare(node.getVariableExpression());
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        this.vsc.pushScope();
        node.setVariableScope(this.currentScope());
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                this.vsc.declare((Variable)parameter, (ASTNode)parameter);
                if (!parameter.hasInitialExpression()) continue;
                this.visit(parameter.getInitialExpression());
            }
        }
        super.visitClosureExpression(node);
        Iterator it = this.currentScope().getReferencedLocalVariablesIterator();
        while (it.hasNext()) {
            Variable variable = (Variable)it.next();
            variable.setClosureSharedVariable(true);
        }
        this.vsc.popScope();
    }

    public void visitVariableExpression(VariableExpression node) {
        String name = node.getName();
        Variable variable = this.vsc.findVariableDeclaration(name, (ASTNode)node);
        if (variable == null) {
            if ("it".equals(name)) {
                this.vsc.addParanoidWarning("Implicit closure parameter `it` will not be supported in a future version", (ASTNode)node);
            } else {
                variable = new DynamicVariable(name, false);
            }
        }
        if (variable != null) {
            node.setAccessedVariable(variable);
        }
    }

    private VariableScope currentScope() {
        return this.vsc.getCurrentScope();
    }

    private List<String> currentConfigScopes() {
        ArrayList<String> names = new ArrayList<String>(this.configScopes);
        if (!names.isEmpty() && "profiles".equals(names.get(0))) {
            if (!names.isEmpty()) {
                names.remove(0);
            }
            if (!names.isEmpty()) {
                names.remove(0);
            }
        }
        return names;
    }
}

