/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.control;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigVisitorSupport;
import nextflow.script.control.PhaseAware;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ResolveIncludeVisitor
extends ConfigVisitorSupport {
    private SourceUnit sourceUnit;
    private URI uri;
    private List<SyntaxErrorMessage> errors = new ArrayList<SyntaxErrorMessage>();

    public ResolveIncludeVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.uri = sourceUnit.getSource().getURI();
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ConfigNode) {
            ConfigNode cn = (ConfigNode)moduleNode;
            super.visit(cn);
        }
    }

    @Override
    public void visitConfigInclude(ConfigIncludeNode node) {
        if (!(node.source instanceof ConstantExpression)) {
            return;
        }
        String source = node.source.getText();
        URI includeUri = ResolveIncludeVisitor.getIncludeUri(this.uri, source);
        if (!ResolveIncludeVisitor.isIncludeLocal(includeUri)) {
            return;
        }
        if (!Files.exists(Path.of(includeUri), new LinkOption[0])) {
            this.addError("Invalid include source: '" + includeUri.getPath() + "'", (ASTNode)node);
            return;
        }
    }

    protected static URI getIncludeUri(URI uri, String source) {
        return Path.of(uri).getParent().resolve(source).normalize().toUri();
    }

    protected static boolean isIncludeLocal(URI includeUri) {
        return "file".equals(includeUri.getScheme());
    }

    public void addError(String message, ASTNode node) {
        ResolveIncludeError cause = new ResolveIncludeError(message, node);
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage((SyntaxException)cause, this.sourceUnit);
        this.errors.add(errorMessage);
    }

    public List<SyntaxErrorMessage> getErrors() {
        return this.errors;
    }

    private class ResolveIncludeError
    extends SyntaxException
    implements PhaseAware {
        public ResolveIncludeError(String message, ASTNode node) {
            super(message, node);
        }

        @Override
        public int getPhase() {
            return 2;
        }
    }
}

