/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.control;

import java.util.ArrayList;
import java.util.stream.Collectors;
import nextflow.config.ast.ConfigApplyBlockNode;
import nextflow.config.ast.ConfigApplyNode;
import nextflow.config.ast.ConfigAssignNode;
import nextflow.config.ast.ConfigBlockNode;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigStatement;
import nextflow.config.ast.ConfigVisitorSupport;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;

public class ConfigToGroovyVisitor
extends ConfigVisitorSupport {
    private SourceUnit sourceUnit;
    private ConfigNode moduleNode;

    public ConfigToGroovyVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.moduleNode = (ConfigNode)sourceUnit.getAST();
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        if (this.moduleNode == null) {
            return;
        }
        super.visit(this.moduleNode);
        if (this.moduleNode.isEmpty()) {
            this.moduleNode.addStatement((Statement)ReturnStatement.RETURN_NULL_OR_VOID);
        }
    }

    @Override
    public void visitConfigApplyBlock(ConfigApplyBlockNode node) {
        this.moduleNode.addStatement(this.transformConfigApplyBlock(node));
    }

    protected Statement transformConfigApplyBlock(ConfigApplyBlockNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (ConfigApplyNode call : node.statements) {
            statements.add(GeneralUtils.stmt((Expression)call));
        }
        BlockStatement code = GeneralUtils.block((VariableScope)new VariableScope(), statements);
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"block", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)node.name), GeneralUtils.closureX((Statement)code)})));
    }

    @Override
    public void visitConfigAssign(ConfigAssignNode node) {
        this.moduleNode.addStatement(this.transformConfigAssign(node));
    }

    protected Statement transformConfigAssign(ConfigAssignNode node) {
        ListExpression names = GeneralUtils.listX(node.names.stream().map(name -> GeneralUtils.constX((Object)name)).collect(Collectors.toList()));
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"assign", (Expression)GeneralUtils.args((Expression[])new Expression[]{names, node.value})));
    }

    @Override
    public void visitConfigBlock(ConfigBlockNode node) {
        this.moduleNode.addStatement(this.transformConfigBlock(node));
    }

    protected Statement transformConfigBlock(ConfigBlockNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (ConfigStatement stmt : node.statements) {
            if (stmt instanceof ConfigAssignNode) {
                ConfigAssignNode can = (ConfigAssignNode)stmt;
                statements.add(this.transformConfigAssign(can));
                continue;
            }
            if (stmt instanceof ConfigBlockNode) {
                ConfigBlockNode cbn = (ConfigBlockNode)stmt;
                statements.add(this.transformConfigBlock(cbn));
                continue;
            }
            if (!(stmt instanceof ConfigIncludeNode)) continue;
            ConfigIncludeNode cin = (ConfigIncludeNode)stmt;
            statements.add(this.transformConfigInclude(cin));
        }
        BlockStatement code = GeneralUtils.block((VariableScope)new VariableScope(), statements);
        String kind = node.kind != null ? node.kind : "block";
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)kind, (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)node.name), GeneralUtils.closureX((Statement)code)})));
    }

    @Override
    public void visitConfigInclude(ConfigIncludeNode node) {
        this.moduleNode.addStatement(this.transformConfigInclude(node));
    }

    protected Statement transformConfigInclude(ConfigIncludeNode node) {
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"includeConfig", (Expression)GeneralUtils.args((Expression[])new Expression[]{node.source})));
    }
}

