/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.control;

import java.util.Collections;
import java.util.List;
import nextflow.config.ast.ConfigAssignNode;
import nextflow.config.ast.ConfigIncludeNode;
import nextflow.config.ast.ConfigNode;
import nextflow.config.ast.ConfigVisitorSupport;
import nextflow.config.control.VariableScopeVisitor;
import nextflow.script.control.ResolveVisitor;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class ConfigResolveVisitor
extends ConfigVisitorSupport {
    private SourceUnit sourceUnit;
    private ResolveVisitor resolver;

    public ConfigResolveVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit, List<ClassNode> defaultImports) {
        this.sourceUnit = sourceUnit;
        this.resolver = new ResolveVisitor(sourceUnit, compilationUnit, defaultImports, Collections.emptyList());
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ConfigNode) {
            ConfigNode cn = (ConfigNode)moduleNode;
            new VariableScopeVisitor(this.sourceUnit).visit();
            super.visit(cn);
            new DynamicVariablesVisitor().visit(cn);
        }
    }

    @Override
    public void visitConfigAssign(ConfigAssignNode node) {
        node.value = this.resolver.transform(node.value);
    }

    @Override
    public void visitConfigInclude(ConfigIncludeNode node) {
        node.source = this.resolver.transform(node.source);
    }

    private class DynamicVariablesVisitor
    extends ConfigVisitorSupport {
        private DynamicVariablesVisitor() {
        }

        protected SourceUnit getSourceUnit() {
            return ConfigResolveVisitor.this.sourceUnit;
        }

        public void visitVariableExpression(VariableExpression node) {
            Variable variable = node.getAccessedVariable();
            if (variable instanceof DynamicVariable) {
                ConfigResolveVisitor.this.resolver.addError("`" + node.getName() + "` is not defined", (ASTNode)node);
            }
        }
    }
}

