/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import nextflow.config.control.ConfigResolveVisitor;
import nextflow.config.control.ResolveIncludeVisitor;
import nextflow.config.parser.ConfigParserPluginFactory;
import nextflow.script.control.Compiler;
import nextflow.script.types.Types;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;

public class ConfigParser {
    private Compiler compiler;

    public ConfigParser() {
        CompilerConfiguration config = ConfigParser.getConfig();
        GroovyClassLoader classLoader = new GroovyClassLoader();
        this.compiler = new Compiler(config, classLoader);
    }

    public Compiler compiler() {
        return this.compiler;
    }

    public SourceUnit parse(File file) {
        SourceUnit source = this.compiler.createSourceUnit(file);
        this.compiler.addSource(source);
        this.compiler.compile(source);
        return source;
    }

    public SourceUnit parse(String name, String contents) {
        SourceUnit source = this.compiler.createSourceUnit(name, contents);
        this.compiler.addSource(source);
        this.compiler.compile(source);
        return source;
    }

    public void analyze() {
        for (SourceUnit source : this.compiler.getSources().values()) {
            ResolveIncludeVisitor includeResolver = new ResolveIncludeVisitor(source);
            includeResolver.visit();
            for (SyntaxErrorMessage error : includeResolver.getErrors()) {
                source.getErrorCollector().addErrorAndContinue((Message)error);
            }
            new ConfigResolveVisitor(source, this.compiler.compilationUnit(), Types.DEFAULT_CONFIG_IMPORTS).visit();
        }
    }

    private static CompilerConfiguration getConfig() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setPluginFactory((ParserPluginFactory)new ConfigParserPluginFactory());
        config.setWarningLevel(2);
        return config;
    }
}

