/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;

public class BigIntegers {
    public static byte[] toLittleEndianByteArray(BigInteger value) {
        return ArrayUtils.reverseArray(value.toByteArray());
    }

    public static byte[] toLittleEndianByteArray(int value) {
        return BigIntegers.toLittleEndianByteArray(BigInteger.valueOf(value));
    }

    public static byte[] toLittleEndianByteArrayZeroPadded(BigInteger value, int length) {
        byte[] bytes = value.toByteArray();
        if (bytes.length > length) {
            throw new IllegalArgumentException("given integer needs more space (" + bytes.length + " bytes) than the given minimum length (" + length + " bytes).");
        }
        if (bytes.length < length) {
            byte[] temp = new byte[length];
            System.arraycopy(bytes, 0, temp, length - bytes.length, bytes.length);
            return ArrayUtils.reverseArray(temp);
        }
        return ArrayUtils.reverseArray(bytes);
    }

    public static byte[] toLittleEndianByteArrayZeroPadded(int value, int minByteLength) {
        return BigIntegers.toLittleEndianByteArrayZeroPadded(BigInteger.valueOf(value), minByteLength);
    }

    public static BigInteger fromLittleEndianByteArray(byte[] value) {
        return new BigInteger(ArrayUtils.reverseArray(value));
    }

    public static BigInteger fromBigEndianHexString(String value) {
        return new BigInteger(Numeric.hexStringToByteArray(value));
    }
}

