/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.constants;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;

public class NeoConstants {
    public static final int FIXED8_SCALE = 8;
    public static final BigDecimal FIXED8_DECIMALS = BigDecimal.TEN.pow(8);
    public static final int FIXED8_LENGTH = 8;
    public static final int MAX_PUBLIC_KEYS_PER_MULTISIG_ACCOUNT = 1024;
    public static final int SCRIPTHASH_SIZE = 20;
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 33;
    public static final int ADDRESS_SIZE = 34;
    public static final int SIGNATURE_SIZE = 64;
    public static final int INVOCATION_SCRIPT_SIZE = 66;
    public static final int SERIALIZED_INVOCATION_SCRIPT_SIZE = 67;
    public static final int VERIFICATION_SCRIPT_SIZE = 41;
    public static final long GAS_PER_BYTE = 1000L;
    public static final byte CURRENT_TX_VERSION = 0;
    public static final int MAX_TRANSACTION_SIZE = 102400;
    public static final int MAX_TRANSACTION_ATTRIBUTES = 16;
    public static final int MAX_SIGNER_SUBITEMS = 16;
    public static final int MAX_VALID_UNTIL_BLOCK_INCREMENT = 5760;
    public static final int MAX_MANIFEST_SIZE = 4096;

    public static ECDomainParameters curve() {
        return new ECDomainParameters(NeoConstants.curveParams().getCurve(), NeoConstants.curveParams().getG(), NeoConstants.curveParams().getN(), NeoConstants.curveParams().getH());
    }

    public static X9ECParameters curveParams() {
        return CustomNamedCurves.getByName((String)"secp256r1");
    }

    public static BigInteger halfCurveOrder() {
        return NeoConstants.curveParams().getN().shiftRight(1);
    }
}

