/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.utils.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;

public class ClassUtilsTest {
    @Test
    public void testGetClassNameHappyPath() {
        String simpleClassName = ClassUtils.getClassName((String)"io.neow3j.blah.Test");
        MatcherAssert.assertThat((Object)simpleClassName, (Matcher)Is.is((Object)"Test"));
    }

    @Test
    public void testGetClassNameHappyPathWithSlashes() {
        String fqn = ClassUtils.getFullyQualifiedNameForInternalName((String)"io/neow3j/blah/Test");
        String simpleClassName = ClassUtils.getClassName((String)fqn);
        MatcherAssert.assertThat((Object)simpleClassName, (Matcher)Is.is((Object)"Test"));
    }

    @Test
    public void testGetClassNameNoClass() {
        String simpleClassName = ClassUtils.getClassName((String)"io.neow3j.blah.");
        MatcherAssert.assertThat((Object)simpleClassName, (Matcher)Is.is((Object)""));
    }

    @Test
    public void testGetClassNameEmpty() {
        String simpleClassName = ClassUtils.getClassName((String)"");
        MatcherAssert.assertThat((Object)simpleClassName, (Matcher)Is.is((Object)""));
    }

    @Test
    public void testInternalNameToFQNHappyPath() {
        String fqn = ClassUtils.getFullyQualifiedNameForInternalName((String)"io/neow3j/blah/Test");
        MatcherAssert.assertThat((Object)fqn, (Matcher)Is.is((Object)"io.neow3j.blah.Test"));
    }

    @Test
    public void testInternalNameToFQNEmpty() {
        String fqn = ClassUtils.getFullyQualifiedNameForInternalName((String)"");
        MatcherAssert.assertThat((Object)fqn, (Matcher)Is.is((Object)""));
    }

    @Test
    public void getClassNameFromInternalNameReturnsCorrectNameForProperInternalName() {
        String result = ClassUtils.getClassNameForInternalName((String)"io/neow3j/blah/Test");
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"Test"));
    }

    @Test
    public void getClassNameFromInternalNameReturnsEmptyStringForEmptyInternalName() {
        String result = ClassUtils.getClassNameForInternalName((String)"");
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)""));
    }

    @Test
    public void testGetClassInputStreamForClassName() throws IOException {
        InputStream result = ClassUtils.getClassInputStreamForClassName((String)"io.neow3j.utils.ClassUtilsTest", (ClassLoader)this.getClass().getClassLoader());
        MatcherAssert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)result.available(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

