/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.utils.ArrayUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsTest {
    @Test
    public void testToPrimitive() {
        byte b1 = 1;
        byte b2 = 2;
        byte b3 = 3;
        Byte[] testArray = new Byte[]{new Byte(b1), new Byte(b2), new Byte(b3)};
        byte[] arrayOfBytesPrimitive = ArrayUtils.toPrimitive((Byte[])testArray);
        Assert.assertThat((Object)arrayOfBytesPrimitive[0], (Matcher)Matchers.is((Object)b1));
        Assert.assertThat((Object)arrayOfBytesPrimitive[1], (Matcher)Matchers.is((Object)b2));
        Assert.assertThat((Object)arrayOfBytesPrimitive[2], (Matcher)Matchers.is((Object)b3));
    }

    @Test
    public void testToPrimitive_Empty() {
        Byte[] testArray = new Byte[]{};
        byte[] arrayOfBytesPrimitive = ArrayUtils.toPrimitive((Byte[])testArray);
        Assert.assertThat((Object)arrayOfBytesPrimitive.length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testToPrimitive_Null() {
        Byte[] testArray = null;
        byte[] arrayOfBytesPrimitive = ArrayUtils.toPrimitive(testArray);
        Assert.assertThat((Object)arrayOfBytesPrimitive, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTrimLeadingZeroes() {
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[0]), (Matcher)CoreMatchers.is((Object)new byte[0]));
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[]{0}), (Matcher)CoreMatchers.is((Object)new byte[]{0}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)new byte[]{1}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[]{0, 1}), (Matcher)CoreMatchers.is((Object)new byte[]{1}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[]{0, 0, 1}), (Matcher)CoreMatchers.is((Object)new byte[]{1}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingZeroes((byte[])new byte[]{0, 0, 1, 0}), (Matcher)CoreMatchers.is((Object)new byte[]{1, 0}));
    }

    @Test
    public void testXor() {
        byte a1 = 1;
        byte a2 = 16;
        byte b1 = 2;
        byte b2 = 17;
        byte[] xorResult = ArrayUtils.xor((byte[])new byte[]{a1, a2}, (byte[])new byte[]{b1, b2});
        Assert.assertThat((Object)xorResult, (Matcher)Matchers.is((Object)new byte[]{3, 1}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_Different_Sizes() {
        ArrayUtils.xor((byte[])new byte[]{1, 2}, (byte[])new byte[]{1});
    }

    @Test
    public void testGetFirstNBytes() {
        Assert.assertThat((Object)ArrayUtils.getFirstNBytes((byte[])new byte[]{1, 2, 3}, (int)2), (Matcher)Matchers.is((Object)new byte[]{1, 2}));
        Assert.assertThat((Object)ArrayUtils.getFirstNBytes((byte[])new byte[]{1, 2, 3}, (int)3), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3}));
        Assert.assertThat((Object)ArrayUtils.getFirstNBytes((byte[])new byte[]{1, 2, 3}, (int)0), (Matcher)Matchers.is((Object)new byte[0]));
        Assert.assertThat((Object)ArrayUtils.getFirstNBytes((byte[])new byte[0], (int)2), (Matcher)Matchers.is((Object)new byte[0]));
        Assert.assertThat((Object)ArrayUtils.getFirstNBytes(null, (int)2), (Matcher)Matchers.is((Object)new byte[0]));
    }

    @Test
    public void testGetLastNBytes() {
        Assert.assertThat((Object)ArrayUtils.getLastNBytes((byte[])new byte[]{1, 2, 3}, (int)2), (Matcher)Matchers.is((Object)new byte[]{2, 3}));
        Assert.assertThat((Object)ArrayUtils.getLastNBytes((byte[])new byte[]{1, 2, 3}, (int)3), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3}));
        Assert.assertThat((Object)ArrayUtils.getLastNBytes((byte[])new byte[]{1, 2, 3}, (int)0), (Matcher)Matchers.is((Object)new byte[0]));
        Assert.assertThat((Object)ArrayUtils.getLastNBytes((byte[])new byte[0], (int)2), (Matcher)Matchers.is((Object)new byte[0]));
        Assert.assertThat((Object)ArrayUtils.getLastNBytes(null, (int)2), (Matcher)Matchers.is((Object)new byte[0]));
    }

    @Test
    public void testConcatenate() {
        Assert.assertThat((Object)ArrayUtils.concatenate((byte[])new byte[]{1, 2, 3}, (byte[])new byte[]{4}), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3, 4}));
        Assert.assertThat((Object)ArrayUtils.concatenate((byte[])new byte[]{1, 2, 3}, (byte)4), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3, 4}));
        Assert.assertThat((Object)ArrayUtils.concatenate((byte)4, (byte[])new byte[]{1, 2, 3}), (Matcher)Matchers.is((Object)new byte[]{4, 1, 2, 3}));
        Assert.assertThat((Object)ArrayUtils.concatenate((byte[][])new byte[][]{{1, 2, 3}, {1, 2, 3}, {4}}), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3, 1, 2, 3, 4}));
        Assert.assertThat((Object)ArrayUtils.concatenate((byte[][])new byte[][]{new byte[0], {1, 2, 3}, new byte[0], {1}}), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3, 1}));
    }

    @Test
    public void testReverseArray() {
        Assert.assertThat((Object)ArrayUtils.reverseArray((byte[])new byte[]{1, 2, 3}), (Matcher)Matchers.is((Object)new byte[]{3, 2, 1}));
        Assert.assertThat((Object)ArrayUtils.reverseArray((byte[])new byte[]{1, 2}), (Matcher)Matchers.is((Object)new byte[]{2, 1}));
        Assert.assertThat((Object)ArrayUtils.reverseArray((byte[])new byte[]{1}), (Matcher)Matchers.is((Object)new byte[]{1}));
        Assert.assertThat((Object)ArrayUtils.reverseArray((byte[])new byte[0]), (Matcher)Matchers.is((Object)new byte[0]));
    }

    @Test(expected=NullPointerException.class)
    public void testReverseArray_Null() {
        ArrayUtils.reverseArray(null);
    }

    @Test
    public void testTrimLeadingBytes() {
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{1, 2, 3}, (byte)1), (Matcher)Matchers.is((Object)new byte[]{2, 3}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{1, 2, 3}, (byte)2), (Matcher)Matchers.is((Object)new byte[]{1, 2, 3}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{5, 2, 3}, (byte)2), (Matcher)Matchers.is((Object)new byte[]{5, 2, 3}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{5, 2, 3}, (byte)5), (Matcher)Matchers.is((Object)new byte[]{2, 3}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{5, 2, 3}, (byte)5), (Matcher)Matchers.is((Object)new byte[]{2, 3}));
        Assert.assertThat((Object)ArrayUtils.trimLeadingBytes((byte[])new byte[]{5, 2, 5, 3}, (byte)5), (Matcher)Matchers.is((Object)new byte[]{2, 5, 3}));
    }

    @Test
    public void testToByteArray() {
        Assert.assertThat((Object)ArrayUtils.toByteArray((int)0), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 0}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((int)16), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 16}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((int)255), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, -1}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((int)Integer.MAX_VALUE), (Matcher)Matchers.is((Object)new byte[]{127, -1, -1, -1}));
    }

    @Test
    public void longToByteArray() {
        Assert.assertThat((Object)ArrayUtils.toByteArray((long)0L), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((long)16L), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 0, 0, 0, 0, 16}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((long)255L), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 0, 0, 0, 0, -1}));
        Assert.assertThat((Object)ArrayUtils.toByteArray((long)Integer.MAX_VALUE), (Matcher)Matchers.is((Object)new byte[]{0, 0, 0, 0, 127, -1, -1, -1}));
    }

    @Test
    public void trimTrailingBytes() {
        Assert.assertThat((Object)ArrayUtils.trimTrailingBytes((byte[])new byte[]{1, 2, 3}, (byte)3), (Matcher)Matchers.is((Object)new byte[]{1, 2}));
        Assert.assertThat((Object)ArrayUtils.trimTrailingBytes((byte[])new byte[]{5, 2, 2}, (byte)2), (Matcher)Matchers.is((Object)new byte[]{5}));
        Assert.assertThat((Object)ArrayUtils.trimTrailingBytes((byte[])new byte[]{5, 2, 3}, (byte)2), (Matcher)Matchers.is((Object)new byte[]{5, 2, 3}));
    }
}

