/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.io;

import io.neow3j.io.BinaryReader;
import io.neow3j.io.TestBinaryUtils;
import io.neow3j.io.exceptions.DeserializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class BinaryReaderTest
extends TestBinaryUtils {
    private BinaryReader testBinaryReader;
    private TestBinaryUtils.ByteArrayBuilder arrayBuilder;
    private byte[] readResultByteArray;
    private BigInteger readResultInt;
    private String readResultString;

    @Test(expected=DeserializationException.class)
    public void failReadPushDataByteArray() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("4b").setAnyDataWithSize(1).setSuffix("0000");
        this.readPushDataByteArray();
    }

    @Test
    public void readPushDataByteArray1Byte() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0c01").setAnyDataWithSize(1);
        this.readPushDataByteArray();
        Assert.assertThat((Object)this.readResultByteArray, (Matcher)Is.is((Object)this.arrayBuilder.getData()));
    }

    @Test
    public void readPushDataByteArray255Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0cff").setAnyDataWithSize(255);
        this.readPushDataByteArray();
        Assert.assertThat((Object)this.readResultByteArray, (Matcher)Is.is((Object)this.arrayBuilder.getData()));
    }

    @Test
    public void readPushDataByteArray256Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0d0001").setAnyDataWithSize(256);
        this.readPushDataByteArray();
        Assert.assertThat((Object)this.readResultByteArray, (Matcher)Is.is((Object)this.arrayBuilder.getData()));
    }

    @Test
    public void readPushDataByteArray4096Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0d0010").setAnyDataWithSize(4096);
        this.readPushDataByteArray();
        Assert.assertThat((Object)this.readResultByteArray, (Matcher)Is.is((Object)this.arrayBuilder.getData()));
    }

    @Test
    public void readPushDataByteArray65536Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0e00000100").setAnyDataWithSize(65536);
        this.readPushDataByteArray();
        Assert.assertThat((Object)this.readResultByteArray, (Matcher)Is.is((Object)this.arrayBuilder.getData()));
    }

    @Test
    public void readPushDataString0Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0c00");
        this.readPushDataString();
        Assert.assertThat((Object)this.readResultString, (Matcher)Is.is((Object)""));
    }

    @Test
    public void readPushDataString1Byte() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0c0161");
        this.readPushDataString();
        Assert.assertThat((Object)this.readResultString, (Matcher)Is.is((Object)"a"));
    }

    @Test
    public void readPushDataString10000Bytes() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0e10270000").setAnyStringWithSize(10000);
        this.readPushDataString();
        Assert.assertThat((Object)this.readResultString, (Matcher)Is.is((Object)new String(this.arrayBuilder.getData())));
    }

    @Test
    public void readPushInteger0() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setData("10");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(0L)));
    }

    @Test
    public void readPushInteger1() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("11");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(1L)));
    }

    @Test
    public void readPushIntegerMinus1() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0f");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(-1L)));
    }

    @Test
    public void readPushInteger16() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("20");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(16L)));
    }

    @Test(expected=DeserializationException.class)
    public void failReadPushIntegerUnsupported() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0e");
        this.readPushInteger();
    }

    @Test
    public void readPushIntegerMin8BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0080");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(-128L)));
    }

    @Test
    public void readPushIntegerMax8BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("007f");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(127L)));
    }

    @Test
    public void readPushIntegerMin16BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("010080");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(-32768L)));
    }

    @Test
    public void readPushInteger16BitInt255() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("01ff00");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(255L)));
    }

    @Test
    public void readPushIntegerMax16BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("01ff7f");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(32767L)));
    }

    @Test
    public void readPushIntegerMin32BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("0200000080");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(Integer.MIN_VALUE)));
    }

    @Test
    public void readPushInteger32BitInt65535() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("02ffff0000");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(65535L)));
    }

    @Test
    public void readPushIntegerMax32BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("02ffffff7f");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void readPushIntegerMin64BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("030000000000000080");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(Long.MIN_VALUE)));
    }

    @Test
    public void readPushInteger64BitInt65535() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("03ffffffff00000000");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(0xFFFFFFFFL)));
    }

    @Test
    public void readPushIntegerMax64BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("03ffffffffffffff7f");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)BigInteger.valueOf(Long.MAX_VALUE)));
    }

    @Test
    public void readPushInteger128BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("04ffffffffffffffff0000000000000000");
        this.readPushInteger();
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)new BigInteger("18446744073709551615")));
    }

    @Test
    public void readPushInteger256BitInt() throws DeserializationException {
        this.arrayBuilder = new TestBinaryUtils.ByteArrayBuilder().setPrefix("050100000000000000feffffffffffffff00000000000000000000000000000000");
        this.readPushInteger();
        BigInteger uLong = new BigInteger("18446744073709551615");
        BigInteger val = uLong.multiply(uLong);
        Assert.assertThat((Object)this.readResultInt, (Matcher)Is.is((Object)val));
    }

    @Test
    public void readUInt32() throws IOException {
        byte[] data = new byte[]{-1, -1, -1, -1};
        this.buildBinaryReader(data);
        long value = this.testBinaryReader.readUInt32();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)0xFFFFFFFFL));
        data = new byte[]{1, 0, 0, 0};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readUInt32();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)1L));
        data = new byte[]{0, 0, 0, 0};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readUInt32();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)0L));
        data = new byte[]{-116, -82, 0, 0, -1};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readUInt32();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)44684L));
    }

    @Test
    public void readInt64() throws IOException {
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, -128};
        this.buildBinaryReader(data);
        long value = this.testBinaryReader.readInt64();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)Long.MIN_VALUE));
        data = new byte[]{-1, -1, -1, -1, -1, -1, -1, 127};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readInt64();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)Long.MAX_VALUE));
        data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readInt64();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)0L));
        data = new byte[]{17, 51, 34, -116, -82, 0, 0, 0, -1};
        this.buildBinaryReader(data);
        value = this.testBinaryReader.readInt64();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)749675361041L));
    }

    private void buildBinaryReader(byte[] data) {
        this.testBinaryReader = new BinaryReader((InputStream)new ByteArrayInputStream(data));
    }

    private void readPushDataByteArray() throws DeserializationException {
        byte[] testArray = this.arrayBuilder.build();
        this.buildBinaryReader(testArray);
        this.readResultByteArray = this.testBinaryReader.readPushData();
    }

    private void readPushDataString() throws DeserializationException {
        byte[] testArray = this.arrayBuilder.build();
        this.buildBinaryReader(testArray);
        this.readResultString = this.testBinaryReader.readPushString();
    }

    private void readPushInteger() throws DeserializationException {
        byte[] testArray = this.arrayBuilder.build();
        this.buildBinaryReader(testArray);
        this.readResultInt = this.testBinaryReader.readPushBigInteger();
    }
}

