/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.InteropServiceCode;
import io.neow3j.constants.OpCode;
import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Hash;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.NeoSerializableInterface;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ScriptHashTest {
    @Test
    public void createFromValidHash() {
        ScriptHash sh = new ScriptHash("0x23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
        sh = new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromTooShortHash() {
        new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromTooLongHash() {
        new ScriptHash("c56f33fc6ecfcd0c225c4ab356fee59390af8560be0e930faebe74a6daff7c9ba");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromMidSizedHash() {
        new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9938a3e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromMalformedHash() {
        new ScriptHash("g3ba2703c53263e8d6e522dc32203339dcd8eee9");
    }

    @Test
    public void toArray() {
        ScriptHash sh = new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9");
        byte[] expected = ArrayUtils.reverseArray((byte[])Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
        Assert.assertArrayEquals((byte[])expected, (byte[])sh.toArray());
    }

    @Test
    public void serialize() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BinaryWriter writer = new BinaryWriter((OutputStream)outStream);
        new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9").serialize(writer);
        byte[] actual = outStream.toByteArray();
        byte[] expected = ArrayUtils.reverseArray((byte[])Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void deserialize() throws DeserializationException {
        byte[] data = ArrayUtils.reverseArray((byte[])Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
        ScriptHash sh = (ScriptHash)NeoSerializableInterface.from((byte[])data, ScriptHash.class);
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
    }

    @Test
    public void equals() {
        byte[] m1 = Numeric.hexStringToByteArray((String)"01a402d8");
        byte[] m2 = Numeric.hexStringToByteArray((String)"d802a401");
        ScriptHash sh1 = ScriptHash.fromScript((byte[])m1);
        ScriptHash sh2 = ScriptHash.fromScript((byte[])m2);
        Assert.assertNotEquals((Object)sh1, (Object)sh2);
        Assert.assertNotEquals((Object)sh2, (Object)sh1);
        Assert.assertEquals((Object)sh1, (Object)sh1);
    }

    @Test
    public void fromValidAddress() {
        ScriptHash hash = ScriptHash.fromAddress((String)"NLnyLtep7jwyq1qhNPkwXbJpurC4jUT8ke");
        byte[] expectedHash = Numeric.hexStringToByteArray((String)"09a55874c2da4b86e5d49ff530a1b153eb12c7d6");
        MatcherAssert.assertThat((Object)hash.toArray(), (Matcher)Is.is((Object)expectedHash));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromInvalidAddress() {
        ScriptHash.fromAddress((String)"NLnyLtep7jwyq1qhNPkwXbJpurC4jUT8keas");
    }

    @Test
    public void fromPublicKeyByteArray() {
        String key = "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50";
        byte[] script = Numeric.hexStringToByteArray((String)("" + OpCode.PUSHDATA1.toString() + "21" + "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50" + OpCode.PUSHNULL.toString() + OpCode.SYSCALL.toString() + InteropServiceCode.NEO_CRYPTO_VERIFYWITHECDSASECP256R1.getHash()));
        ScriptHash sh = ScriptHash.fromPublicKey((byte[])Numeric.hexStringToByteArray((String)"035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50"));
        MatcherAssert.assertThat((Object)sh.toArray(), (Matcher)Is.is((Object)Hash.sha256AndThenRipemd160((byte[])script)));
    }

    @Test
    public void fromPublicKeyByteArrays() {
        String key1 = "02249425a06b5a1f8e6133fc79afa2c2b8430bf9327297f176761df79e8d8929c5";
        String key2 = "031ccaaa46df7c494f442698c8c17c09311e3615c2dc042cbd3afeaba60fa40740";
        String expectedScriptHash = "aaf6f842f8450c4226bfaee5da2fab983cfa07e6";
        List keys = Arrays.asList(Numeric.hexStringToByteArray((String)"02249425a06b5a1f8e6133fc79afa2c2b8430bf9327297f176761df79e8d8929c5"), Numeric.hexStringToByteArray((String)"031ccaaa46df7c494f442698c8c17c09311e3615c2dc042cbd3afeaba60fa40740"));
        ScriptHash sh = ScriptHash.fromPublicKeys(keys, (int)2);
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)expectedScriptHash));
    }

    @Test
    public void fromContractScript() {
        String verificationScript = "110c21026aa8fe6b4360a67a530e23c08c6a72525afde34719c5436f9d3ced759f939a3d110b41138defaf";
        ScriptHash sh = ScriptHash.fromScript((String)verificationScript);
        String bigEndian = sh.toString();
        MatcherAssert.assertThat((Object)bigEndian, (Matcher)Is.is((Object)"afaed076854454449770763a628f379721ea9808"));
        String littleEndian = Numeric.toHexStringNoPrefix((byte[])sh.toArray());
        MatcherAssert.assertThat((Object)littleEndian, (Matcher)Is.is((Object)"0898ea2197378f623a7670974454448576d0aeaf"));
    }

    @Test
    public void toAddress() {
        String key = "031ccaaa46df7c494f442698c8c17c09311e3615c2dc042cbd3afeaba60fa40740";
        String expectedAddress = "NWcx4EfYdfqn5jNjDz8AHE6hWtWdUGDdmy";
        ScriptHash sh = ScriptHash.fromPublicKey((byte[])Numeric.hexStringToByteArray((String)"031ccaaa46df7c494f442698c8c17c09311e3615c2dc042cbd3afeaba60fa40740"));
        MatcherAssert.assertThat((Object)sh.toAddress(), (Matcher)Is.is((Object)"NWcx4EfYdfqn5jNjDz8AHE6hWtWdUGDdmy"));
    }

    @Test
    public void compareTo() {
        byte[] m1 = Numeric.hexStringToByteArray((String)"01a402d8");
        byte[] m2 = Numeric.hexStringToByteArray((String)"d802a401");
        byte[] m3 = Numeric.hexStringToByteArray((String)"a7b3a191");
        ScriptHash sh1 = ScriptHash.fromScript((byte[])m1);
        ScriptHash sh2 = ScriptHash.fromScript((byte[])m2);
        ScriptHash sh3 = ScriptHash.fromScript((byte[])m3);
        MatcherAssert.assertThat((Object)sh1.compareTo(sh1), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)sh1.compareTo(sh2), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)sh1.compareTo(sh3), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)sh2.compareTo(sh1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh2.compareTo(sh3), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh3.compareTo(sh1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh3.compareTo(sh2), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void getSize() {
        ScriptHash sh = new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.getSize(), (Matcher)Is.is((Object)20));
    }
}

