/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.InteropServiceCode;
import io.neow3j.constants.OpCode;
import io.neow3j.contract.ScriptBuilder;
import io.neow3j.io.TestBinaryUtils;
import io.neow3j.utils.Numeric;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScriptBuilderTest
extends TestBinaryUtils {
    private ScriptBuilder builder;

    @Before
    public void setUp() {
        this.builder = new ScriptBuilder();
    }

    @Test
    public void pushData_ByteArray_1Byte() {
        byte[] data = this.buildArray(1);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0c01")));
    }

    @Test
    public void pushData_ByteArray_76Bytes() {
        byte[] data = this.buildArray(75);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0c4b")));
    }

    @Test
    public void pushData_ByteArray_256Bytes() {
        byte[] data = this.buildArray(256);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0d0001")));
    }

    @Test
    public void pushData_ByteArray_65536() {
        byte[] data = this.buildArray(65536);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 5), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0e00000100")));
    }

    @Test
    public void pushData_String_0() {
        this.builder.pushData("");
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0c00")));
    }

    @Test
    public void pushData_String_1() {
        this.builder.pushData("a");
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0c0161")));
    }

    @Test
    public void pushData_String_10000() {
        String data = this.buildString(10000);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0d1027")));
    }

    @Test
    public void pushInteger_0() {
        this.builder.pushInteger(0);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH0.toString())));
    }

    @Test
    public void pushInteger_1() {
        this.builder.pushInteger(1);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH1.toString())));
    }

    @Test
    public void pushInteger_16() {
        this.builder.pushInteger(16);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH16.toString())));
    }

    @Test
    public void pushInteger_17() {
        this.builder.pushInteger(17);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0011")));
    }

    @Test
    public void buildVerificationScriptFromMultiplePublicKeys() {
        String key1 = "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50";
        String key2 = "03eda286d19f7ee0b472afd1163d803d620a961e1581a8f2704b52c0285f6e022d";
        List keys = Arrays.asList(Numeric.hexStringToByteArray((String)"035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50"), Numeric.hexStringToByteArray((String)"03eda286d19f7ee0b472afd1163d803d620a961e1581a8f2704b52c0285f6e022d"));
        byte[] script = ScriptBuilder.buildVerificationScript(keys, (int)2);
        byte[] expected = Numeric.hexStringToByteArray((String)("" + OpCode.PUSH2.toString() + OpCode.PUSHDATA1.toString() + "21" + "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50" + OpCode.PUSHDATA1.toString() + "21" + "03eda286d19f7ee0b472afd1163d803d620a961e1581a8f2704b52c0285f6e022d" + OpCode.PUSH2.toString() + OpCode.PUSHNULL.toString() + OpCode.SYSCALL.toString() + InteropServiceCode.NEO_CRYPTO_CHECKMULTISIGWITHECDSASECP256R1.getHash()));
        Assert.assertArrayEquals((byte[])expected, (byte[])script);
    }

    @Test
    public void buildVerificationScriptFromSinglePublicKey() {
        String key = "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50";
        byte[] script = ScriptBuilder.buildVerificationScript((byte[])Numeric.hexStringToByteArray((String)"035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50"));
        byte[] expected = Numeric.hexStringToByteArray((String)("" + OpCode.PUSHDATA1.toString() + "21" + "035fdb1d1f06759547020891ae97c729327853aeb1256b6fe0473bc2e9fa42ff50" + OpCode.PUSHNULL.toString() + OpCode.SYSCALL.toString() + InteropServiceCode.NEO_CRYPTO_VERIFYWITHECDSASECP256R1.getHash()));
        Assert.assertArrayEquals((byte[])expected, (byte[])script);
    }
}

