/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.ContractParameter;
import io.neow3j.contract.ScriptHash;
import io.neow3j.model.types.ContractParameterType;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContractParameterTest {
    private ContractParameter contractParameter;

    @Before
    public void setUp() {
        this.contractParameter = ContractParameter.string((String)"value");
    }

    @Test
    public void testStringParamCreation() {
        String value = "value";
        ContractParameter p = ContractParameter.string((String)value);
        Assert.assertEquals((Object)value, (Object)p.getValue());
        Assert.assertEquals((Object)ContractParameterType.STRING, (Object)p.getParamType());
    }

    @Test
    public void testByteArrayParamCreation() {
        byte[] bytes = new byte[]{1, 1};
        ContractParameter p = ContractParameter.byteArray((byte[])bytes);
        Assert.assertThat((Object)((byte[])p.getValue()), (Matcher)Is.is((Object)bytes));
        Assert.assertEquals((Object)ContractParameterType.BYTE_ARRAY, (Object)p.getParamType());
    }

    @Test
    public void testByteArrayParamCreationFromHexString() {
        ContractParameter p = ContractParameter.byteArray((String)"0xa602");
        Assert.assertThat((Object)((byte[])p.getValue()), (Matcher)Is.is((Object)new byte[]{-90, 2}));
        Assert.assertEquals((Object)ContractParameterType.BYTE_ARRAY, (Object)p.getParamType());
    }

    @Test
    public void testByteArrayParamCreationFromString() {
        ContractParameter p = ContractParameter.byteArrayFromString((String)"Neo");
        Assert.assertThat((Object)((byte[])p.getValue()), (Matcher)Is.is((Object)new byte[]{78, 101, 111}));
        Assert.assertEquals((Object)ContractParameterType.BYTE_ARRAY, (Object)p.getParamType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testByteArrayParamCreationFromInvalidHexString() {
        String value = "value";
        ContractParameter.byteArray((String)value);
    }

    @Test
    public void testArrayParamCreationFromList() {
        ArrayList<ContractParameter> params = new ArrayList<ContractParameter>();
        ContractParameter p1 = ContractParameter.string((String)"value");
        ContractParameter p2 = ContractParameter.byteArray((String)"0x0101");
        params.add(p1);
        params.add(p2);
        ContractParameter p = ContractParameter.array(params);
        Assert.assertEquals((Object)ContractParameterType.ARRAY, (Object)p.getParamType());
        Assert.assertEquals(ContractParameter[].class, p.getValue().getClass());
        Assert.assertEquals((Object)p1, (Object)((ContractParameter[])p.getValue())[0]);
        Assert.assertEquals((Object)p2, (Object)((ContractParameter[])p.getValue())[1]);
    }

    @Test
    public void testArrayParamCreationFromArray() {
        ContractParameter p1 = ContractParameter.string((String)"value");
        ContractParameter p2 = ContractParameter.byteArray((String)"0x0101");
        ContractParameter p = ContractParameter.array((ContractParameter[])new ContractParameter[]{p1, p2});
        Assert.assertEquals((Object)ContractParameterType.ARRAY, (Object)p.getParamType());
        Assert.assertEquals(ContractParameter[].class, p.getValue().getClass());
        Assert.assertEquals((Object)p1, (Object)((ContractParameter[])p.getValue())[0]);
        Assert.assertEquals((Object)p2, (Object)((ContractParameter[])p.getValue())[1]);
    }

    @Test
    public void testSignatureParamCreationFromValidString() {
        String sig = "d8485d4771e9112cca6ac7e6b75fc52585a2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f213";
        ContractParameter p = ContractParameter.signature((String)sig);
        Assert.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)sig), (byte[])((byte[])p.getValue()));
        Assert.assertEquals((Object)ContractParameterType.SIGNATURE, (Object)p.getParamType());
    }

    @Test
    public void testSignatureParamCreationFromValidStringStrip0x() {
        String sig = "d8485d4771e9112cca6ac7e6b75fc52585a2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f213";
        ContractParameter p = ContractParameter.signature((String)("0x" + sig));
        Assert.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)sig), (byte[])((byte[])p.getValue()));
        Assert.assertEquals((Object)ContractParameterType.SIGNATURE, (Object)p.getParamType());
    }

    @Test
    public void testSignatureParamCreationFromByteArray() {
        String sigString = "d8485d4771e9112cca6ac7e6b75fc52585a2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f213";
        byte[] sig = Numeric.hexStringToByteArray((String)sigString);
        ContractParameter p = ContractParameter.signature((byte[])sig);
        Assert.assertArrayEquals((byte[])sig, (byte[])((byte[])p.getValue()));
        Assert.assertEquals((Object)ContractParameterType.SIGNATURE, (Object)p.getParamType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSignatureParamCreationFromTooShortString() {
        String sig = "d8485d4771e9112cca6ac7e6b75fc52585a2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f2";
        ContractParameter.signature((String)sig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSignatureParamCreationFromTooLongString() {
        String sig = "d8485d4771e9112cca6ac7e6b75fc52585a2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f213ff";
        ContractParameter.signature((String)sig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSignatureParamCreationFromNoHexString() {
        String sig = "d8485d4771e9112cca6ac7e6b75fc52585t2e7ee9a702db4a39dfad0f888ea6c22b6185ceab38d8322b67737a5574d8b63f4e27b0d208f3f9efcdbf56093f213";
        ContractParameter.signature((String)sig);
    }

    @Test
    public void testBooleanParameterCreation() {
        ContractParameter p = ContractParameter.bool((boolean)false);
        Assert.assertEquals((Object)ContractParameterType.BOOLEAN, (Object)p.getParamType());
        Assert.assertEquals((Object)false, (Object)p.getValue());
        p = ContractParameter.bool((boolean)true);
        Assert.assertEquals((Object)ContractParameterType.BOOLEAN, (Object)p.getParamType());
        Assert.assertEquals((Object)true, (Object)p.getValue());
    }

    @Test
    public void testIntegerParameterCreation() {
        ContractParameter p = ContractParameter.integer((int)10);
        Assert.assertEquals((Object)ContractParameterType.INTEGER, (Object)p.getParamType());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)p.getValue());
        p = ContractParameter.integer((BigInteger)BigInteger.ONE.negate());
        Assert.assertEquals((Object)ContractParameterType.INTEGER, (Object)p.getParamType());
        Assert.assertEquals((Object)BigInteger.ONE.negate(), (Object)p.getValue());
    }

    @Test
    public void testHash160ParameterCreationFromValidScriptHash() {
        String hashString = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6f";
        ScriptHash hash = new ScriptHash(hashString);
        ContractParameter p = ContractParameter.hash160((ScriptHash)hash);
        Assert.assertEquals((Object)ContractParameterType.HASH160, (Object)p.getParamType());
        Assert.assertEquals((Object)hashString, (Object)p.getValue().toString());
    }

    @Test
    public void testHash160ParameterCreationFromValidString() {
        String hashValue = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6f";
        ContractParameter p = ContractParameter.hash160((ScriptHash)new ScriptHash(hashValue));
        Assert.assertEquals((Object)ContractParameterType.HASH160, (Object)p.getParamType());
        Assert.assertEquals((Object)hashValue, (Object)p.getValue().toString());
    }

    @Test
    public void testHash256ParameterCreationFromValidString() {
        String hashValue = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6ff6c6f576f6f6c6f576f6f6cf";
        ContractParameter p = ContractParameter.hash256((String)hashValue);
        Assert.assertEquals((Object)ContractParameterType.HASH256, (Object)p.getParamType());
        Assert.assertEquals((Object)hashValue, (Object)Numeric.toHexStringNoPrefix((byte[])((byte[])p.getValue())));
    }

    @Test
    public void testHash256ParameterCreationFromValidByteArray() {
        String hashValue = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6ff6c6f576f6f6c6f576f6f6cf";
        ContractParameter p = ContractParameter.hash256((byte[])Numeric.hexStringToByteArray((String)hashValue));
        Assert.assertEquals((Object)ContractParameterType.HASH256, (Object)p.getParamType());
        Assert.assertEquals((Object)hashValue, (Object)Numeric.toHexStringNoPrefix((byte[])((byte[])p.getValue())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHash256ParamCreationFromTooShortString() {
        String sig = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6ff6c6f576f6f6c6f576f6f6c";
        ContractParameter.hash256((String)sig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHash256ParamCreationFromTooLongString() {
        String sig = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6ff6c6f576f6f6c6f576f6f6cfaa";
        ContractParameter.hash256((String)sig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHash256ParamCreationFromNoHexString() {
        String sig = "576f6f6c6f576f6f6c6f576f6f6c6f576f6f6c6ff6c6f576f6f6c6f576f6f6cg";
        ContractParameter.hash256((String)sig);
    }

    @Test
    public void testGetParamType() {
        Assert.assertThat((Object)this.contractParameter.getParamType(), (Matcher)Is.is((Object)ContractParameterType.STRING));
    }

    @Test
    public void testGetValue() {
        Assert.assertThat((Object)this.contractParameter.getValue(), (Matcher)Is.is((Object)"value"));
    }

    @Test
    public void testEquals() {
        Assert.assertThat((Object)this.contractParameter.equals((Object)"o"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.contractParameter.equals((Object)this.contractParameter), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testHashCode() {
        int result = this.contractParameter.hashCode();
        Assert.assertNotEquals((long)0L, (long)result);
    }
}

