/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;
import java.util.Arrays;

public class WIF {
    public static byte[] getPrivateKeyFromWIF(String wif) {
        if (wif == null) {
            throw new NullPointerException();
        }
        byte[] data = Base58.decode(wif);
        if (data.length != 38 || data[0] != -128 || data[33] != 1) {
            throw new IllegalArgumentException("Incorrect WIF format.");
        }
        byte[] checksum = Hash.hash256(data, 0, data.length - 4);
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            throw new IllegalArgumentException("Incorrect WIF checksum.");
        }
        byte[] privateKey = new byte[32];
        System.arraycopy(data, 1, privateKey, 0, privateKey.length);
        Arrays.fill(data, (byte)0);
        return privateKey;
    }

    public static String getWIFFromPrivateKey(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Given key is not of expected length (32 bytes).");
        }
        byte[] extendenKey = ArrayUtils.concatenate(ArrayUtils.concatenate((byte)-128, key), (byte)1);
        byte[] hash = Hash.hash256(extendenKey);
        byte[] checksum = ArrayUtils.getFirstNBytes(hash, 4);
        return Base58.encode(ArrayUtils.concatenate(extendenKey, checksum));
    }
}

