/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.ScriptBuilder;
import io.neow3j.crypto.Hash;
import io.neow3j.io.BinaryReader;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.NeoSerializable;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.utils.AddressUtils;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ScriptHash
extends NeoSerializable
implements Comparable<ScriptHash> {
    private byte[] scriptHash;
    public static final ScriptHash ZERO = new ScriptHash("0000000000000000000000000000000000000000");

    public ScriptHash() {
        this.scriptHash = new byte[20];
    }

    public ScriptHash(byte[] scriptHash) {
        this.checkAndThrowHashLength(scriptHash);
        this.scriptHash = scriptHash;
    }

    public ScriptHash(String scriptHash) {
        if (!Numeric.isValidHexString(scriptHash)) {
            throw new IllegalArgumentException("String argument is not hexadecimal.");
        }
        this.scriptHash = ArrayUtils.reverseArray(Numeric.hexStringToByteArray(scriptHash));
        this.checkAndThrowHashLength(this.scriptHash);
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.scriptHash = reader.readBytes(20);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.write(this.scriptHash);
    }

    @Override
    public int getSize() {
        return 20;
    }

    @Override
    public byte[] toArray() {
        return super.toArray();
    }

    public String toString() {
        return Numeric.toHexStringNoPrefix(ArrayUtils.reverseArray(this.scriptHash));
    }

    public String toAddress() {
        return AddressUtils.scriptHashToAddress(this.scriptHash);
    }

    public static ScriptHash fromAddress(String address) {
        return new ScriptHash(AddressUtils.addressToScriptHash(address));
    }

    public static ScriptHash fromScript(byte[] script) {
        return new ScriptHash(Hash.sha256AndThenRipemd160(script));
    }

    public static ScriptHash fromPublicKey(byte[] encodedPublicKey) {
        return ScriptHash.fromScript(ScriptBuilder.buildVerificationScript(encodedPublicKey));
    }

    public static ScriptHash fromPublicKeys(List<byte[]> encodedPublicKeys, int signingThreshold) {
        return ScriptHash.fromScript(ScriptBuilder.buildVerificationScript(encodedPublicKeys, signingThreshold));
    }

    public static ScriptHash fromScript(String script) {
        return ScriptHash.fromScript(Numeric.hexStringToByteArray(script));
    }

    private void checkAndThrowHashLength(byte[] scriptHash) {
        if (scriptHash.length != 20) {
            throw new IllegalArgumentException("Script hash must be 20 bytes long but was " + scriptHash.length + " bytes.");
        }
    }

    @Override
    public int compareTo(ScriptHash o) {
        return new BigInteger(1, ArrayUtils.reverseArray(this.scriptHash)).compareTo(new BigInteger(1, ArrayUtils.reverseArray(o.toArray())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptHash that = (ScriptHash)o;
        return Arrays.equals(this.scriptHash, that.scriptHash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.scriptHash);
    }
}

