/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.WIF;
import io.neow3j.utils.Numeric;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class WIFTest {
    @Test
    public void testWIF() {
        String privateKey = "9117f4bf9be717c9a90994326897f4243503accd06712162267e77f18b49c3a3";
        byte[] privateKeyFromWIF = WIF.getPrivateKeyFromWIF((String)"L25kgAQJXNHnhc7Sx9bomxxwVSMsZdkaNQ3m2VfHrnLzKWMLP13A");
        MatcherAssert.assertThat((Object)Numeric.toHexStringNoPrefix((byte[])privateKeyFromWIF), (Matcher)Matchers.is((Object)"9117f4bf9be717c9a90994326897f4243503accd06712162267e77f18b49c3a3"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWIFLargerThan38() {
        WIF.getPrivateKeyFromWIF((String)"L25kgAQJXNHnhc7Sx9bomxxwVSMsZdkaNQ3m2VfHrnLzKWMLP13A000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWIFFirstByteDifferentThan0x80() {
        byte[] wifBytes = Base58.decode((String)"L25kgAQJXNHnhc7Sx9bomxxwVSMsZdkaNQ3m2VfHrnLzKWMLP13A");
        wifBytes[0] = -127;
        String wifString = Base58.encode((byte[])wifBytes);
        WIF.getPrivateKeyFromWIF((String)wifString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWIF33ByteDifferentThan0x01() {
        byte[] wifBytes = Base58.decode((String)"L25kgAQJXNHnhc7Sx9bomxxwVSMsZdkaNQ3m2VfHrnLzKWMLP13A");
        wifBytes[33] = 0;
        String wifString = Base58.encode((byte[])wifBytes);
        WIF.getPrivateKeyFromWIF((String)wifString);
    }

    @Test(expected=NullPointerException.class)
    public void testWIFNull() {
        WIF.getPrivateKeyFromWIF(null);
    }
}

