/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ScriptHashTest {
    @Test
    public void testLength() {
        ScriptHash sh = new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.length(), (Matcher)Is.is((Object)20));
    }

    @Test
    public void createFromValidHash() {
        ScriptHash sh = new ScriptHash("0x23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
        sh = new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)"23ba2703c53263e8d6e522dc32203339dcd8eee9"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromTooShortHash() {
        new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromTooLongHash() {
        new ScriptHash("c56f33fc6ecfcd0c225c4ab356fee59390af8560be0e930faebe74a6daff7c9ba");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromMidSizedHash() {
        new ScriptHash("23ba2703c53263e8d6e522dc32203339dcd8eee9938a3e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromMalformedHash() {
        new ScriptHash("g3ba2703c53263e8d6e522dc32203339dcd8eee9");
    }

    @Test
    public void toArray() {
        String hashHex = "23ba2703c53263e8d6e522dc32203339dcd8eee9";
        ScriptHash sh = new ScriptHash(hashHex);
        MatcherAssert.assertThat((Object)sh.toArray(), (Matcher)Is.is((Object)ArrayUtils.reverseArray((byte[])Numeric.hexStringToByteArray((String)hashHex))));
    }

    @Test
    public void equals() {
        byte[] m1 = Numeric.hexStringToByteArray((String)"01a402d8");
        byte[] m2 = Numeric.hexStringToByteArray((String)"d802a401");
        ScriptHash sh1 = ScriptHash.fromScript((byte[])m1);
        ScriptHash sh2 = ScriptHash.fromScript((byte[])m2);
        Assert.assertFalse((boolean)sh1.equals((Object)sh2));
        Assert.assertFalse((boolean)sh2.equals((Object)sh1));
        Assert.assertTrue((boolean)sh1.equals((Object)sh1));
    }

    @Test
    public void fromValidAddress() {
        byte[] expectedHash = Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9");
        ScriptHash hash = ScriptHash.fromAddress((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y");
        MatcherAssert.assertThat((Object)hash.toArray(), (Matcher)Is.is((Object)expectedHash));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromInvalidAddress() {
        ScriptHash.fromAddress((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8yyyy");
    }

    @Test
    public void fromPublicKeyByteArray() {
        String keyHex = "0265bf906bf385fbf3f777832e55a87991bcfbe19b097fb7c5ca2e4025a4d5e5d6";
        ScriptHash sh = ScriptHash.fromPublicKey((byte[])Numeric.hexStringToByteArray((String)keyHex));
        String expectedBigEndianHash = "d76382536f9cd862b01f6e6ef539c43ff8835f29";
        MatcherAssert.assertThat((Object)sh.toString(), (Matcher)Is.is((Object)expectedBigEndianHash));
    }

    @Test
    public void fromPublicKeyByteArrays() {
        String keyHex1 = "0265bf906bf385fbf3f777832e55a87991bcfbe19b097fb7c5ca2e4025a4d5e5d6";
        String keyHex2 = "025dd091303c62a683fab1278349c3475c958f4152292495350571d3e998611d43";
        byte[] key1 = Numeric.hexStringToByteArray((String)"0265bf906bf385fbf3f777832e55a87991bcfbe19b097fb7c5ca2e4025a4d5e5d6");
        byte[] key2 = Numeric.hexStringToByteArray((String)"025dd091303c62a683fab1278349c3475c958f4152292495350571d3e998611d43");
        ScriptHash sh = ScriptHash.fromPublicKeys((int)2, (byte[][])new byte[][]{key1, key2});
        String verificationScriptHex = "5221" + keyHex1 + "21" + keyHex2 + "52ae";
        byte[] verificationScript = Numeric.hexStringToByteArray((String)verificationScriptHex);
        MatcherAssert.assertThat((Object)sh.toArray(), (Matcher)Is.is((Object)Hash.sha256AndThenRipemd160((byte[])verificationScript)));
    }

    @Test
    public void fromContractScript() {
        String verificationScript = "522102028a99826edc0c97d18e22b6932373d908d323aa7f92656a77ec26e8861699ef21031d8e1630ce640966967bc6d95223d21f44304133003140c3b52004dc981349c92102232ce8d2e2063dce0451131851d47421bfc4fc1da4db116fca5302c0756462fa53ae";
        ScriptHash sh = ScriptHash.fromScript((String)verificationScript);
        String bigEndian = sh.toString();
        MatcherAssert.assertThat((Object)bigEndian, (Matcher)Is.is((Object)"fc3ea6882d1f6fdc360a2c650edf742dcb4ae078"));
        String littleEndian = Numeric.toHexStringNoPrefix((byte[])sh.toArray());
        MatcherAssert.assertThat((Object)littleEndian, (Matcher)Is.is((Object)"78e04acb2d74df0e652c0a36dc6f1f2d88a63efc"));
    }

    @Test
    public void toAddress() {
        String keyHex = "0265bf906bf385fbf3f777832e55a87991bcfbe19b097fb7c5ca2e4025a4d5e5d6";
        String expectedAddress = "AKYdmtzCD6DtGx16KHzSTKY8ji29sMTbEZ";
        ScriptHash sh = ScriptHash.fromPublicKey((byte[])Numeric.hexStringToByteArray((String)keyHex));
        MatcherAssert.assertThat((Object)sh.toAddress(), (Matcher)Is.is((Object)expectedAddress));
    }

    @Test
    public void compareTo() {
        byte[] m1 = Numeric.hexStringToByteArray((String)"01a402d8");
        byte[] m2 = Numeric.hexStringToByteArray((String)"d802a401");
        byte[] m3 = Numeric.hexStringToByteArray((String)"a7b3a191");
        ScriptHash sh1 = ScriptHash.fromScript((byte[])m1);
        ScriptHash sh2 = ScriptHash.fromScript((byte[])m2);
        ScriptHash sh3 = ScriptHash.fromScript((byte[])m3);
        MatcherAssert.assertThat((Object)sh1.compareTo(sh1), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)sh1.compareTo(sh2), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)sh1.compareTo(sh3), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)sh2.compareTo(sh1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh2.compareTo(sh3), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh3.compareTo(sh1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)sh3.compareTo(sh2), (Matcher)Is.is((Object)-1));
    }
}

