/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class ArrayUtils {
    public static byte[] reverseArray(byte[] array) {
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        for (int i = 0; i < copy.length / 2; ++i) {
            byte temp = copy[i];
            copy[i] = copy[copy.length - i - 1];
            copy[copy.length - i - 1] = temp;
        }
        return copy;
    }

    public static byte[] concatenate(byte[] a, byte b) {
        return ArrayUtils.concatenate(a, new byte[]{b});
    }

    public static byte[] concatenate(byte a, byte[] b) {
        return ArrayUtils.concatenate(new byte[]{a}, b);
    }

    public static byte[] concatenate(byte[] ... arrays) {
        byte[] result = new byte[]{};
        for (byte[] array : arrays) {
            if (array == null) continue;
            result = ArrayUtils.concatenate(result, array);
        }
        return result;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        byte[] n = new byte[a.length + b.length];
        System.arraycopy(a, 0, n, 0, a.length);
        System.arraycopy(b, 0, n, a.length, b.length);
        return n;
    }

    public static byte[] getFirstNBytes(byte[] array, int nBytes) {
        if (array != null && array.length > 0) {
            return Arrays.copyOfRange(array, 0, nBytes);
        }
        return new byte[0];
    }

    public static byte[] getLastNBytes(byte[] array, int nBytes) {
        if (array != null && array.length > 0) {
            return Arrays.copyOfRange(array, array.length - nBytes, array.length);
        }
        return new byte[0];
    }

    public static byte[] xor(byte[] array1, byte[] array2) throws IllegalArgumentException {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays do not have the same length to perform the XOR operation.");
        }
        byte[] result = new byte[array1.length];
        int i = 0;
        for (byte b : array1) {
            result[i] = (byte)(b ^ array2[i++]);
        }
        return result;
    }

    public static byte[] trimLeadingBytes(byte[] bytes, byte b) {
        int offset;
        for (offset = 0; offset < bytes.length - 1 && bytes[offset] == b; ++offset) {
        }
        return Arrays.copyOfRange(bytes, offset, bytes.length);
    }

    public static byte[] trimLeadingZeroes(byte[] bytes) {
        return ArrayUtils.trimLeadingBytes(bytes, (byte)0);
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toByteArray(int v) {
        return ByteBuffer.allocate(4).putInt(v).array();
    }
}

