/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityProviderChecker {
    private static final String ANDROID_BC_CLASS_PREFIX = "com.android.org.bouncycastle";

    public static void addBouncyCastle() {
        if (SecurityProviderChecker.isDefaultAndroidBC()) {
            Security.removeProvider("BC");
        }
        if (!SecurityProviderChecker.isAnyBC()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static boolean isDefaultAndroidBC() {
        return SecurityProviderChecker.getBCProvider().map(SecurityProviderChecker::checkProviderStartsWith).orElse(false);
    }

    private static Boolean checkProviderStartsWith(Provider provider) {
        return provider.getClass().getCanonicalName().startsWith(ANDROID_BC_CLASS_PREFIX);
    }

    private static boolean isAnyBC() {
        return SecurityProviderChecker.getBCProvider().isPresent();
    }

    private static Optional<Provider> getBCProvider() {
        return Optional.ofNullable(Security.getProvider("BC"));
    }
}

