/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Keys;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.util.Arrays;

public class ScriptHash
implements Comparable<ScriptHash> {
    private byte[] scriptHash;

    public ScriptHash(byte[] scriptHash) {
        this.checkAndThrowHashLength(scriptHash);
        this.scriptHash = scriptHash;
    }

    public ScriptHash(String scriptHash) {
        if (!Numeric.isValidHexString(scriptHash)) {
            throw new IllegalArgumentException("String argument is not hexadecimal.");
        }
        this.scriptHash = ArrayUtils.reverseArray(Numeric.hexStringToByteArray(scriptHash));
        this.checkAndThrowHashLength(this.scriptHash);
    }

    public int length() {
        return this.scriptHash.length;
    }

    public byte[] toArray() {
        return this.scriptHash;
    }

    public String toString() {
        return Numeric.toHexStringNoPrefix(ArrayUtils.reverseArray(this.scriptHash));
    }

    public String toAddress() {
        byte[] data = new byte[]{23};
        byte[] dataAndScriptHash = ArrayUtils.concatenate(data, this.scriptHash);
        byte[] checksum = Hash.sha256(Hash.sha256(dataAndScriptHash));
        byte[] first4BytesCheckSum = new byte[4];
        System.arraycopy(checksum, 0, first4BytesCheckSum, 0, 4);
        byte[] dataToEncode = ArrayUtils.concatenate(dataAndScriptHash, first4BytesCheckSum);
        return Base58.encode(dataToEncode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptHash that = (ScriptHash)o;
        return Arrays.equals(this.scriptHash, that.scriptHash);
    }

    public static ScriptHash fromAddress(String address) {
        if (!Keys.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid NEO address.");
        }
        byte[] buffer = new byte[20];
        System.arraycopy(Base58.decode(address), 1, buffer, 0, 20);
        return new ScriptHash(buffer);
    }

    public static ScriptHash fromPublicKey(byte[] publicKey) {
        return ScriptHash.fromScript(Keys.getVerificationScriptFromPublicKey(publicKey));
    }

    public static ScriptHash fromPublicKeys(int signingThreshold, byte[] ... publicKeys) {
        byte[] verificationScript = Keys.getVerificationScriptFromPublicKeys(signingThreshold, publicKeys);
        return ScriptHash.fromScript(verificationScript);
    }

    public static ScriptHash fromScript(byte[] script) {
        return new ScriptHash(Hash.sha256AndThenRipemd160(script));
    }

    public static ScriptHash fromScript(String script) {
        return ScriptHash.fromScript(Numeric.hexStringToByteArray(script));
    }

    private void checkAndThrowHashLength(byte[] scriptHash) {
        if (scriptHash.length != 20 && scriptHash.length != 32) {
            throw new IllegalArgumentException("Script hash must be either 20 or 32 bytes long, but was " + scriptHash.length);
        }
    }

    @Override
    public int compareTo(ScriptHash o) {
        return new BigInteger(1, ArrayUtils.reverseArray(this.scriptHash)).compareTo(new BigInteger(1, ArrayUtils.reverseArray(o.toArray())));
    }
}

