/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.OpCode;
import io.neow3j.contract.ContractParameter;
import io.neow3j.contract.ScriptHash;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.BigIntegers;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ScriptBuilder {
    private DataOutputStream stream;
    private ByteBuffer buffer;
    private ByteArrayOutputStream byteStream = new ByteArrayOutputStream();

    public ScriptBuilder() {
        this.stream = new DataOutputStream(this.byteStream);
        this.buffer = ByteBuffer.wrap(new byte[8]).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ScriptBuilder opCode(OpCode opCode) {
        this.writeByte(opCode.getValue());
        return this;
    }

    public ScriptBuilder appCall(ScriptHash scriptHash, String operation, List<ContractParameter> params) {
        if (params == null || params.isEmpty()) {
            if (operation == null) {
                return this.appCall(scriptHash);
            }
            return this.appCall(scriptHash, operation);
        }
        if (operation == null) {
            return this.appCall(scriptHash, params);
        }
        for (int i = params.size() - 1; i >= 0; --i) {
            this.pushParam(params.get(i));
        }
        this.pushInteger(params.size());
        this.opCode(OpCode.PACK);
        this.pushData(operation);
        this.appCall(scriptHash);
        return this;
    }

    private ScriptBuilder appCall(ScriptHash scriptHash, List<ContractParameter> params) {
        for (int i = params.size() - 1; i >= 0; --i) {
            this.pushParam(params.get(i));
        }
        this.appCall(scriptHash);
        return this;
    }

    private ScriptBuilder appCall(ScriptHash scriptHash, String operation) {
        this.pushBoolean(false);
        this.pushData(operation);
        this.appCall(scriptHash);
        return this;
    }

    private ScriptBuilder appCall(ScriptHash scriptHash) {
        return this.call(scriptHash, OpCode.APPCALL);
    }

    @Deprecated
    public ScriptBuilder appCall(byte[] scriptHash, String operation, List<ContractParameter> params) {
        this.appCall(new ScriptHash(ArrayUtils.reverseArray(scriptHash)), operation, params);
        return this;
    }

    @Deprecated
    public ScriptBuilder appCall(byte[] scriptHash, List<ContractParameter> params) {
        this.appCall(new ScriptHash(ArrayUtils.reverseArray(scriptHash)), params);
        return this;
    }

    @Deprecated
    public ScriptBuilder appCall(byte[] scriptHash, String operation) {
        this.appCall(new ScriptHash(ArrayUtils.reverseArray(scriptHash)), operation);
        return this;
    }

    @Deprecated
    public ScriptBuilder appCall(byte[] scriptHash) {
        return this.call(new ScriptHash(ArrayUtils.reverseArray(scriptHash)), OpCode.APPCALL);
    }

    @Deprecated
    public ScriptBuilder tailCall(byte[] scriptHash) {
        return this.tailCall(new ScriptHash(ArrayUtils.reverseArray(scriptHash)));
    }

    public ScriptBuilder tailCall(ScriptHash scriptHash) {
        return this.call(scriptHash, OpCode.TAILCALL);
    }

    private ScriptBuilder call(ScriptHash scriptHash, OpCode opCode) {
        this.writeByte(opCode.getValue());
        this.write(scriptHash.toArray());
        return this;
    }

    public ScriptBuilder sysCall(String operation) {
        if (operation.length() == 0) {
            throw new IllegalArgumentException("Provided operation string is empty.");
        }
        byte[] operationBytes = operation.getBytes(StandardCharsets.UTF_8);
        if (operationBytes.length > 252) {
            throw new IllegalArgumentException("Provided operation is too long.");
        }
        byte[] callArgument = ArrayUtils.concatenate((byte)operationBytes.length, operationBytes);
        this.writeByte(OpCode.SYSCALL.getValue());
        this.write(callArgument);
        return this;
    }

    public ScriptBuilder pushParam(ContractParameter param) {
        Object value = param.getValue();
        switch (param.getParamType()) {
            case BYTE_ARRAY: 
            case SIGNATURE: {
                this.pushData((byte[])value);
                break;
            }
            case BOOLEAN: {
                this.pushBoolean((Boolean)value);
                break;
            }
            case INTEGER: {
                this.pushInteger((BigInteger)value);
                break;
            }
            case HASH160: 
            case HASH256: {
                this.pushData(((ScriptHash)value).toArray());
                break;
            }
            case STRING: {
                this.pushData((String)value);
                break;
            }
            case ARRAY: {
                this.pushArray((ContractParameter[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type '" + param.getParamType() + "' not supported.");
            }
        }
        return this;
    }

    public ScriptBuilder pushInteger(int v) {
        return this.pushInteger(BigInteger.valueOf(v));
    }

    public ScriptBuilder pushInteger(BigInteger number) {
        if (number.intValue() == -1) {
            this.writeByte(OpCode.PUSHM1.getValue());
        } else if (number.intValue() == 0) {
            this.writeByte(OpCode.PUSH0.getValue());
        } else if (number.intValue() >= 1 && number.intValue() <= 16) {
            int base = OpCode.PUSH1.getValue() - 1;
            this.writeByte(base + number.intValue());
        } else {
            this.pushData(BigIntegers.toLittleEndianByteArray(number));
        }
        return this;
    }

    public ScriptBuilder pushBoolean(boolean bool) {
        if (bool) {
            this.writeByte(OpCode.PUSHT.getValue());
        } else {
            this.writeByte(OpCode.PUSHF.getValue());
        }
        return this;
    }

    public ScriptBuilder pushData(String data) {
        if (data != null) {
            this.pushData(data.getBytes(StandardCharsets.UTF_8));
        } else {
            this.pushData("".getBytes());
        }
        return this;
    }

    public ScriptBuilder pushData(byte[] data) {
        this.pushDataLength(data.length);
        this.write(data);
        return this;
    }

    public ScriptBuilder pushDataLength(int length) {
        if (length <= OpCode.PUSHBYTES75.getValue()) {
            this.writeByte(length);
        } else if (length <= 255) {
            this.writeByte(OpCode.PUSHDATA1.getValue());
            this.writeByte(length);
        } else if (length <= 65535) {
            this.writeByte(OpCode.PUSHDATA2.getValue());
            this.writeShort(length);
        } else {
            this.writeByte(OpCode.PUSHDATA4.getValue());
            this.writeInt(length);
        }
        return this;
    }

    public ScriptBuilder pushArray(ContractParameter[] params) {
        for (int i = params.length - 1; i >= 0; --i) {
            this.pushParam(params[i]);
        }
        this.pushInteger(params.length);
        this.opCode(OpCode.PACK);
        return this;
    }

    private void writeByte(int v) {
        try {
            this.stream.writeByte(v);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void writeShort(int v) {
        this.buffer.putInt(0, v);
        try {
            this.stream.write(this.buffer.array(), 0, 2);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void writeInt(int v) {
        this.buffer.putInt(0, v);
        try {
            this.stream.write(this.buffer.array(), 0, 4);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void write(byte[] data) {
        try {
            this.stream.write(data);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    private void writeReversed(byte[] data) {
        try {
            this.stream.write(ArrayUtils.reverseArray(data));
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
    }

    public byte[] toArray() {
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException without doing IO.");
        }
        return this.byteStream.toByteArray();
    }
}

