/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.utils.Keys;
import io.neow3j.utils.Numeric;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class KeysTest {
    @Test
    public void testToAddress() {
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)Keys.toAddress((byte[])scriptHash), (Matcher)Is.is((Object)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"));
    }

    @Test
    public void testToScriptHash() {
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9");
        MatcherAssert.assertThat((Object)Keys.toScriptHash((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"), (Matcher)Is.is((Object)scriptHash));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToScriptHashLargerThan25Chars() {
        Keys.toScriptHash((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8yyyy");
    }

    @Test
    public void testScriptHashToAddress() {
        String script = "d336d7eb9975a29b2404fdb28185e277a4b299bc";
        String address = "Ab2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU";
        MatcherAssert.assertThat((Object)Keys.scriptHashToAddress((String)script), (Matcher)Is.is((Object)address));
    }

    @Test
    public void testIsValidAddress() {
        TestCase.assertTrue((boolean)Keys.isValidAddress((String)"Ab2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        TestCase.assertTrue((boolean)Keys.isValidAddress((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"));
        Assert.assertFalse((boolean)Keys.isValidAddress((String)""));
        Assert.assertFalse((boolean)Keys.isValidAddress((String)"0"));
        Assert.assertFalse((boolean)Keys.isValidAddress((String)"b2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        Assert.assertFalse((boolean)Keys.isValidAddress((String)"AAb2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU"));
        try {
            Keys.isValidAddress(null);
        }
        catch (NullPointerException e) {
            return;
        }
        TestCase.fail();
    }
}

