/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.exceptions.AddressFormatException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Base58DecodeTest {
    private String input;
    private byte[] expected;

    public Base58DecodeTest(String input, byte[] expected) {
        this.input = input;
        this.expected = expected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"JxF12TrwUP45BMd", "Hello World".getBytes()}, {"1", new byte[1]}, {"1111", new byte[4]});
    }

    @Test
    public void testDecode() {
        byte[] actualBytes = Base58.decode((String)this.input);
        Assert.assertArrayEquals((String)this.input, (byte[])actualBytes, (byte[])this.expected);
    }

    @Test
    public void testDecode_emptyString() {
        Assert.assertEquals((long)0L, (long)Base58.decode((String)"").length);
    }

    @Test(expected=AddressFormatException.class)
    public void testDecode_invalidBase58() {
        Base58.decode((String)"This isn't valid base58");
    }
}

