/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.constants.OpCode;
import io.neow3j.contract.ScriptBuilder;
import io.neow3j.io.TestBinaryUtils;
import io.neow3j.utils.Numeric;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScriptBuilderTest
extends TestBinaryUtils {
    private ScriptBuilder builder;

    @Before
    public void setUp() {
        this.builder = new ScriptBuilder();
    }

    @Test
    public void pushData_ByteArray_Exactly_1Byte() {
        byte[] data = this.buildArray(1);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"01")));
    }

    @Test
    public void pushData_ByteArray_Less_Than_76Bytes() {
        byte[] data = this.buildArray(75);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4B")));
    }

    @Test
    public void pushData_ByteArray_Exactly_76Bytes() {
        byte[] data = this.buildArray(76);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4C4C")));
    }

    @Test
    public void pushData_ByteArray_Exactly_77Bytes() {
        byte[] data = this.buildArray(77);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4C4D")));
    }

    @Test
    public void pushData_ByteArray_Less_Than_256Bytes() {
        byte[] data = this.buildArray(255);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4CFF")));
    }

    @Test
    public void pushData_ByteArray_Exactly_256Bytes() {
        byte[] data = this.buildArray(256);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4D0001")));
    }

    @Test
    public void pushData_ByteArray_More_Than_256Bytes() {
        byte[] data = this.buildArray(2769);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4DD10A")));
    }

    @Test
    public void pushData_ByteArray_Exactly_4096Bytes() {
        byte[] data = this.buildArray(4096);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4D0010")));
    }

    @Test
    public void pushData_ByteArray_More_Than_4096Bytes() {
        byte[] data = this.buildArray(14096);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4D1037")));
    }

    @Test
    public void pushData_ByteArray_Exactly_65535_Bytes() {
        byte[] data = this.buildArray(65535);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4Dffff")));
    }

    @Test
    public void pushData_ByteArray_Exactly_65536_Bytes() {
        byte[] data = this.buildArray(65536);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 5), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4E00000100")));
    }

    @Test
    public void pushData_Integer_0() {
        this.builder.pushInteger(0);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH0.toString())));
    }

    @Test
    public void pushData_Integer_1() {
        this.builder.pushInteger(1);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH1.toString())));
    }

    @Test
    public void pushData_Integer_16() {
        this.builder.pushInteger(16);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)OpCode.PUSH16.toString())));
    }

    @Test
    public void pushData_Integer_17() {
        this.builder.pushInteger(17);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0111")));
    }

    @Test
    public void pushData_String_0() {
        this.builder.pushData("");
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 1), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"00")));
    }

    @Test
    public void pushData_String_1() {
        this.builder.pushData("a");
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 2), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"0161")));
    }

    @Test
    public void pushData_String_10000() {
        String data = this.buildString(10000);
        this.builder.pushData(data);
        Assert.assertThat((Object)Arrays.copyOfRange(this.builder.toArray(), 0, 3), (Matcher)Is.is((Object)Numeric.hexStringToByteArray((String)"4D1027")));
    }
}

