/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.constants.OpCode;
import io.neow3j.contract.ScriptBuilder;
import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.exceptions.AddressFormatException;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Keys {
    private Keys() {
    }

    public static String getAddress(BigInteger publicKey) {
        return Keys.getAddress(Numeric.toHexStringNoPrefix(publicKey));
    }

    public static String getAddress(String publicKeyWithNoPrefix) {
        return Keys.getAddress(Numeric.hexStringToByteArray(publicKeyWithNoPrefix));
    }

    public static String getAddress(byte[] publicKey) {
        byte[] scriptHash = Keys.getScriptHashFromPublicKey(publicKey);
        return Keys.toAddress(scriptHash);
    }

    public static String getMultiSigAddress(int amountSignatures, List<BigInteger> publicKeys) {
        return Keys.getMultiSigAddress(amountSignatures, publicKeys.toArray(new BigInteger[0]));
    }

    public static String getMultiSigAddress(int amountSignatures, BigInteger ... publicKeys) {
        byte[][] pubKeysArray = new byte[publicKeys.length][];
        for (int i = 0; i < publicKeys.length; ++i) {
            pubKeysArray[i] = publicKeys[i].toByteArray();
        }
        byte[] scriptHash = Keys.getScriptHashFromPublicKey(amountSignatures, pubKeysArray);
        return Keys.toAddress(scriptHash);
    }

    public static String getMultiSigAddress(int amountSignatures, byte[] ... publicKeys) {
        byte[] scriptHash = Keys.getScriptHashFromPublicKey(amountSignatures, publicKeys);
        return Keys.toAddress(scriptHash);
    }

    public static byte[] getScriptHashFromPublicKey(byte[] publicKey) {
        return Keys.getScriptHashFromPublicKey(1, new byte[][]{publicKey});
    }

    public static byte[] getScriptHashFromPublicKey(int amountSignatures, byte[] ... publicKeys) {
        byte[] verificationScript = publicKeys.length == 1 ? Keys.getVerificationScriptFromPublicKey(publicKeys[0]) : Keys.getVerificationScriptFromPublicKeys(amountSignatures, publicKeys);
        return Hash.calculateScriptHash(verificationScript);
    }

    public static byte[] checkAndEncodePublicKey(byte[] publicKey) {
        if (!Keys.isPublicKeyEncoded(publicKey)) {
            return Keys.getPublicKeyEncoded(publicKey);
        }
        return publicKey;
    }

    public static byte[] publicKeyIntegerToByteArray(BigInteger publicKey) {
        return Numeric.toBytesPadded(publicKey, 33);
    }

    public static byte[] privateKeyIntegerToByteArray(BigInteger privateKey) {
        return Numeric.toBytesPadded(privateKey, 32);
    }

    public static byte[] getVerificationScriptFromPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Keys.checkAndEncodePublicKey(Keys.publicKeyIntegerToByteArray(publicKey));
        return Keys.getVerificationScriptFromPublicKeyEncoded(publicKeyBytes);
    }

    public static byte[] getVerificationScriptFromPublicKey(byte[] publicKey) {
        publicKey = Keys.checkAndEncodePublicKey(publicKey);
        return Keys.getVerificationScriptFromPublicKeyEncoded(publicKey);
    }

    private static byte[] getVerificationScriptFromPublicKeyEncoded(byte[] encodedPublicKey) {
        return new ScriptBuilder().pushData(encodedPublicKey).opCode(OpCode.CHECKSIG).toArray();
    }

    public static byte[] getVerificationScriptFromPublicKeys(int signingThreshold, List<BigInteger> publicKeys) {
        return Keys.getVerificationScriptFromPublicKeys(signingThreshold, (byte[][])publicKeys.stream().map(Keys::publicKeyIntegerToByteArray).toArray(x$0 -> new byte[x$0][]));
    }

    public static byte[] getVerificationScriptFromPublicKeys(int signingThreshold, byte[] ... publicKeys) {
        ArrayList<byte[]> encodedPublicKeys = new ArrayList<byte[]>(publicKeys.length);
        for (byte[] key : publicKeys) {
            encodedPublicKeys.add(Keys.checkAndEncodePublicKey(key));
        }
        return Keys.getVerificationScriptFromPublicKeysEncoded(signingThreshold, encodedPublicKeys);
    }

    private static byte[] getVerificationScriptFromPublicKeysEncoded(int signingThreshold, List<byte[]> encodedPublicKeys) {
        if (signingThreshold < 2 || signingThreshold > encodedPublicKeys.size()) {
            throw new IllegalArgumentException("Signing threshold must be at least 2 and not higher than the number of public keys.");
        }
        if (encodedPublicKeys.size() > 1024) {
            throw new IllegalArgumentException("At max 1024 public keys can take part in a multi-sig account");
        }
        ScriptBuilder builder = new ScriptBuilder().pushInteger(signingThreshold);
        encodedPublicKeys.forEach(key -> builder.pushData((byte[])key));
        return builder.pushInteger(encodedPublicKeys.size()).opCode(OpCode.CHECKMULTISIG).toArray();
    }

    public static byte[] getPublicKeyEncoded(byte[] publicKeyNotEncoded) {
        int[] publicKeyArray = new int[publicKeyNotEncoded.length];
        for (int i = 0; i < publicKeyNotEncoded.length; ++i) {
            publicKeyArray[i] = publicKeyNotEncoded[i] & 0xFF;
        }
        if (publicKeyArray[64] % 2 == 1) {
            return ArrayUtils.concatenate(new byte[]{3}, Arrays.copyOfRange(publicKeyNotEncoded, 1, 33));
        }
        return ArrayUtils.concatenate(new byte[]{2}, Arrays.copyOfRange(publicKeyNotEncoded, 1, 33));
    }

    public static boolean isPublicKeyEncoded(byte[] publicKey) {
        return publicKey.length > 1 && publicKey[0] != 4;
    }

    public static String toAddress(byte[] scriptHash) {
        byte[] data = new byte[]{23};
        byte[] dataAndScriptHash = ArrayUtils.concatenate(data, scriptHash);
        byte[] checksum = Hash.sha256(Hash.sha256(dataAndScriptHash));
        byte[] first4BytesCheckSum = new byte[4];
        System.arraycopy(checksum, 0, first4BytesCheckSum, 0, 4);
        byte[] dataToEncode = ArrayUtils.concatenate(dataAndScriptHash, first4BytesCheckSum);
        return Base58.encode(dataToEncode);
    }

    public static boolean isValidAddress(String address) {
        byte[] data;
        try {
            data = Base58.decode(address);
        }
        catch (AddressFormatException e) {
            return false;
        }
        if (data.length != 25) {
            return false;
        }
        if (data[0] != 23) {
            return false;
        }
        byte[] checksum = Hash.sha256(Hash.sha256(data, 0, 21));
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] toScriptHash(String address) {
        if (!Keys.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid NEO address.");
        }
        byte[] data = Base58.decode(address);
        byte[] buffer = new byte[20];
        System.arraycopy(data, 1, buffer, 0, 20);
        return buffer;
    }

    public static String scriptHashToAddress(String input) {
        byte[] inputBytes = Numeric.hexStringToByteArray(input);
        return Keys.toAddress(inputBytes);
    }
}

