/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.utils.ArrayUtils;
import java.math.BigInteger;

public class BigIntegers {
    public static byte[] toLittleEndianByteArray(BigInteger value) {
        return ArrayUtils.reverseArray(value.toByteArray());
    }

    public static byte[] toLittleEndianByteArray(int value) {
        return BigIntegers.toLittleEndianByteArray(BigInteger.valueOf(value));
    }

    public static byte[] toLittleEndianByteArrayZeroPadded(BigInteger value, int minByteLength) {
        byte[] bytes = value.toByteArray();
        if (bytes.length > minByteLength) {
            throw new IllegalArgumentException("given integer needs more space (" + bytes.length + " bytes) than the given minimum length (" + minByteLength + " bytes).");
        }
        if (bytes.length < minByteLength) {
            byte[] temp = new byte[minByteLength];
            System.arraycopy(bytes, 0, temp, minByteLength - bytes.length, bytes.length);
            return ArrayUtils.reverseArray(temp);
        }
        return ArrayUtils.reverseArray(bytes);
    }

    public static byte[] toLittleEndianByteArrayZeroPadded(int value, int minByteLength) {
        return BigIntegers.toLittleEndianByteArrayZeroPadded(BigInteger.valueOf(value), minByteLength);
    }

    public static BigInteger fromLittleEndianByteArray(byte[] value) {
        return new BigInteger(ArrayUtils.reverseArray(value));
    }
}

