/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.model.types.ContractParameterType;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Keys;
import io.neow3j.utils.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ContractParameter {
    @JsonProperty(value="name")
    private String paramName;
    @JsonProperty(value="type")
    private ContractParameterType paramType;
    @JsonProperty(value="value")
    protected Object value;

    protected ContractParameter() {
    }

    private ContractParameter(ContractParameterType paramType, Object value) {
        this.paramType = paramType;
        this.value = value;
    }

    public static ContractParameter string(String value) {
        return new ContractParameter(ContractParameterType.STRING, value);
    }

    public static ContractParameter array(List<ContractParameter> params) {
        return ContractParameter.array(params.toArray(new ContractParameter[0]));
    }

    public static ContractParameter array(ContractParameter ... params) {
        return new ContractParameter(ContractParameterType.ARRAY, params);
    }

    public static ContractParameter byteArray(byte[] byteArray) {
        return ContractParameter.byteArray(Numeric.toHexStringNoPrefix(byteArray));
    }

    public static ContractParameter byteArray(String value) {
        value = Numeric.cleanHexPrefix(value);
        return new ContractParameter(ContractParameterType.BYTE_ARRAY, value);
    }

    public static ContractParameter byteArrayFromAddress(String address) {
        if (!Keys.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid address.");
        }
        return ContractParameter.byteArray(Keys.toScriptHash(address));
    }

    public static ContractParameter fixed8ByteArray(BigDecimal number) {
        return ContractParameter.byteArray(ArrayUtils.reverseArray(Numeric.fromBigDecimalToFixed8Bytes(number)));
    }

    public static ContractParameter signature(String signatureHexString) {
        if (!Numeric.isValidHexString(signatureHexString)) {
            throw new IllegalArgumentException("String is not a valid hex number");
        }
        if ((signatureHexString = Numeric.cleanHexPrefix(signatureHexString)).length() != 128) {
            throw new IllegalArgumentException("Signature is expected to have a length of 64 bytes, but had " + signatureHexString.length() / 2 + ".");
        }
        return new ContractParameter(ContractParameterType.SIGNATURE, signatureHexString);
    }

    public static ContractParameter signature(byte[] signature) {
        return ContractParameter.signature(Numeric.toHexStringNoPrefix(signature));
    }

    public static ContractParameter bool(boolean bool) {
        return new ContractParameter(ContractParameterType.BOOLEAN, bool);
    }

    public static ContractParameter integer(int integer) {
        return ContractParameter.integer(BigInteger.valueOf(integer));
    }

    public static ContractParameter integer(BigInteger integer) {
        return new ContractParameter(ContractParameterType.INTEGER, integer.toString());
    }

    public static ContractParameter hash160(String hashHexString) {
        if (!Numeric.isValidHexString(hashHexString)) {
            throw new IllegalArgumentException("String is not a valid hex number");
        }
        if ((hashHexString = Numeric.cleanHexPrefix(hashHexString)).length() != 40) {
            throw new IllegalArgumentException("Hash160 is expected to have a length of 20 bytes, but had " + hashHexString.length() / 2 + ".");
        }
        return new ContractParameter(ContractParameterType.HASH160, hashHexString);
    }

    public static ContractParameter hash160(byte[] hash) {
        return ContractParameter.hash160(Numeric.toHexStringNoPrefix(hash));
    }

    public static ContractParameter hash256(String hashHexString) {
        if (!Numeric.isValidHexString(hashHexString)) {
            throw new IllegalArgumentException("String is not a valid hex number");
        }
        if ((hashHexString = Numeric.cleanHexPrefix(hashHexString)).length() != 64) {
            throw new IllegalArgumentException("Hash256 is expected to have a length of 32 bytes, but had " + hashHexString.length() / 2 + ".");
        }
        return new ContractParameter(ContractParameterType.HASH256, hashHexString);
    }

    public static ContractParameter hash256(byte[] hash) {
        return ContractParameter.hash256(Numeric.toHexStringNoPrefix(hash));
    }

    public static ContractParameter publicKey(String publicKey) {
        throw new UnsupportedOperationException();
    }

    public static ContractParameter publicKey(byte[] publicKey) {
        throw new UnsupportedOperationException();
    }

    public String getParamName() {
        return this.paramName;
    }

    public ContractParameterType getParamType() {
        return this.paramType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractParameter)) {
            return false;
        }
        ContractParameter that = (ContractParameter)o;
        return Objects.equals(this.paramName, that.paramName) && this.paramType == that.paramType && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.paramName, this.paramType, this.value);
    }

    public String toString() {
        return "ContractParameter{paramName='" + this.paramName + '\'' + ", paramType=" + this.paramType + ", value=" + this.value + '}';
    }
}

