/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.constants;

import io.neow3j.utils.Numeric;

public enum OpCode {
    PUSH0(0),
    PUSHF(0),
    PUSHBYTES1(1),
    PUSHBYTES33(33),
    PUSHBYTES64(64),
    PUSHBYTES75(75),
    PUSHDATA1(76),
    PUSHDATA2(77),
    PUSHDATA4(78),
    PUSHM1(79),
    PUSH1(81),
    PUSHT(81),
    PUSH2(82),
    PUSH3(83),
    PUSH4(84),
    PUSH5(85),
    PUSH6(86),
    PUSH7(87),
    PUSH8(88),
    PUSH9(89),
    PUSH10(90),
    PUSH11(91),
    PUSH12(92),
    PUSH13(93),
    PUSH14(94),
    PUSH15(95),
    PUSH16(96),
    NOP(97),
    JMP(98),
    JMPIF(99),
    JMPIFNOT(100),
    CALL(101),
    RET(102),
    APPCALL(103),
    SYSCALL(104),
    TAILCALL(105),
    SHA1(-89),
    SHA256(-88),
    HASH160(-87),
    HASH256(-86),
    CHECKSIG(-84),
    VERIFY(-83),
    CHECKMULTISIG(-82),
    PACK(-63);

    private byte opCode;

    private OpCode(byte opCode) {
        this.opCode = opCode;
    }

    public byte getValue() {
        return this.opCode;
    }

    public static String toHexString(OpCode opCode) {
        return Numeric.toHexStringNoPrefix(opCode.getValue());
    }

    public String toString() {
        return Numeric.toHexStringNoPrefix(this.getValue());
    }
}

