/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import io.neow3j.utils.ArrayUtils;

public class KeyUtils {
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 33;
    public static final int ADDRESS_SIZE = 34;
    public static final int PRIVATE_KEY_LENGTH_IN_HEX = 64;

    public static String toAddress(byte[] scriptHash) {
        byte[] data = new byte[]{23};
        byte[] dataAndScriptHash = ArrayUtils.concatenate(data, scriptHash);
        byte[] checksum = Hash.sha256(Hash.sha256(dataAndScriptHash));
        byte[] first4BytesCheckSum = new byte[4];
        System.arraycopy(checksum, 0, first4BytesCheckSum, 0, 4);
        byte[] dataToEncode = ArrayUtils.concatenate(dataAndScriptHash, first4BytesCheckSum);
        return Base58.encode(dataToEncode);
    }

    public static byte[] toScriptHash(String address) {
        byte[] data = Base58.decode(address);
        if (data.length != 25) {
            throw new IllegalArgumentException();
        }
        if (data[0] != 23) {
            throw new IllegalArgumentException();
        }
        byte[] checksum = Hash.sha256(Hash.sha256(data, 0, 21));
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            throw new IllegalArgumentException();
        }
        byte[] buffer = new byte[20];
        System.arraycopy(data, 1, buffer, 0, 20);
        return buffer;
    }
}

