/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.io;

import io.neow3j.constants.NeoConstants;
import io.neow3j.io.NeoSerializable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.math.ec.ECPoint;

public class BinaryReader
implements AutoCloseable {
    private DataInputStream reader;
    private byte[] array = new byte[8];
    private ByteBuffer buffer = ByteBuffer.wrap(this.array).order(ByteOrder.LITTLE_ENDIAN);
    private int position = 0;
    private int mark = -1;

    public BinaryReader(InputStream stream) {
        this.reader = new DataInputStream(stream);
    }

    public int getPosition() {
        return this.position;
    }

    public int getMark() {
        return this.mark;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void mark(int readlimit) {
        this.reader.mark(readlimit);
        this.mark = this.getPosition();
    }

    public void reset() throws IOException {
        this.reader.reset();
        this.position = this.getMark();
    }

    public void read(byte[] buffer) throws IOException {
        this.reader.readFully(buffer);
        this.position += buffer.length;
    }

    public void read(byte[] buffer, int index, int length) throws IOException {
        this.reader.readFully(buffer, index, length);
        this.position += length;
    }

    public boolean readBoolean() throws IOException {
        boolean result = this.reader.readBoolean();
        ++this.position;
        return result;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.reader.readUnsignedByte();
        ++this.position;
        return result;
    }

    public byte readByte() throws IOException {
        byte result = this.reader.readByte();
        ++this.position;
        return result;
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.reader.readFully(buffer);
        this.position += buffer.length;
        return buffer;
    }

    public double readDouble() throws IOException {
        this.reader.readFully(this.array, 0, 8);
        this.position += 8;
        return this.buffer.getDouble(0);
    }

    public ECPoint readECPoint() throws IOException {
        byte[] encoded;
        byte fb = this.reader.readByte();
        ++this.position;
        switch (fb) {
            case 0: {
                encoded = new byte[1];
                break;
            }
            case 2: 
            case 3: {
                encoded = new byte[33];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 32);
                this.position += 32;
                break;
            }
            case 4: {
                encoded = new byte[65];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 64);
                this.position += 64;
                break;
            }
            default: {
                throw new IOException();
            }
        }
        return NeoConstants.CURVE.getCurve().decodePoint(encoded);
    }

    public float readFloat() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        this.position += 4;
        return this.buffer.getFloat(0);
    }

    public int readInt() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        this.position += 4;
        return this.buffer.getInt(0);
    }

    public long readLong() throws IOException {
        this.reader.readFully(this.array, 0, 8);
        this.position += 8;
        return this.buffer.getLong(0);
    }

    public <T extends NeoSerializable> T readSerializable(Class<T> t) throws InstantiationException, IllegalAccessException, IOException {
        NeoSerializable obj = (NeoSerializable)t.newInstance();
        obj.deserialize(this);
        return (T)obj;
    }

    public <T extends NeoSerializable> List<T> readSerializableListVarBytes(Class<T> t) throws IOException, IllegalAccessException, InstantiationException {
        int length = (int)this.readVarInt(0x10000000L);
        int bytesRead = 0;
        int initialOffset = this.getPosition();
        ArrayList<NeoSerializable> list = new ArrayList<NeoSerializable>();
        while (bytesRead < length) {
            NeoSerializable objInstance = (NeoSerializable)t.newInstance();
            list.add(objInstance);
            objInstance.deserialize(this);
            int currentOffset = this.getPosition();
            bytesRead = currentOffset - initialOffset;
        }
        return list;
    }

    public <T extends NeoSerializable> List<T> readSerializableList(Class<T> t) throws IOException, IllegalAccessException, InstantiationException {
        int length = (int)this.readVarInt(0x10000000L);
        ArrayList<NeoSerializable> list = new ArrayList<NeoSerializable>(length);
        for (int i = 0; i < length; ++i) {
            NeoSerializable objInstance = (NeoSerializable)t.newInstance();
            list.add(objInstance);
            objInstance.deserialize(this);
        }
        return list;
    }

    public short readShort() throws IOException {
        this.reader.readFully(this.array, 0, 2);
        this.position += 2;
        return this.buffer.getShort(0);
    }

    public byte[] readVarBytes() throws IOException {
        return this.readVarBytes(0x7FFFFFC7);
    }

    public byte[] readVarBytes(int max) throws IOException {
        return this.readBytes((int)this.readVarInt(max));
    }

    public long readVarInt() throws IOException {
        return this.readVarInt(Long.MAX_VALUE);
    }

    public long readVarInt(long max) throws IOException {
        long fb = Byte.toUnsignedLong(this.readByte());
        long value = fb == 253L ? Short.toUnsignedLong(this.readShort()) : (fb == 254L ? Integer.toUnsignedLong(this.readInt()) : (fb == 255L ? this.readLong() : fb));
        if (Long.compareUnsigned(value, max) > 0) {
            throw new IOException();
        }
        return value;
    }

    public String readVarString() throws IOException {
        return new String(this.readVarBytes(), "UTF-8");
    }
}

