/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.Base58;
import io.neow3j.crypto.Hash;
import java.util.Arrays;

public class WIF {
    public static byte[] getPrivateKeyFromWIF(String wif) {
        if (wif == null) {
            throw new NullPointerException();
        }
        byte[] data = Base58.decode(wif);
        if (data.length != 38 || data[0] != -128 || data[33] != 1) {
            throw new IllegalArgumentException();
        }
        byte[] checksum = Hash.sha256(Hash.sha256(data, 0, data.length - 4));
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            throw new IllegalArgumentException();
        }
        byte[] privateKey = new byte[32];
        System.arraycopy(data, 1, privateKey, 0, privateKey.length);
        Arrays.fill(data, (byte)0);
        return privateKey;
    }
}

