/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import java.util.Arrays;

public class ArrayUtils {
    public static byte[] reverseArray(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }

    public static byte[] concatenate(byte a, byte[] b) {
        return ArrayUtils.concatenate(new byte[]{a}, b);
    }

    public static byte[] concatenate(byte[] ... arrays) {
        byte[] result = new byte[]{};
        for (byte[] array : arrays) {
            result = ArrayUtils.concatenate(result, array);
        }
        return result;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        byte[] n = new byte[a.length + b.length];
        System.arraycopy(a, 0, n, 0, a.length);
        System.arraycopy(b, 0, n, a.length, b.length);
        return n;
    }

    public static byte[] getFirstNBytes(byte[] array, int nBytes) {
        return Arrays.copyOfRange(array, 0, nBytes);
    }

    public static byte[] getLastNBytes(byte[] array, int nBytes) {
        return Arrays.copyOfRange(array, array.length - nBytes, array.length);
    }

    public static byte[] xor(byte[] array1, byte[] array2) throws IllegalArgumentException {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays do not have the same length to perform the XOR operation.");
        }
        byte[] result = new byte[array1.length];
        int i = 0;
        for (byte b : array1) {
            result[i] = (byte)(b ^ array2[i++]);
        }
        return result;
    }

    public static int toUnsignedInt(byte b) {
        return b & 0xFF;
    }

    public static byte[] trimLeadingBytes(byte[] bytes, byte b) {
        int offset;
        for (offset = 0; offset < bytes.length - 1 && bytes[offset] == b; ++offset) {
        }
        return Arrays.copyOfRange(bytes, offset, bytes.length);
    }

    public static byte[] trimLeadingZeroes(byte[] bytes) {
        return ArrayUtils.trimLeadingBytes(bytes, (byte)0);
    }
}

