/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.exceptions.MessageDecodingException;
import io.neow3j.exceptions.MessageEncodingException;
import io.neow3j.utils.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class NumericTest {
    private static final byte[] HEX_RANGE_ARRAY = new byte[]{Numeric.asByte((int)0, (int)1), Numeric.asByte((int)2, (int)3), Numeric.asByte((int)4, (int)5), Numeric.asByte((int)6, (int)7), Numeric.asByte((int)8, (int)9), Numeric.asByte((int)10, (int)11), Numeric.asByte((int)12, (int)13), Numeric.asByte((int)14, (int)15)};
    private static final String HEX_RANGE_STRING = "0x0123456789abcdef";

    @Test
    public void testQuantityEncodeLeadingZero() {
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(0L)), (Matcher)CoreMatchers.equalTo((Object)"0x00"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(1024L)), (Matcher)CoreMatchers.equalTo((Object)"0x400"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo((Object)"0x7fffffffffffffff"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)new BigInteger("204516877000845695339750056077105398031")), (Matcher)CoreMatchers.equalTo((Object)"0x99dc848b94efc27edfad28def049810f"));
    }

    @Test
    public void testQuantityDecode() {
        MatcherAssert.assertThat((Object)Numeric.decodeQuantity((String)"0x0"), (Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(0L)));
        MatcherAssert.assertThat((Object)Numeric.decodeQuantity((String)"0x400"), (Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(1024L)));
        MatcherAssert.assertThat((Object)Numeric.decodeQuantity((String)"0x0"), (Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(0L)));
        MatcherAssert.assertThat((Object)Numeric.decodeQuantity((String)"0x7fffffffffffffff"), (Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(Long.MAX_VALUE)));
        MatcherAssert.assertThat((Object)Numeric.decodeQuantity((String)"0x99dc848b94efc27edfad28def049810f"), (Matcher)CoreMatchers.equalTo((Object)new BigInteger("204516877000845695339750056077105398031")));
    }

    @Test(expected=MessageDecodingException.class)
    public void testQuantityDecodeLeadingZeroException() {
        Numeric.decodeQuantity((String)"0x0400");
    }

    @Test(expected=MessageDecodingException.class)
    public void testQuantityDecodeMissingPrefix() {
        Numeric.decodeQuantity((String)"ff");
    }

    @Test(expected=MessageDecodingException.class)
    public void testQuantityDecodeMissingValue() {
        Numeric.decodeQuantity((String)"0x");
    }

    @Test
    public void testQuantityEncode() {
        MatcherAssert.assertThat((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(0L)), (Matcher)CoreMatchers.is((Object)"0x0"));
        MatcherAssert.assertThat((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(1L)), (Matcher)CoreMatchers.is((Object)"0x1"));
        MatcherAssert.assertThat((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(1024L)), (Matcher)CoreMatchers.is((Object)"0x400"));
        MatcherAssert.assertThat((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)), (Matcher)CoreMatchers.is((Object)"0x7fffffffffffffff"));
        MatcherAssert.assertThat((Object)Numeric.encodeQuantity((BigInteger)new BigInteger("204516877000845695339750056077105398031")), (Matcher)CoreMatchers.is((Object)"0x99dc848b94efc27edfad28def049810f"));
    }

    @Test(expected=MessageEncodingException.class)
    public void testQuantityEncodeNegative() {
        Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(-1L));
    }

    @Test
    public void testCleanHexPrefix() {
        MatcherAssert.assertThat((Object)Numeric.cleanHexPrefix((String)""), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)Numeric.cleanHexPrefix((String)"0123456789abcdef"), (Matcher)CoreMatchers.is((Object)"0123456789abcdef"));
        MatcherAssert.assertThat((Object)Numeric.cleanHexPrefix((String)"0x"), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)Numeric.cleanHexPrefix((String)HEX_RANGE_STRING), (Matcher)CoreMatchers.is((Object)"0123456789abcdef"));
    }

    @Test
    public void testPrependHexPrefix() {
        MatcherAssert.assertThat((Object)Numeric.prependHexPrefix((String)""), (Matcher)CoreMatchers.is((Object)"0x"));
        MatcherAssert.assertThat((Object)Numeric.prependHexPrefix((String)HEX_RANGE_STRING), (Matcher)CoreMatchers.is((Object)HEX_RANGE_STRING));
        MatcherAssert.assertThat((Object)Numeric.prependHexPrefix((String)"0x"), (Matcher)CoreMatchers.is((Object)"0x"));
        MatcherAssert.assertThat((Object)Numeric.prependHexPrefix((String)"0123456789abcdef"), (Matcher)CoreMatchers.is((Object)HEX_RANGE_STRING));
    }

    @Test
    public void testToHexStringWithPrefix() {
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefix((BigInteger)BigInteger.TEN), (Matcher)CoreMatchers.is((Object)"0xa"));
    }

    @Test
    public void testToHexStringNoPrefix() {
        MatcherAssert.assertThat((Object)Numeric.toHexStringNoPrefix((BigInteger)BigInteger.TEN), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Test
    public void testToBytesPadded() {
        MatcherAssert.assertThat((Object)Numeric.toBytesPadded((BigInteger)BigInteger.TEN, (int)1), (Matcher)CoreMatchers.is((Object)new byte[]{10}));
        MatcherAssert.assertThat((Object)Numeric.toBytesPadded((BigInteger)BigInteger.TEN, (int)8), (Matcher)CoreMatchers.is((Object)new byte[]{0, 0, 0, 0, 0, 0, 0, 10}));
        MatcherAssert.assertThat((Object)Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE), (int)4), (Matcher)CoreMatchers.is((Object)new byte[]{127, -1, -1, -1}));
    }

    @Test(expected=RuntimeException.class)
    public void testToBytesPaddedInvalid() {
        Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(Long.MAX_VALUE), (int)7);
    }

    @Test
    public void testHexStringToByteArray() {
        MatcherAssert.assertThat((Object)Numeric.hexStringToByteArray((String)""), (Matcher)CoreMatchers.is((Object)new byte[0]));
        MatcherAssert.assertThat((Object)Numeric.hexStringToByteArray((String)"0"), (Matcher)CoreMatchers.is((Object)new byte[]{0}));
        MatcherAssert.assertThat((Object)Numeric.hexStringToByteArray((String)"1"), (Matcher)CoreMatchers.is((Object)new byte[]{1}));
        MatcherAssert.assertThat((Object)Numeric.hexStringToByteArray((String)HEX_RANGE_STRING), (Matcher)CoreMatchers.is((Object)HEX_RANGE_ARRAY));
        MatcherAssert.assertThat((Object)Numeric.hexStringToByteArray((String)"0x123"), (Matcher)CoreMatchers.is((Object)new byte[]{1, 35}));
    }

    @Test
    public void testToHexString() {
        MatcherAssert.assertThat((Object)Numeric.toHexString((byte[])new byte[0]), (Matcher)CoreMatchers.is((Object)"0x"));
        MatcherAssert.assertThat((Object)Numeric.toHexString((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)"0x01"));
        MatcherAssert.assertThat((Object)Numeric.toHexString((byte[])HEX_RANGE_ARRAY), (Matcher)CoreMatchers.is((Object)HEX_RANGE_STRING));
    }

    @Test
    public void testToHexStringNoPrefixZeroPadded() {
        MatcherAssert.assertThat((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.ZERO, (int)5), (Matcher)CoreMatchers.is((Object)"00000"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)new BigInteger("11c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Matcher)CoreMatchers.is((Object)"11c52b08330e05d731e38c856c1043288f7d9744"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Matcher)CoreMatchers.is((Object)"01c52b08330e05d731e38c856c1043288f7d9744"));
    }

    @Test
    public void testToHexStringWithPrefixZeroPadded() {
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)BigInteger.ZERO, (int)5), (Matcher)CoreMatchers.is((Object)"0x00000"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Matcher)CoreMatchers.is((Object)"0x01c52b08330e05d731e38c856c1043288f7d9744"));
        MatcherAssert.assertThat((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Matcher)CoreMatchers.is((Object)"0x01c52b08330e05d731e38c856c1043288f7d9744"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testToHexStringZeroPaddedNegative() {
        Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.valueOf(-1L), (int)20);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testToHexStringZeroPaddedTooLargs() {
        Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.valueOf(-1L), (int)5);
    }

    @Test
    public void testIsIntegerValue() {
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.ZERO));
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.ZERO));
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(Long.MAX_VALUE)));
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(Long.MIN_VALUE)));
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)new BigDecimal("9999999999999999999999999999999999999999999999999999999999999999.0")));
        Assert.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)new BigDecimal("-9999999999999999999999999999999999999999999999999999999999999999.0")));
        TestCase.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(0.1)));
        TestCase.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(-0.1)));
        TestCase.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(1.1)));
        TestCase.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(-1.1)));
    }

    @Test
    public void testHandleNPE() {
        TestCase.assertFalse((boolean)Numeric.containsHexPrefix(null));
        TestCase.assertFalse((boolean)Numeric.containsHexPrefix((String)""));
    }
}

