/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.crypto.KeyUtils;
import io.neow3j.utils.Numeric;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class KeyUtilsTest {
    @Test
    public void testToAddress() {
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9");
        Assert.assertThat((Object)KeyUtils.toAddress((byte[])scriptHash), (Matcher)Is.is((Object)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"));
    }

    @Test
    public void testToScriptHash() {
        byte[] scriptHash = Numeric.hexStringToByteArray((String)"23ba2703c53263e8d6e522dc32203339dcd8eee9");
        Assert.assertThat((Object)KeyUtils.toScriptHash((String)"AK2nJJpJr6o664CWJKi1QRXjqeic2zRp8y"), (Matcher)Is.is((Object)scriptHash));
    }

    @Test
    public void testScriptHashToAddress() {
        String script = "d336d7eb9975a29b2404fdb28185e277a4b299bc";
        String address = "Ab2fvZdmnM4HwDgVbdBrbTLz1wK5TcEyhU";
        Assert.assertThat((Object)KeyUtils.scriptHashToAddress((String)script), (Matcher)Is.is((Object)address));
    }
}

