/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.devpack.neo;

import io.neow3j.devpack.Helper;
import io.neow3j.devpack.neo.Storage;
import io.neow3j.devpack.neo.StorageContext;

public class StorageMap {
    private final StorageContext context;
    private final byte[] prefix;

    public StorageMap(StorageContext context, byte[] prefix) {
        this.context = context;
        this.prefix = prefix;
    }

    public void delete(byte[] key) {
        Storage.delete(this.context, Helper.concat(this.prefix, key));
    }

    public void delete(String key) {
        Storage.delete(this.context, Helper.concat(this.prefix, Helper.toByteArray(key)));
    }

    public byte[] get(byte[] key) {
        return Storage.get(this.context, Helper.concat(this.prefix, key));
    }

    public byte[] get(String key) {
        return Storage.get(this.context, Helper.concat(this.prefix, Helper.toByteArray(key)));
    }

    public void put(byte[] key, byte[] value) {
        Storage.put(this.context, Helper.concat(this.prefix, key), value);
    }

    public void put(byte[] key, int value) {
        Storage.put(this.context, Helper.concat(this.prefix, key), value);
    }

    public void put(byte[] key, String value) {
        Storage.put(this.context, Helper.concat(this.prefix, key), value);
    }

    public void put(String key, byte[] value) {
        Storage.put(this.context, Helper.concat(this.prefix, Helper.toByteArray(key)), value);
    }

    public void put(String key, int value) {
        Storage.put(this.context, Helper.concat(this.prefix, Helper.toByteArray(key)), value);
    }

    public void put(String key, String value) {
        Storage.put(this.context, Helper.concat(this.prefix, Helper.toByteArray(key)), value);
    }
}

