/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.pmp.partnermanagement.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.pmp.common.exception.ValidationException;
import io.mosip.pmp.common.util.RestUtil;
import io.mosip.pmp.partnermanagement.constant.PartnerManageEnum;
import io.mosip.pmp.partnermanagement.dto.AuditRequestDto;
import io.mosip.pmp.partnermanagement.dto.AuditResponseDto;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AuditUtil {
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${mosip.kernel.masterdata.audit-url}")
    private String auditUrl;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    RestUtil restUtil;
    private static final String UNKNOWN_HOST = "Unknown Host";
    private String hostIpAddress = null;
    private String hostName = null;

    public String getServerIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return UNKNOWN_HOST;
        }
    }

    public String getServerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return UNKNOWN_HOST;
        }
    }

    @PostConstruct
    public void getHostDetails() {
        this.hostIpAddress = this.getServerIp();
        this.hostName = this.getServerName();
    }

    public void setAuditRequestDto(PartnerManageEnum PartnerManageEnum2) {
        AuditRequestDto auditRequestDto = new AuditRequestDto();
        auditRequestDto.setHostIp(this.hostIpAddress);
        auditRequestDto.setHostName(this.hostName);
        auditRequestDto.setApplicationId(PartnerManageEnum2.getApplicationId());
        auditRequestDto.setApplicationName(PartnerManageEnum2.getApplicationName());
        auditRequestDto.setSessionUserId(this.getUserId());
        auditRequestDto.setSessionUserName(SecurityContextHolder.getContext().getAuthentication().getName());
        auditRequestDto.setCreatedBy(SecurityContextHolder.getContext().getAuthentication().getName());
        auditRequestDto.setActionTimeStamp(DateUtils.getUTCCurrentDateTime());
        auditRequestDto.setDescription(PartnerManageEnum2.getDescription());
        auditRequestDto.setEventType(PartnerManageEnum2.getType());
        auditRequestDto.setEventName(PartnerManageEnum2.getName());
        auditRequestDto.setModuleId(PartnerManageEnum2.getModuleId());
        auditRequestDto.setModuleName(PartnerManageEnum2.getModuleName());
        auditRequestDto.setEventId(PartnerManageEnum2.getEventId());
        auditRequestDto.setId(PartnerManageEnum2.getId());
        auditRequestDto.setIdType(PartnerManageEnum2.getIdType());
        this.callAuditManager(auditRequestDto);
    }

    private void callAuditManager(AuditRequestDto auditRequestDto) {
        RequestWrapper auditReuestWrapper = new RequestWrapper();
        auditReuestWrapper.setRequest((Object)auditRequestDto);
        HttpEntity httpEntity = new HttpEntity((Object)auditReuestWrapper);
        String response = null;
        try {
            response = (String)this.restUtil.postApi(this.auditUrl, null, "", "", MediaType.APPLICATION_JSON, (Object)httpEntity, String.class);
            this.getAuditDetailsFromResponse(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private AuditResponseDto getAuditDetailsFromResponse(String responseBody) throws Exception {
        List validationErrorsList = null;
        validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
        AuditResponseDto auditResponseDto = null;
        if (!validationErrorsList.isEmpty()) {
            throw new ValidationException(validationErrorsList);
        }
        ResponseWrapper responseObject = null;
        responseObject = (ResponseWrapper)this.objectMapper.readValue(responseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        auditResponseDto = (AuditResponseDto)responseObject.getResponse();
        return auditResponseDto;
    }

    private String getUserId() {
        if (Objects.nonNull(SecurityContextHolder.getContext()) && Objects.nonNull(SecurityContextHolder.getContext().getAuthentication()) && Objects.nonNull(SecurityContextHolder.getContext().getAuthentication().getPrincipal()) && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
            return ((AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserId();
        }
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }
}

