/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.pmp.partnermanagement.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import io.mosip.pmp.common.constant.ApiAccessibleExceptionConstant;
import io.mosip.pmp.common.constant.EventType;
import io.mosip.pmp.common.dto.Type;
import io.mosip.pmp.common.entity.AuthPolicy;
import io.mosip.pmp.common.entity.MISPEntity;
import io.mosip.pmp.common.entity.MISPLicenseEntity;
import io.mosip.pmp.common.entity.Partner;
import io.mosip.pmp.common.entity.PartnerPolicy;
import io.mosip.pmp.common.entity.PartnerPolicyRequest;
import io.mosip.pmp.common.exception.ApiAccessibleException;
import io.mosip.pmp.common.helper.WebSubPublisher;
import io.mosip.pmp.common.repository.AuthPolicyRepository;
import io.mosip.pmp.common.repository.BiometricExtractorProviderRepository;
import io.mosip.pmp.common.repository.MispLicenseKeyRepository;
import io.mosip.pmp.common.repository.MispServiceRepository;
import io.mosip.pmp.common.repository.PartnerPolicyRepository;
import io.mosip.pmp.common.repository.PartnerPolicyRequestRepository;
import io.mosip.pmp.common.repository.PartnerRepository;
import io.mosip.pmp.common.repository.PolicyGroupRepository;
import io.mosip.pmp.common.util.RestUtil;
import io.mosip.pmp.partnermanagement.constant.InvalidInputParameterConstant;
import io.mosip.pmp.partnermanagement.constant.NoPartnerApiKeyRequestsConstant;
import io.mosip.pmp.partnermanagement.constant.PartnerAPIDoesNotExistConstant;
import io.mosip.pmp.partnermanagement.constant.PartnerAPIKeyDoesNotExistConstant;
import io.mosip.pmp.partnermanagement.constant.PartnerDoesNotExistExceptionConstant;
import io.mosip.pmp.partnermanagement.constant.PartnerIdDoesNotExistExceptionConstant;
import io.mosip.pmp.partnermanagement.constant.PartnerManageEnum;
import io.mosip.pmp.partnermanagement.constant.PartnerValidationsConstants;
import io.mosip.pmp.partnermanagement.dto.ActivateDeactivatePartnerRequest;
import io.mosip.pmp.partnermanagement.dto.ApikeyRequests;
import io.mosip.pmp.partnermanagement.dto.MISPValidatelKeyResponseDto;
import io.mosip.pmp.partnermanagement.dto.PartnerAPIKeyToPolicyMappingsResponse;
import io.mosip.pmp.partnermanagement.dto.PartnerCertDownloadResponeDto;
import io.mosip.pmp.partnermanagement.dto.PartnerPolicyResponse;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingRequest;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingResponse;
import io.mosip.pmp.partnermanagement.dto.Policies;
import io.mosip.pmp.partnermanagement.dto.PolicyDTO;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnerDetailsResponse;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnersDetails;
import io.mosip.pmp.partnermanagement.exception.InvalidInputParameterException;
import io.mosip.pmp.partnermanagement.exception.NoPartnerApiKeyRequestsException;
import io.mosip.pmp.partnermanagement.exception.PartnerAPIDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerAPIKeyDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerIdDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerValidationException;
import io.mosip.pmp.partnermanagement.service.PartnerManagementService;
import io.mosip.pmp.partnermanagement.util.AuditUtil;
import io.mosip.pmp.partnermanagement.util.PartnerUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PartnerManagementServiceImpl
implements PartnerManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartnerManagementServiceImpl.class);
    @Autowired
    private MispLicenseKeyRepository misplKeyRepository;
    @Autowired
    PartnerPolicyRepository partnerPolicyRepository;
    @Autowired
    PartnerRepository partnerRepository;
    @Autowired
    PartnerPolicyRequestRepository partnerPolicyRequestRepository;
    @Autowired
    PolicyGroupRepository policyGroupRepository;
    @Autowired
    BiometricExtractorProviderRepository extractorProviderRepository;
    @Autowired
    AuthPolicyRepository authPolicyRepository;
    @Autowired
    MispServiceRepository mispRepository;
    @Autowired
    private WebSubPublisher webSubPublisher;
    @Autowired
    RestUtil restUtil;
    @Autowired
    private Environment environment;
    @Autowired
    private ObjectMapper mapper;
    private static final String APPROVED = "Approved";
    private static final String REJECTED = "Rejected";
    private static final String ERRORS = "errors";
    private static final String ERRORCODE = "errorCode";
    private static final String ERRORMESSAGE = "message";
    private static final String ACTIVE = "Active";
    private static final String DEACTIVE = "De-Active";
    @Value(value="${mosip.pmp.partner.policy.expiry.period.indays}")
    private int partnerPolicyExpiryInDays;
    @Value(value="${pmp.bioextractors.required.partner.types}")
    private String biometricExtractorsRequiredPartnerTypes;
    @Autowired
    AuditUtil auditUtil;

    /*
     * Enabled aggressive block sorting
     */
    public PartnersPolicyMappingResponse partnerApiKeyPolicyMappings(PartnersPolicyMappingRequest request, String partnerId, String policyAPIKey) {
        LOGGER.info("Getting details from partner Policy for given API_KEY and PartnerID :" + policyAPIKey + " and " + partnerId);
        Optional partnerPolicyByAPIKey = this.partnerPolicyRepository.findById((Object)policyAPIKey);
        if (partnerPolicyByAPIKey.isEmpty()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.API_KEY_MAPPING_FAILURE);
            throw new PartnerAPIKeyDoesNotExistException(PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        if (((PartnerPolicy)partnerPolicyByAPIKey.get()).getPartner().getId().equals(partnerId) && ((PartnerPolicy)partnerPolicyByAPIKey.get()).getPolicyId().equals(request.getOldPolicyID())) {
            Optional requestedPolicy = this.authPolicyRepository.findById((Object)request.getNewPolicyID());
            if (!requestedPolicy.isEmpty() && ((AuthPolicy)requestedPolicy.get()).getPolicyGroup().getId().equals(((PartnerPolicy)partnerPolicyByAPIKey.get()).getPartner().getPolicyGroupId())) {
                PartnerPolicy updateObject = (PartnerPolicy)partnerPolicyByAPIKey.get();
                updateObject.setUpdBy(this.getUser());
                updateObject.setUpdDtimes(Timestamp.valueOf(LocalDateTime.now()));
                updateObject.setPolicyId(((AuthPolicy)requestedPolicy.get()).getId());
                this.partnerPolicyRepository.save((Object)updateObject);
                PartnersPolicyMappingResponse partnersPolicyMappingResponse = new PartnersPolicyMappingResponse();
                partnersPolicyMappingResponse.setMessage("Partner api key to Policy Mappings updated successfully");
                this.notify(policyAPIKey, true);
                this.auditUtil.setAuditRequestDto(PartnerManageEnum.API_KEY_MAPPING_SUCCESS);
                return partnersPolicyMappingResponse;
            }
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.API_KEY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.POLICY_NOT_BELONGS_TO_PARTNER_POLICY_GROUP.getErrorCode(), PartnerValidationsConstants.POLICY_NOT_BELONGS_TO_PARTNER_POLICY_GROUP.getErrorMessage());
        }
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.API_KEY_MAPPING_FAILURE);
        throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_APIKEY_POLICY_MAPPING_NOTEXISTS.getErrorCode(), PartnerValidationsConstants.PARTNER_APIKEY_POLICY_MAPPING_NOTEXISTS.getErrorMessage());
    }

    public PartnersPolicyMappingResponse activateDeactivateAuthEKYCPartner(String partnerID, ActivateDeactivatePartnerRequest request) {
        if (!request.getStatus().equalsIgnoreCase("Active") && !request.getStatus().equalsIgnoreCase("De-Active")) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_KYC_PARTNERS_FAILURE);
            LOGGER.info(request.getStatus() + " : is Invalid Input Parameter, it should be (Active/De-Active)");
            throw new InvalidInputParameterException(InvalidInputParameterConstant.INVALID_STATUS_CODE_ACTIVE_DEACTIVE.getErrorCode(), InvalidInputParameterConstant.INVALID_STATUS_CODE_ACTIVE_DEACTIVE.getErrorMessage());
        }
        Boolean status = request.getStatus().equalsIgnoreCase("Active");
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = new PartnersPolicyMappingResponse();
        Optional partnerFromDb = this.partnerRepository.findById((Object)partnerID);
        if (!partnerFromDb.isPresent()) {
            LOGGER.info(partnerID + " : Partner Id Does Not Exist");
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_KYC_PARTNERS_FAILURE);
            throw new PartnerIdDoesNotExistException(PartnerIdDoesNotExistExceptionConstant.PARTNER_ID_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerIdDoesNotExistExceptionConstant.PARTNER_ID_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        Partner updatePartnerObject = (Partner)partnerFromDb.get();
        updatePartnerObject.setIsActive(status);
        updatePartnerObject.setUpdBy(this.getUser());
        updatePartnerObject.setUpdDtimes(Timestamp.valueOf(LocalDateTime.now()));
        this.partnerRepository.save((Object)updatePartnerObject);
        partnersPolicyMappingResponse.setMessage("Partner status updated successfully");
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_KYC_PARTNERS_SUCCESS);
        this.notify(partnerID, false);
        return partnersPolicyMappingResponse;
    }

    public PartnersPolicyMappingResponse activateDeactivatePartnerAPIKeyGivenPartner(String partnerID, ActivateDeactivatePartnerRequest request, String partnerAPIKey) {
        if (!request.getStatus().equalsIgnoreCase("Active") && !request.getStatus().equalsIgnoreCase("De-Active")) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_API_PARTNERS_FAILED);
            LOGGER.info(request.getStatus() + " : is Invalid Input Parameter, it should be (Active/De-Active)");
            throw new InvalidInputParameterException(InvalidInputParameterConstant.INVALID_STATUS_CODE_ACTIVE_DEACTIVE.getErrorCode(), InvalidInputParameterConstant.INVALID_STATUS_CODE_ACTIVE_DEACTIVE.getErrorMessage());
        }
        Boolean status = request.getStatus().equalsIgnoreCase("Active");
        Optional partnerPolicyFromDb = this.partnerPolicyRepository.findById((Object)partnerAPIKey);
        if (partnerPolicyFromDb.isPresent()) {
            PartnerPolicy partnerPolicy = (PartnerPolicy)partnerPolicyFromDb.get();
            if (!partnerPolicy.getPartner().getId().equals(partnerID)) {
                LOGGER.info(partnerID + " : Partner Id Does Not Exist");
                this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_API_PARTNERS_FAILED);
                throw new PartnerValidationException(PartnerIdDoesNotExistExceptionConstant.PARTNER_ID_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerIdDoesNotExistExceptionConstant.PARTNER_ID_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
            }
        } else {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_API_PARTNERS_FAILED);
            throw new PartnerAPIKeyDoesNotExistException(PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        PartnerPolicy updatepartnerPolicyObject = (PartnerPolicy)partnerPolicyFromDb.get();
        updatepartnerPolicyObject.setIsActive(status);
        updatepartnerPolicyObject.setUpdBy(this.getUser());
        updatepartnerPolicyObject.setUpdDtimes(Timestamp.valueOf(LocalDateTime.now()));
        this.partnerPolicyRepository.save((Object)updatepartnerPolicyObject);
        LOGGER.info(partnerAPIKey + " : API KEY Status Updated Successfully");
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = new PartnersPolicyMappingResponse();
        partnersPolicyMappingResponse.setMessage("Partner API Key status updated successfully");
        this.notify(partnerAPIKey, true);
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_API_PARTNERS_SUCCESS);
        return partnersPolicyMappingResponse;
    }

    public RetrievePartnerDetailsResponse getAllAuthEKYCPartnersForThePolicyGroup(Optional<String> partnerType) {
        RetrievePartnerDetailsResponse partnersResponse = new RetrievePartnerDetailsResponse();
        ArrayList<RetrievePartnersDetails> partners = new ArrayList<RetrievePartnersDetails>();
        List partnersFromDb = null;
        partnersFromDb = partnerType.isPresent() && !partnerType.get().trim().isEmpty() ? this.partnerRepository.findByPartnerType(partnerType.get()) : this.partnerRepository.findAll();
        Partner partner = null;
        if (partnersFromDb.isEmpty()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_GROUP_FAILURE);
            throw new PartnerValidationException(PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        Iterator partnerIterat = partnersFromDb.iterator();
        while (partnerIterat.hasNext()) {
            RetrievePartnersDetails retrievePartnersDetails = new RetrievePartnersDetails();
            partner = (Partner)partnerIterat.next();
            retrievePartnersDetails.setPartnerID(partner.getId());
            retrievePartnersDetails.setStatus(partner.getIsActive() == true ? "Active" : "De-Active");
            retrievePartnersDetails.setOrganizationName(partner.getName());
            retrievePartnersDetails.setContactNumber(partner.getContactNo());
            retrievePartnersDetails.setEmailId(partner.getEmailId());
            retrievePartnersDetails.setAddress(partner.getAddress());
            retrievePartnersDetails.setPartnerType(partner.getPartnerTypeCode());
            partners.add(retrievePartnersDetails);
        }
        partnersResponse.setPartners(partners);
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_GROUP_SUCCESS);
        return partnersResponse;
    }

    public RetrievePartnersDetails getparticularAuthEKYCPartnerDetailsForGivenPartnerId(String partnerID) {
        Optional findPartnerById = this.partnerRepository.findById((Object)partnerID);
        RetrievePartnersDetails retrievePartnersDetails = new RetrievePartnersDetails();
        if (!findPartnerById.isPresent()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FOR_ID_FAILURE);
            throw new PartnerValidationException(PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        Partner partner = (Partner)findPartnerById.get();
        retrievePartnersDetails.setPartnerID(partner.getId());
        retrievePartnersDetails.setStatus(partner.getIsActive() == true ? "Active" : "De-Active");
        retrievePartnersDetails.setOrganizationName(partner.getName());
        retrievePartnersDetails.setContactNumber(partner.getContactNo());
        retrievePartnersDetails.setEmailId(partner.getEmailId());
        retrievePartnersDetails.setAddress(partner.getAddress());
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FOR_ID_SUCCESS);
        return retrievePartnersDetails;
    }

    public PartnerAPIKeyToPolicyMappingsResponse getPartnerAPIKeyToPolicyMapping(String partnerID, String PartnerAPIKey) {
        PartnerAPIKeyToPolicyMappingsResponse response = new PartnerAPIKeyToPolicyMappingsResponse();
        Optional partnerPolicyFromDb = this.partnerPolicyRepository.findById((Object)PartnerAPIKey);
        if (!partnerPolicyFromDb.isPresent() || !((PartnerPolicy)partnerPolicyFromDb.get()).getPartner().getId().equals(partnerID)) {
            LOGGER.info(PartnerAPIKey + " : Partner API KEY Not Exist");
            LOGGER.info(PartnerAPIKey + " : Partner api key mapping not exists.");
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FAILURE);
            throw new PartnerAPIDoesNotExistException(PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_NOT_MAPPED.getErrorCode(), PartnerAPIKeyDoesNotExistConstant.PARTNER_API_KEY_NOT_MAPPED.getErrorMessage());
        }
        response.setPartnerID(partnerID);
        response.setPolicyId(((PartnerPolicy)partnerPolicyFromDb.get()).getPolicyId());
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_SUCCESS);
        return response;
    }

    public List<ApikeyRequests> getAllPartnerAPIKeyRequestsAsReceivedByPartnerManagers() {
        ArrayList<ApikeyRequests> response = new ArrayList<ApikeyRequests>();
        List findAllRequests = this.partnerPolicyRequestRepository.findAll();
        if (!findAllRequests.isEmpty()) {
            for (PartnerPolicyRequest nextRecord : findAllRequests) {
                ApikeyRequests apikeyRequests = new ApikeyRequests();
                apikeyRequests.setApiKeyReqNo(nextRecord.getId());
                apikeyRequests.setOrganizationName(nextRecord.getPartner().getName());
                apikeyRequests.setPartnerID(nextRecord.getPartner().getId());
                apikeyRequests.setPolicyDesc(nextRecord.getRequestDetail());
                apikeyRequests.setPolicyId(nextRecord.getPolicyId());
                apikeyRequests.setStatus(nextRecord.getStatusCode());
                response.add(apikeyRequests);
            }
        } else {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FAILURE);
            throw new NoPartnerApiKeyRequestsException(NoPartnerApiKeyRequestsConstant.NO_PARTNER_API_KEY_REQUEST_EXCEPTION.getErrorCode(), NoPartnerApiKeyRequestsConstant.NO_PARTNER_API_KEY_REQUEST_EXCEPTION.getErrorMessage());
        }
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_SUCCESS);
        return response;
    }

    public ApikeyRequests getTheRequestForPartnerAPIKeyToPolicyMappingsForGivenRequestId(String apiKeyReqID) {
        Optional findRequestById = this.partnerPolicyRequestRepository.findById((Object)apiKeyReqID);
        ApikeyRequests apikeyRequest = new ApikeyRequests();
        if (findRequestById.isEmpty()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FAILURE);
            throw new NoPartnerApiKeyRequestsException(NoPartnerApiKeyRequestsConstant.NO_PARTNER_API_KEY_REQUEST_EXCEPTION.getErrorCode(), NoPartnerApiKeyRequestsConstant.NO_PARTNER_API_KEY_REQUEST_EXCEPTION.getErrorMessage());
        }
        apikeyRequest.setApiKeyReqNo(((PartnerPolicyRequest)findRequestById.get()).getId());
        apikeyRequest.setOrganizationName(((PartnerPolicyRequest)findRequestById.get()).getPartner().getName());
        apikeyRequest.setPartnerID(((PartnerPolicyRequest)findRequestById.get()).getPartner().getId());
        apikeyRequest.setPolicyDesc(((PartnerPolicyRequest)findRequestById.get()).getRequestDetail());
        apikeyRequest.setPolicyId(((PartnerPolicyRequest)findRequestById.get()).getPolicyId());
        apikeyRequest.setStatus(((PartnerPolicyRequest)findRequestById.get()).getStatusCode());
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_SUCCESS);
        return apikeyRequest;
    }

    public PartnersPolicyMappingResponse approveRejectPartnerAPIKeyRequestsBasedOnAPIKeyRequestId(ActivateDeactivatePartnerRequest request, String partnerKeyReqId) {
        List extractorsFromDb;
        PartnerPolicyRequest partnerPolicyRequest = null;
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = new PartnersPolicyMappingResponse();
        Optional partnerPolicyRequestFromDb = this.partnerPolicyRequestRepository.findById((Object)partnerKeyReqId);
        if (!partnerPolicyRequestFromDb.isPresent()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_FAILURE);
            throw new PartnerAPIDoesNotExistException(PartnerAPIDoesNotExistConstant.PARTNER_API_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerAPIDoesNotExistConstant.PARTNER_API_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        if (((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getStatusCode().equalsIgnoreCase("Approved")) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_FAILURE);
            throw new InvalidInputParameterException(InvalidInputParameterConstant.POLICY_REQUEST_ALREADY_APPROVED.getErrorCode(), InvalidInputParameterConstant.POLICY_REQUEST_ALREADY_APPROVED.getErrorMessage());
        }
        if (((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getStatusCode().equalsIgnoreCase("Rejected")) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_FAILURE);
            throw new InvalidInputParameterException(InvalidInputParameterConstant.POLICY_REQUEST_ALREADY_REJECTED.getErrorCode(), InvalidInputParameterConstant.POLICY_REQUEST_ALREADY_REJECTED.getErrorMessage());
        }
        partnerPolicyRequest = (PartnerPolicyRequest)partnerPolicyRequestFromDb.get();
        if (!request.getStatus().equalsIgnoreCase("Approved") && !request.getStatus().equalsIgnoreCase("Rejected")) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_FAILURE);
            LOGGER.info(request.getStatus() + " : Invalid Input Parameter (status should be Approved/Rejected)");
            throw new InvalidInputParameterException(InvalidInputParameterConstant.INVALID_STATUS_CODE.getErrorCode(), InvalidInputParameterConstant.INVALID_STATUS_CODE.getErrorMessage());
        }
        partnerPolicyRequest.setStatusCode(request.getStatus());
        if (Arrays.stream(this.biometricExtractorsRequiredPartnerTypes.split(",")).anyMatch(((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getPartner().getPartnerTypeCode()::equalsIgnoreCase) && (extractorsFromDb = this.extractorProviderRepository.findByPartnerAndPolicyId(((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getPartner().getId(), ((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getPolicyId())).isEmpty()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_FAILURE);
            throw new InvalidInputParameterException(InvalidInputParameterConstant.EXTRACTORS_NOT_PRESENT.getErrorCode(), InvalidInputParameterConstant.EXTRACTORS_NOT_PRESENT.getErrorMessage());
        }
        partnerPolicyRequest.setUpdBy(this.getUser());
        partnerPolicyRequest.setUpdDtimes(Timestamp.valueOf(LocalDateTime.now()));
        this.partnerPolicyRequestRepository.save((Object)partnerPolicyRequest);
        if (request.getStatus().equalsIgnoreCase("Approved")) {
            LOGGER.info("Creating PartnerAPIKey");
            LOGGER.info("Partner_API_Key should be unique for same partner");
            PartnerPolicy partnerPolicy = new PartnerPolicy();
            String partnerAPIKey = PartnerUtil.createPartnerApiKey();
            partnerPolicy.setPolicyApiKey(partnerAPIKey);
            partnerPolicy.setPartner(partnerPolicyRequest.getPartner());
            partnerPolicy.setPolicyId(((PartnerPolicyRequest)partnerPolicyRequestFromDb.get()).getPolicyId());
            partnerPolicy.setIsActive(Boolean.valueOf(true));
            partnerPolicy.setValidFromDatetime(Timestamp.valueOf(LocalDateTime.now()));
            partnerPolicy.setValidToDatetime(Timestamp.valueOf(LocalDateTime.now().plusDays(this.partnerPolicyExpiryInDays)));
            partnerPolicy.setCrBy(partnerPolicyRequest.getCrBy());
            partnerPolicy.setCrDtimes(partnerPolicyRequest.getCrDtimes());
            this.partnerPolicyRepository.save((Object)partnerPolicy);
        }
        partnersPolicyMappingResponse.setMessage("PartnerAPIKey Updated successfully");
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API_SUCCESS);
        return partnersPolicyMappingResponse;
    }

    public PartnerPolicyResponse getPartnerMappedPolicyFile(String mispLicenseKey, String policy_api_key, String partnerId, boolean needPartnerCert) {
        PartnerPolicy partnerPolicy;
        Optional partner;
        LOGGER.info("Getting the partner from db.");
        PartnerPolicyResponse response = new PartnerPolicyResponse();
        MISPValidatelKeyResponseDto licenseKeyresponse = this.validateLicenseKey(mispLicenseKey);
        if (!licenseKeyresponse.isActive()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorCode(), PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorMessage());
        }
        if (!licenseKeyresponse.isValid()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.MISP_LICENSE_KEY_EXPIRED.getErrorCode(), PartnerValidationsConstants.MISP_LICENSE_KEY_EXPIRED.getErrorMessage());
        }
        Optional mispFromDb = this.mispRepository.findById((Object)licenseKeyresponse.getMisp_id());
        if (mispFromDb.isEmpty()) {
            Optional mispPartner = this.partnerRepository.findById((Object)licenseKeyresponse.getMisp_id());
            if (!((Partner)mispPartner.get()).getIsActive().booleanValue()) {
                this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
                throw new PartnerValidationException(PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorCode(), PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorMessage());
            }
        } else if (!((MISPEntity)mispFromDb.get()).getIsActive().booleanValue()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorCode(), PartnerValidationsConstants.MISP_IS_BLOCKED.getErrorMessage());
        }
        if (!(partner = this.partnerRepository.findById((Object)partnerId)).isPresent()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorCode(), PartnerDoesNotExistExceptionConstant.PARTNER_DOES_NOT_EXIST_EXCEPTION.getErrorMessage());
        }
        if (!((Partner)partner.get()).getIsActive().booleanValue()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_NOT_ACTIVE_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_NOT_ACTIVE_EXCEPTION.getErrorMessage());
        }
        if (needPartnerCert && ((Partner)partner.get()).getCertificateAlias() == null) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_CERTIFICATE_NOT_EXISTS.getErrorCode(), PartnerValidationsConstants.PARTNER_CERTIFICATE_NOT_EXISTS.getErrorMessage());
        }
        if (needPartnerCert) {
            response.setCertificateData(this.getPartnerCertificate(((Partner)partner.get()).getCertificateAlias()));
        }
        if ((partnerPolicy = this.partnerPolicyRepository.findByApiKey(policy_api_key)) == null) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorMessage());
        }
        if (!partnerPolicy.getPartner().getId().equals(((Partner)partner.get()).getId())) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorMessage());
        }
        if (!partnerPolicy.getIsActive().booleanValue()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_POLICY_NOT_ACTIVE_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_POLICY_NOT_ACTIVE_EXCEPTION.getErrorMessage());
        }
        if (partnerPolicy.getValidToDatetime().before(Timestamp.valueOf(LocalDateTime.now()))) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_POLICY_EXPIRED_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_POLICY_EXPIRED_EXCEPTION.getErrorMessage());
        }
        Optional authPolicy = this.authPolicyRepository.findById((Object)partnerPolicy.getPolicyId());
        if (!authPolicy.isPresent()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_NOT_MAPPED_TO_POLICY_EXCEPTION.getErrorMessage());
        }
        if (!((AuthPolicy)authPolicy.get()).getIsActive().booleanValue()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_POLICY_NOT_ACTIVE_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_POLICY_NOT_ACTIVE_EXCEPTION.getErrorMessage());
        }
        if (((AuthPolicy)authPolicy.get()).getPolicyGroup() == null) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.POLICY_GROUP_NOT_EXISTS.getErrorCode(), PartnerValidationsConstants.POLICY_GROUP_NOT_EXISTS.getErrorMessage());
        }
        if (!((AuthPolicy)authPolicy.get()).getPolicyGroup().getIsActive().booleanValue()) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.POLICY_GROUP_NOT_ACTIVE.getErrorCode(), PartnerValidationsConstants.POLICY_GROUP_NOT_ACTIVE.getErrorMessage());
        }
        if (((AuthPolicy)authPolicy.get()).getValidToDate().isBefore(LocalDateTime.now())) {
            this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_FAILURE);
            throw new PartnerValidationException(PartnerValidationsConstants.PARTNER_POLICY_EXPIRED_EXCEPTION.getErrorCode(), PartnerValidationsConstants.PARTNER_POLICY_EXPIRED_EXCEPTION.getErrorMessage());
        }
        response.setPolicyId(partnerPolicy.getPolicyId());
        response.setPolicyDescription(((AuthPolicy)authPolicy.get()).getPolicyGroup().getDescr());
        response.setPolicy(this.getAuthPolicies(((AuthPolicy)authPolicy.get()).getPolicyFileId(), ((AuthPolicy)authPolicy.get()).getId()));
        response.setPolicyStatus(((AuthPolicy)authPolicy.get()).getIsActive().booleanValue());
        response.setPartnerId(partnerPolicy.getPartner().getId());
        response.setPartnerName(partnerPolicy.getPartner().getName());
        response.setPolicyName(((AuthPolicy)authPolicy.get()).getName());
        response.setMispExpiresOn(PartnerManagementServiceImpl.toISOFormat((LocalDateTime)licenseKeyresponse.getValidTo()));
        response.setPolicyExpiresOn(PartnerManagementServiceImpl.toISOFormat((LocalDateTime)((AuthPolicy)authPolicy.get()).getValidToDate()));
        response.setApiKeyExpiresOn(PartnerManagementServiceImpl.toISOFormat((LocalDateTime)partnerPolicy.getValidToDatetime().toLocalDateTime()));
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING_SUCCESS);
        return response;
    }

    private PolicyDTO getAuthPolicies(String policeFileId, String authPolicyId) {
        Policies policies = new Policies();
        PolicyDTO authPolicies = new PolicyDTO();
        Map readValue = null;
        try {
            readValue = (Map)new ObjectMapper().readValue(policeFileId, Map.class);
        }
        catch (Exception e) {
            LOGGER.info("Error occured while parsing the policy file" + e.getStackTrace());
            throw new PartnerValidationException(PartnerValidationsConstants.POLICY_GROUP_NOT_ACTIVE.getErrorCode(), PartnerValidationsConstants.POLICY_GROUP_NOT_ACTIVE.getErrorMessage());
        }
        policies.setAuthPolicies((List)readValue.get("allowedAuthTypes"));
        policies.setAllowedKycAttributes((List)readValue.get("allowedKycAttributes"));
        policies.setAuthTokenType((String)readValue.get("authTokenType"));
        authPolicies.setPolicies(policies);
        authPolicies.setPolicyId(authPolicyId);
        return authPolicies;
    }

    public MISPValidatelKeyResponseDto validateLicenseKey(String licenseKey) {
        MISPValidatelKeyResponseDto response = new MISPValidatelKeyResponseDto();
        LOGGER.info("Getting the misp license key " + licenseKey);
        MISPLicenseEntity mispLicense = this.getLicenseDetails(licenseKey);
        response.setActive(mispLicense.getIsActive().booleanValue());
        response.setLicenseKey(mispLicense.getMispLicenseUniqueKey().getLicense_key());
        response.setValid(mispLicense.getValidToDate().isAfter(LocalDateTime.now()));
        response.setValidFrom(mispLicense.getValidFromDate());
        response.setValidTo(mispLicense.getValidToDate());
        response.setMisp_id(mispLicense.getMispLicenseUniqueKey().getMisp_id());
        String message = response.isValid() ? "Valid" : "Expired";
        response.setMessage("MISP " + mispLicense.getMispLicenseUniqueKey().getMisp_id() + " with license key " + mispLicense.getMispLicenseUniqueKey().getLicense_key() + "  is " + message);
        return response;
    }

    private MISPLicenseEntity getLicenseDetails(String licenseKey) {
        LOGGER.info("Retrieving the misp license key " + licenseKey);
        MISPLicenseEntity mispLicense = null;
        try {
            mispLicense = this.misplKeyRepository.findByLicensekey(licenseKey);
            if (mispLicense == null) {
                LOGGER.warn("No details found for license key " + licenseKey);
                throw new PartnerValidationException(PartnerValidationsConstants.MISP_LICENSE_KEY_NOT_EXISTS.getErrorCode(), PartnerValidationsConstants.MISP_LICENSE_KEY_NOT_EXISTS.getErrorMessage() + " " + licenseKey);
            }
        }
        catch (Exception e) {
            LOGGER.warn("No details found for license key " + licenseKey + e.getStackTrace());
            throw new PartnerValidationException(PartnerValidationsConstants.MISP_LICENSE_KEY_NOT_EXISTS.getErrorCode(), PartnerValidationsConstants.MISP_LICENSE_KEY_NOT_EXISTS.getErrorMessage() + " " + licenseKey);
        }
        return mispLicense;
    }

    public String getUser() {
        if (Objects.nonNull(SecurityContextHolder.getContext()) && Objects.nonNull(SecurityContextHolder.getContext().getAuthentication()) && Objects.nonNull(SecurityContextHolder.getContext().getAuthentication().getPrincipal()) && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
            return ((AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserId();
        }
        return null;
    }

    private void notify(String updatedObject, boolean isApiKeyUpdated) {
        Type type = new Type();
        type.setName("PartnerManagementServiceImpl");
        type.setNamespace("io.mosip.pmp.misp.service");
        HashMap<String, String> data = new HashMap<String, String>();
        String updatedParam = isApiKeyUpdated ? "apiKey" : "partnerId";
        data.put(updatedParam, updatedObject);
        EventType event = isApiKeyUpdated ? EventType.APIKEY_UPDATED : EventType.PARTNER_UPDATED;
        this.webSubPublisher.notify(event, data, type);
    }

    private String getPartnerCertificate(String certificateAlias) {
        HashMap<String, String> pathsegments = new HashMap<String, String>();
        pathsegments.put("partnerCertId", certificateAlias);
        Map getApiResponse = (Map)this.restUtil.getApi(this.environment.getProperty("pmp.partner.certificaticate.get.rest.uri"), pathsegments, Map.class);
        PartnerCertDownloadResponeDto responseObject = null;
        try {
            responseObject = (PartnerCertDownloadResponeDto)this.mapper.readValue(this.mapper.writeValueAsString(getApiResponse.get("response")), PartnerCertDownloadResponeDto.class);
        }
        catch (IOException e) {
            throw new ApiAccessibleException(ApiAccessibleExceptionConstant.UNABLE_TO_PROCESS.getErrorCode(), ApiAccessibleExceptionConstant.UNABLE_TO_PROCESS.getErrorMessage());
        }
        if (responseObject == null && getApiResponse.containsKey("errors")) {
            List certServiceErrorList = (List)getApiResponse.get("errors");
            if (!certServiceErrorList.isEmpty()) {
                throw new ApiAccessibleException(((Map)certServiceErrorList.get(0)).get("errorCode").toString(), ((Map)certServiceErrorList.get(0)).get("message").toString());
            }
            throw new ApiAccessibleException(ApiAccessibleExceptionConstant.UNABLE_TO_PROCESS.getErrorCode(), ApiAccessibleExceptionConstant.UNABLE_TO_PROCESS.getErrorMessage());
        }
        if (responseObject == null) {
            throw new ApiAccessibleException(ApiAccessibleExceptionConstant.API_NULL_RESPONSE_EXCEPTION.getErrorCode(), ApiAccessibleExceptionConstant.API_NULL_RESPONSE_EXCEPTION.getErrorMessage());
        }
        return responseObject.getCertificateData();
    }

    private static LocalDateTime toISOFormat(LocalDateTime localDateTime) {
        ZonedDateTime zonedtime = localDateTime.atZone(ZoneId.systemDefault());
        ZonedDateTime converted = zonedtime.withZoneSameInstant(ZoneOffset.UTC);
        return converted.toLocalDateTime();
    }
}

