/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.pmp.partnermanagement.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.pmp.common.exception.ApiAccessibleException;
import io.mosip.pmp.partnermanagement.constant.PartnerManagementInputExceptionConstant;
import io.mosip.pmp.partnermanagement.core.ResponseWrapper;
import io.mosip.pmp.partnermanagement.exception.BaseUncheckedException;
import io.mosip.pmp.partnermanagement.exception.ErrorResponse;
import io.mosip.pmp.partnermanagement.exception.InvalidInputParameterException;
import io.mosip.pmp.partnermanagement.exception.NewPolicyIdNotExistException;
import io.mosip.pmp.partnermanagement.exception.NoPartnerApiKeyRequestsException;
import io.mosip.pmp.partnermanagement.exception.PartnerAPIDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerAPIKeyDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerIdDoesNotExistException;
import io.mosip.pmp.partnermanagement.exception.PartnerValidationException;
import io.mosip.pmp.partnermanagement.exception.PolicyNotExistException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class PartnerMnagementControllerAdvice
extends ResponseEntityExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    public ResponseEntity<ResponseWrapper<ErrorResponse>> getErrorMassage(HttpServletRequest httpServletRequest, BaseUncheckedException baseUncheckedException) throws IOException {
        ResponseWrapper response = this.setErrors(httpServletRequest);
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorCode(baseUncheckedException.getErrorCode());
        errorResponse.setMessage(baseUncheckedException.getErrorText());
        ArrayList<ErrorResponse> errorlist = new ArrayList<ErrorResponse>();
        errorlist.add(errorResponse);
        response.setErrors(errorlist);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    public ResponseEntity<ResponseWrapper<ErrorResponse>> getErrorMsg(BaseUncheckedException exception) {
        ResponseWrapper response = new ResponseWrapper();
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorCode(exception.getErrorCode());
        errorResponse.setMessage(exception.getErrorText());
        ArrayList<ErrorResponse> errorlist = new ArrayList<ErrorResponse>();
        errorlist.add(errorResponse);
        response.setId("mosip.partnermanagement.partners.retrieve");
        response.setVersion("1.0");
        response.setErrors(errorlist);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    public ResponseEntity<ResponseWrapper<ErrorResponse>> getErrorMsg(ApiAccessibleException exception) {
        ResponseWrapper response = new ResponseWrapper();
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorCode(exception.getErrorCode());
        errorResponse.setMessage(exception.getErrorText());
        ArrayList<ErrorResponse> errorlist = new ArrayList<ErrorResponse>();
        errorlist.add(errorResponse);
        response.setId("mosip.partnermanagement.partners.retrieve");
        response.setVersion("1.0");
        response.setErrors(errorlist);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @ExceptionHandler(value={PartnerAPIKeyDoesNotExistException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getPartnerAPIKeyDoesNotExistExceptionMassage(HttpServletRequest httpServletRequest, PartnerAPIKeyDoesNotExistException exception) throws IOException {
        return this.getErrorMassage(httpServletRequest, (BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={InvalidInputParameterException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getInvalidInputParameterExceptionMessage(HttpServletRequest httpServletRequest, InvalidInputParameterException exception) throws IOException {
        return this.getErrorMassage(httpServletRequest, (BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={NewPolicyIdNotExistException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getNewPolicyIdNotExistExceptionMessage(HttpServletRequest httpServletRequest, NewPolicyIdNotExistException exception) throws IOException {
        return this.getErrorMassage(httpServletRequest, (BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={PolicyNotExistException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getPolicyNotExistExceptionMessage(HttpServletRequest httpServletRequest, PolicyNotExistException exception) throws IOException {
        return this.getErrorMassage(httpServletRequest, (BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={PartnerValidationException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getPartnerDoesNotExistExceptionMessage(PartnerValidationException exception) {
        return this.getErrorMsg((BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={ApiAccessibleException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getApiAccessibleExceptionMessage(ApiAccessibleException exception) {
        return this.getErrorMsg(exception);
    }

    @ExceptionHandler(value={PartnerIdDoesNotExistException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getPartnerIdDoesNotExistExceptionMessage(PartnerIdDoesNotExistException exception) {
        return this.getErrorMsg((BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={NoPartnerApiKeyRequestsException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getNoPartnerApiKeyRequestExceptionMessage(NoPartnerApiKeyRequestsException exception) {
        return this.getErrorMsg((BaseUncheckedException)exception);
    }

    @ExceptionHandler(value={PartnerAPIDoesNotExistException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getPartnerApiDoesNotExistExceptionMessage(PartnerAPIDoesNotExistException exception) {
        return this.getErrorMsg((BaseUncheckedException)exception);
    }

    private ResponseWrapper<ErrorResponse> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ErrorResponse>> getExceptionMassage(HttpServletRequest httpServletRequest, RuntimeException exception) throws IOException {
        ResponseWrapper response = this.setErrors(httpServletRequest);
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setMessage(exception.getMessage());
        ArrayList<ErrorResponse> errorlist = new ArrayList<ErrorResponse>();
        errorlist.add(errorResponse);
        response.setErrors(errorlist);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("timestamp", new Date());
        body.put("status", status.value());
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorCode(PartnerManagementInputExceptionConstant.MISSING_PARTNER_MANAGEMENT_INPUT_PARAMETER.getErrorCode());
        errorResponse.setMessage(PartnerManagementInputExceptionConstant.MISSING_PARTNER_MANAGEMENT_INPUT_PARAMETER.getErrorMessage());
        ArrayList<ErrorResponse> errors = new ArrayList<ErrorResponse>();
        errors.add(errorResponse);
        body.put("errors", errors);
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }
}

