/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.pmp.partnermanagement.controller;

import io.mosip.pmp.partnermanagement.constant.PartnerManageEnum;
import io.mosip.pmp.partnermanagement.core.RequestWrapper;
import io.mosip.pmp.partnermanagement.core.ResponseWrapper;
import io.mosip.pmp.partnermanagement.dto.ActivateDeactivatePartnerRequest;
import io.mosip.pmp.partnermanagement.dto.ApikeyRequests;
import io.mosip.pmp.partnermanagement.dto.PartnerAPIKeyRequestsResponse;
import io.mosip.pmp.partnermanagement.dto.PartnerAPIKeyToPolicyMappingsResponse;
import io.mosip.pmp.partnermanagement.dto.PartnerPolicyResponse;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingRequest;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingResponse;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnerDetailsResponse;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnersDetails;
import io.mosip.pmp.partnermanagement.service.PartnerManagementService;
import io.mosip.pmp.partnermanagement.util.AuditUtil;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pmpartners"})
public class PartnerManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartnerManagementController.class);
    @Autowired
    PartnerManagementService partnerManagementService;
    @Autowired
    AuditUtil auditUtil;
    String msg = "mosip.partnermanagement.partners.retrieve";
    String version = "1.0";

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.PUT})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> partnerApiKeyToPolicyMappings(@RequestBody @Valid RequestWrapper<PartnersPolicyMappingRequest> request, @PathVariable String partnerId, @PathVariable String partnerApiKey) {
        LOGGER.info("Requesting for updating the Policy Group");
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.API_KEY_MAPPING);
        PartnersPolicyMappingRequest partnersPolicyMappingRequest = (PartnersPolicyMappingRequest)request.getRequest();
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        partnersPolicyMappingResponse = this.partnerManagementService.partnerApiKeyPolicyMappings(partnersPolicyMappingRequest, partnerId, partnerApiKey);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> activateDeactivateAuthEKYCPartners(@PathVariable String partnerId, @RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_KYC_PARTNERS);
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        partnersPolicyMappingResponse = this.partnerManagementService.activateDeactivateAuthEKYCPartner(partnerId, activateDeactivatePartnerRequest);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> activateDeactivatePartnerAPIKeyGivenPartner(@PathVariable String partnerId, @RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request, @PathVariable String partnerApiKey) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.ACTIVATE_DEACTIVATE_API_PARTNERS);
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        partnersPolicyMappingResponse = this.partnerManagementService.activateDeactivatePartnerAPIKeyGivenPartner(partnerId, activateDeactivatePartnerRequest, partnerApiKey);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager','ID_AUTHENTICATION','CREDENTIAL_ISSUANCE')")
    @RequestMapping(value={"/validatePartnerMisp/partnerId/{partnerId}/partnerApiKey/{partner_api_key}/mispLicenseKey/{misp_license_key}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerPolicyResponse>> validatePartnerAndMisp(@PathVariable String partnerId, @PathVariable String partner_api_key, @PathVariable String misp_license_key, @RequestParam(defaultValue="false", name="needPartnerCert") boolean needPartnerCert) {
        ResponseWrapper response = new ResponseWrapper();
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_MAPPING);
        PartnerPolicyResponse responseFromService = this.partnerManagementService.getPartnerMappedPolicyFile(misp_license_key, partner_api_key, partnerId, needPartnerCert);
        response.setResponse((Object)responseFromService);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests/{apiKeyReqId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> approveRejectPartnerAPIKeyRequestsBasedOnAPIKeyRequestId(@RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request, @PathVariable String apiKeyReqId) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.APPROVE_REJECT_PARTNER_API);
        partnersPolicyMappingResponse = this.partnerManagementService.approveRejectPartnerAPIKeyRequestsBasedOnAPIKeyRequestId(activateDeactivatePartnerRequest, apiKeyReqId);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager','ID_AUTHENTICATION','REGISTRATION_PROCESSOR','RESIDENT','CREDENTIAL_ISSUANCE')")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<RetrievePartnerDetailsResponse>> getAllAuthEKYCPartnersForThePolicyGroup(@RequestParam(value="partnerType") Optional<String> partnerType) {
        ResponseWrapper response = new ResponseWrapper();
        RetrievePartnerDetailsResponse retrievePartnerDetailsResponse = null;
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_POLICY_GROUP);
        retrievePartnerDetailsResponse = this.partnerManagementService.getAllAuthEKYCPartnersForThePolicyGroup(partnerType);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)retrievePartnerDetailsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<RetrievePartnersDetails>> getparticularAuthEKYCPartnerDetailsForGivenPartnerId(@PathVariable String partnerId) {
        ResponseWrapper response = new ResponseWrapper();
        RetrievePartnersDetails retrievePartnersDetails = null;
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER_FOR_ID);
        retrievePartnersDetails = this.partnerManagementService.getparticularAuthEKYCPartnerDetailsForGivenPartnerId(partnerId);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)retrievePartnersDetails);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerAPIKeyToPolicyMappingsResponse>> getValidatPartnerAPIKeyPatternAndExpiry(@PathVariable String partnerId, @PathVariable String partnerApiKey) {
        ResponseWrapper response = new ResponseWrapper();
        PartnerAPIKeyToPolicyMappingsResponse partnerAPIKeyToPolicyMappingsResponse = null;
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER);
        partnerAPIKeyToPolicyMappingsResponse = this.partnerManagementService.getPartnerAPIKeyToPolicyMapping(partnerId, partnerApiKey);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)partnerAPIKeyToPolicyMappingsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerAPIKeyRequestsResponse>> getAllPartnerAPIKeyRequestsAsReceivedByPartnerManager() {
        List apikeyRequests = null;
        ResponseWrapper response = new ResponseWrapper();
        PartnerAPIKeyRequestsResponse partnerAPIKeyRequestsResponse = new PartnerAPIKeyRequestsResponse();
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER);
        apikeyRequests = this.partnerManagementService.getAllPartnerAPIKeyRequestsAsReceivedByPartnerManagers();
        partnerAPIKeyRequestsResponse.setApikeyRequests(apikeyRequests);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)partnerAPIKeyRequestsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests/{apiKeyReqId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<ApikeyRequests>> getTheRequestForPartnerAPIKeyToPolicyMappingsForGivenRequestId(@PathVariable String apiKeyReqId) {
        ResponseWrapper response = new ResponseWrapper();
        ApikeyRequests apikeyRequests = null;
        this.auditUtil.setAuditRequestDto(PartnerManageEnum.GET_PARTNER);
        apikeyRequests = this.partnerManagementService.getTheRequestForPartnerAPIKeyToPolicyMappingsForGivenRequestId(apiKeyReqId);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)apikeyRequests);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }
}

