/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.pmp.partnermanagement.controller;

import io.mosip.pmp.partnermanagement.core.RequestWrapper;
import io.mosip.pmp.partnermanagement.core.ResponseWrapper;
import io.mosip.pmp.partnermanagement.dto.ActivateDeactivatePartnerRequest;
import io.mosip.pmp.partnermanagement.dto.ApikeyRequests;
import io.mosip.pmp.partnermanagement.dto.PartnerAPIKeyRequestsResponse;
import io.mosip.pmp.partnermanagement.dto.PartnerAPIKeyToPolicyMappingsResponse;
import io.mosip.pmp.partnermanagement.dto.PartnerPolicyResponse;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingRequest;
import io.mosip.pmp.partnermanagement.dto.PartnersPolicyMappingResponse;
import io.mosip.pmp.partnermanagement.dto.PolicyIDResponse;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnerDetailsResponse;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnerManagers;
import io.mosip.pmp.partnermanagement.dto.RetrievePartnersDetails;
import io.mosip.pmp.partnermanagement.service.PartnerManagementService;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pmpartners"})
public class PartnerManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartnerManagementController.class);
    @Autowired
    PartnerManagementService partnerManagementService;
    String msg = "mosip.partnermanagement.partners.retrieve";
    String version = "1.0";

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.PUT})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> partnerApiKeyToPolicyMappings(@RequestBody @Valid RequestWrapper<PartnersPolicyMappingRequest> request, @PathVariable String partnerId, @PathVariable String partnerApiKey) {
        LOGGER.info("Requesting for updating the Policy Group");
        PartnersPolicyMappingRequest partnersPolicyMappingRequest = (PartnersPolicyMappingRequest)request.getRequest();
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        partnersPolicyMappingResponse = this.partnerManagementService.partnerApiKeyPolicyMappings(partnersPolicyMappingRequest, partnerId, partnerApiKey);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> activateDeactivateAuthEKYCPartners(@PathVariable String partnerId, @RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        partnersPolicyMappingResponse = this.partnerManagementService.activateDeactivateAuthEKYCPartner(partnerId, activateDeactivatePartnerRequest);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> activateDeactivatePartnerAPIKeyGivenPartner(@PathVariable String partnerId, @RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request, @PathVariable String partnerApiKey) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        partnersPolicyMappingResponse = this.partnerManagementService.activateDeactivatePartnerAPIKeyGivenPartner(partnerId, activateDeactivatePartnerRequest, partnerApiKey);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager','ID_AUTHENTICATION')")
    @RequestMapping(value={"/validatePartnerMisp/partnerId/{partnerId}/partnerApiKey/{partner_api_key}/mispLicenseKey/{misp_license_key}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerPolicyResponse>> validatePartnerAndMisp(@PathVariable String partnerId, @PathVariable String partner_api_key, @PathVariable String misp_license_key) {
        ResponseWrapper response = new ResponseWrapper();
        PartnerPolicyResponse responseFromService = this.partnerManagementService.getPartnerMappedPolicyFile(misp_license_key, partner_api_key, partnerId);
        response.setResponse((Object)responseFromService);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests/{apiKeyReqId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResponseWrapper<PartnersPolicyMappingResponse>> approveRejectPartnerAPIKeyRequestsBasedOnAPIKeyRequestId(@RequestBody @Valid RequestWrapper<ActivateDeactivatePartnerRequest> request, @PathVariable String apiKeyReqId) {
        ResponseWrapper response = new ResponseWrapper();
        PartnersPolicyMappingResponse partnersPolicyMappingResponse = null;
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        ActivateDeactivatePartnerRequest activateDeactivatePartnerRequest = (ActivateDeactivatePartnerRequest)request.getRequest();
        partnersPolicyMappingResponse = this.partnerManagementService.approveRejectPartnerAPIKeyRequestsBasedOnAPIKeyRequestId(activateDeactivatePartnerRequest, apiKeyReqId);
        response.setResponse((Object)partnersPolicyMappingResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<RetrievePartnerDetailsResponse>> getAllAuthEKYCPartnersForThePolicyGroup() {
        ResponseWrapper response = new ResponseWrapper();
        RetrievePartnerDetailsResponse retrievePartnerDetailsResponse = null;
        retrievePartnerDetailsResponse = this.partnerManagementService.getAllAuthEKYCPartnersForThePolicyGroup();
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)retrievePartnerDetailsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/getManager"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<RetrievePartnerManagers>> getPartnerManager() {
        ResponseWrapper response = new ResponseWrapper();
        RetrievePartnerManagers retrievePartnerManagers = null;
        retrievePartnerManagers = this.partnerManagementService.getPartnerManager();
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)retrievePartnerManagers);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<RetrievePartnersDetails>> getparticularAuthEKYCPartnerDetailsForGivenPartnerId(@PathVariable String partnerId) {
        ResponseWrapper response = new ResponseWrapper();
        RetrievePartnersDetails retrievePartnersDetails = null;
        retrievePartnersDetails = this.partnerManagementService.getparticularAuthEKYCPartnerDetailsForGivenPartnerId(partnerId);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)retrievePartnersDetails);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/{partnerId}/{partnerApiKey}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerAPIKeyToPolicyMappingsResponse>> getValidatPartnerAPIKeyPatternAndExpiry(@PathVariable String partnerId, @PathVariable String partnerApiKey) {
        ResponseWrapper response = new ResponseWrapper();
        PartnerAPIKeyToPolicyMappingsResponse partnerAPIKeyToPolicyMappingsResponse = null;
        partnerAPIKeyToPolicyMappingsResponse = this.partnerManagementService.getPartnerAPIKeyToPolicyMapping(partnerId, partnerApiKey);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)partnerAPIKeyToPolicyMappingsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PartnerAPIKeyRequestsResponse>> getAllPartnerAPIKeyRequestsAsReceivedByPartnerManager() {
        List apikeyRequests = null;
        ResponseWrapper response = new ResponseWrapper();
        PartnerAPIKeyRequestsResponse partnerAPIKeyRequestsResponse = new PartnerAPIKeyRequestsResponse();
        apikeyRequests = this.partnerManagementService.getAllPartnerAPIKeyRequestsAsReceivedByPartnerManagers();
        partnerAPIKeyRequestsResponse.setApikeyRequests(apikeyRequests);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)partnerAPIKeyRequestsResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/PartnerAPIKeyRequests/{apiKeyReqId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<ApikeyRequests>> getTheRequestForPartnerAPIKeyToPolicyMappingsForGivenRequestId(@PathVariable String apiKeyReqId) {
        ResponseWrapper response = new ResponseWrapper();
        ApikeyRequests apikeyRequests = null;
        apikeyRequests = this.partnerManagementService.getTheRequestForPartnerAPIKeyToPolicyMappingsForGivenRequestId(apiKeyReqId);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)apikeyRequests);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PreAuthorize(value="hasAnyRole('PARTNERMANAGER','partnermanager')")
    @RequestMapping(value={"/policyname/{policyName}"}, method={RequestMethod.GET})
    public ResponseEntity<ResponseWrapper<PolicyIDResponse>> getPolicyID(@PathVariable String policyName) {
        ResponseWrapper response = new ResponseWrapper();
        PolicyIDResponse policyIDResponse = null;
        policyIDResponse = this.partnerManagementService.getPartnerPolicyID(policyName);
        response.setId(this.msg);
        response.setVersion(this.version);
        response.setResponse((Object)policyIDResponse);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }
}

