/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keygenerator.generator;

import io.mosip.kernel.core.keymanager.spi.ECKeyStore;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.entity.DataEncryptKeystore;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.repository.DataEncryptKeystoreRepository;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RandomKeysGenerator {
    private static final Logger LOGGER = Logger.getLogger(RandomKeysGenerator.class.getName());
    private static final String CREATED_BY = "System";
    private static final String WRAPPING_TRANSFORMATION = "AES/ECB/NoPadding";
    @Value(value="${zkcrypto.random.key.generate.count}")
    private long noOfKeysRequire;
    @Autowired
    private ECKeyStore keyStore;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    DataEncryptKeystoreRepository dataEncryptKeystoreRepository;

    public void generateRandomKeys(String appId, String referenceId) {
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        Map keyAliasMap = this.dbHelper.getKeyAliases(appId, referenceId, localDateTimeStamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        String alias = null;
        if (currentKeyAlias.isEmpty()) {
            LOGGER.info("Cache Master key not available, generating new key.");
            alias = UUID.randomUUID().toString();
            this.generateAndStore(appId, referenceId, alias, localDateTimeStamp);
        } else {
            alias = ((KeyAlias)currentKeyAlias.get(0)).getAlias();
        }
        try {
            this.generate10KKeysAndStoreInDB(alias);
        }
        catch (Exception e) {
            LOGGER.warning("Error generating Random Keys." + e.getMessage());
        }
    }

    private void generateAndStore(String appId, String referenceId, String keyAlias, LocalDateTime localDateTimeStamp) {
        this.keyStore.generateAndStoreSymmetricKey(keyAlias);
        this.dbHelper.storeKeyInAlias(appId, localDateTimeStamp, referenceId, keyAlias, localDateTimeStamp.plusDays(1825L), null, null);
    }

    private void generate10KKeysAndStoreInDB(String cacheMasterKeyAlias) throws Exception {
        int noOfActiveKeys = (int)this.dataEncryptKeystoreRepository.findAll().stream().filter(k -> k.getKeyStatus().equals("active")).count();
        int noOfKeysToGenerate = 0;
        if (this.noOfKeysRequire - (long)noOfActiveKeys > 0L) {
            noOfKeysToGenerate = (int)(this.noOfKeysRequire - (long)noOfActiveKeys);
        }
        LOGGER.info("No Of Keys To Generate:" + noOfKeysToGenerate);
        Long maxid = this.dataEncryptKeystoreRepository.findMaxId();
        int startIndex = maxid == null ? 0 : maxid.intValue() + 1;
        SecureRandom rand = new SecureRandom();
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        Cipher cipher = Cipher.getInstance(WRAPPING_TRANSFORMATION);
        SecretKey masterKey = this.keyStore.getSymmetricKey(cacheMasterKeyAlias);
        for (int i = startIndex; i < noOfKeysToGenerate; ++i) {
            keyGenerator.init(256, rand);
            SecretKey sKey = keyGenerator.generateKey();
            cipher.init(1, masterKey);
            byte[] wrappedKey = cipher.doFinal(sKey.getEncoded());
            String encodedKey = Base64.getEncoder().encodeToString(wrappedKey);
            this.insertKeyIntoTable(i, encodedKey, "Active");
            LOGGER.info("Insert secrets in DB: " + i);
        }
    }

    private void insertKeyIntoTable(int id, String secretData, String status) throws Exception {
        DataEncryptKeystore data = new DataEncryptKeystore();
        data.setId(Integer.valueOf(id));
        data.setKey(secretData);
        data.setKeyStatus(status);
        data.setCrBy(CREATED_BY);
        data.setCrDTimes(LocalDateTime.now());
        this.dataEncryptKeystoreRepository.save((Object)data);
    }
}

