/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keygenerator.generator;

import io.mosip.kernel.keygenerator.generator.RandomKeysGenerator;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.repository.KeyAliasRepository;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeysGenerator {
    private static final Logger LOGGER = Logger.getLogger(KeysGenerator.class.getName());
    private static final String ROOT_APP_ID = "ROOT";
    private static final String BLANK_REF_ID = "";
    private static final String DUMMY_RESP_TYPE = "CSR";
    private static final String IDENTITY_CACHE_REF_ID = "IDENTITY_CACHE";
    @Value(value="${mosip.kernel.keymanager.autogen.appids.list}")
    private String appIdsList;
    @Value(value="${mosip.kernel.keymanager.certificate.default.common-name}")
    private String rootCommonName;
    @Value(value="${mosip.kernel.keymanager.certificate.default.organizational-unit}")
    private String organizationUnit;
    @Value(value="${mosip.kernel.keymanager.certificate.default.organization}")
    private String organization;
    @Value(value="${mosip.kernel.keymanager.certificate.default.location}")
    private String location;
    @Value(value="${mosip.kernel.keymanager.certificate.default.state}")
    private String state;
    @Value(value="${mosip.kernel.keymanager.certificate.default.country}")
    private String country;
    @Value(value="${mosip.kernel.keymanager.autogen.basekeys.list}")
    private String baseKeys;
    @Autowired
    private KeyAliasRepository keyAliasRepository;
    @Autowired
    KeymanagerService keymanagerService;
    @Autowired
    RandomKeysGenerator randomKeysGenerator;

    public void generateKeys() throws Exception {
        String rootKeyAlias = this.getKeyAlias(ROOT_APP_ID, BLANK_REF_ID);
        if (Objects.isNull(rootKeyAlias)) {
            this.generateMasterKey(ROOT_APP_ID, BLANK_REF_ID, this.rootCommonName);
            LOGGER.info("Generated ROOT Key.");
        }
        List keyAppIdsList = this.getListKeys();
        keyAppIdsList.forEach(appId -> {
            String[] strArr = appId.split(":", -1);
            String applicationId = strArr[0];
            String referenceId = BLANK_REF_ID;
            Object commonName = this.rootCommonName;
            if (strArr.length > 1) {
                referenceId = strArr[1];
                commonName = (String)commonName + "-" + referenceId.toUpperCase();
            }
            if (referenceId.equalsIgnoreCase(IDENTITY_CACHE_REF_ID)) {
                this.randomKeysGenerator.generateRandomKeys(applicationId, referenceId);
                LOGGER.info("Generated Cache Key & Random Keys.");
            } else {
                String masterKeyAlias = this.getKeyAlias(applicationId, referenceId);
                if (Objects.isNull(masterKeyAlias)) {
                    this.generateMasterKey(applicationId, referenceId, (String)commonName);
                    LOGGER.info("Generated Master Key for Application ID & ReferenceId: " + appId);
                } else {
                    LOGGER.info("Master Key Already exists for Application ID & ReferenceId: " + appId);
                }
            }
        });
        List baseKeysList = this.getBaseKeysList();
        baseKeysList.forEach(appId -> {
            String[] strArr = appId.split(":", -1);
            if (strArr.length == 2) {
                String applicationId = strArr[0];
                String referenceId = strArr[1];
                if (referenceId.length() != 0) {
                    this.generateBaseKey(applicationId, referenceId);
                    LOGGER.info("Base Key Successful. AppId: " + applicationId + ", refId: " + referenceId);
                } else {
                    LOGGER.warning("Configured Reference Id is not valid. Configured value: " + appId);
                }
            } else {
                LOGGER.warning("Configured Base Key is not valid. Configured value: " + appId);
            }
        });
    }

    private List<String> getListKeys() {
        return Stream.of(this.appIdsList.split(",")).map(String::trim).filter(appId -> !appId.equalsIgnoreCase(ROOT_APP_ID)).collect(Collectors.toList());
    }

    private List<String> getBaseKeysList() {
        return Stream.of(this.baseKeys.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private String getKeyAlias(String applicationId, String referenceId) {
        List keyAliases = this.keyAliasRepository.findByApplicationIdAndReferenceId(applicationId, referenceId).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
        List currentKeyAliases = keyAliases.stream().filter(keyAlias -> this.isValidTimestamp(LocalDateTime.now(), keyAlias)).collect(Collectors.toList());
        if (!currentKeyAliases.isEmpty() && currentKeyAliases.size() == 1) {
            LOGGER.info("CurrentKeyAlias size is one.");
            return ((KeyAlias)currentKeyAliases.get(0)).getAlias();
        }
        return null;
    }

    private boolean isValidTimestamp(LocalDateTime timeStamp, KeyAlias keyAlias) {
        return timeStamp.isEqual(keyAlias.getKeyGenerationTime()) || timeStamp.isEqual(keyAlias.getKeyExpiryTime()) || timeStamp.isAfter(keyAlias.getKeyGenerationTime()) && timeStamp.isBefore(keyAlias.getKeyExpiryTime());
    }

    private void generateMasterKey(String appId, String refId, String commonName) {
        KeyPairGenerateRequestDto requestDto = new KeyPairGenerateRequestDto();
        requestDto.setApplicationId(appId);
        requestDto.setReferenceId(refId);
        requestDto.setForce(Boolean.valueOf(false));
        requestDto.setCommonName(commonName);
        String componentName = appId.equalsIgnoreCase(ROOT_APP_ID) ? BLANK_REF_ID : " (" + appId.toUpperCase() + ")";
        requestDto.setOrganizationUnit(this.organizationUnit + componentName);
        requestDto.setOrganization(this.organization);
        requestDto.setLocation(this.location);
        requestDto.setState(this.state);
        requestDto.setCountry(this.country);
        this.keymanagerService.generateMasterKey(DUMMY_RESP_TYPE, requestDto);
    }

    private void generateBaseKey(String appId, String refId) {
        this.keymanagerService.getCertificate(appId, Optional.of(refId));
    }
}

