/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;

public abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    public RuntimeException uncheckedIOException(IOException e) {
        return new RuntimeException(e);
    }

    public AssertionError assertionError(String message, Throwable cause) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(cause);
        throw error;
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        Jre8 jre8 = Jre8.buildIfSupported();
        if (jre8 != null) {
            return jre8;
        }
        Jre7 jre7 = Jre7.buildIfSupported();
        if (jre7 != null) {
            return jre7;
        }
        return Jre6.build();
    }

    static final class Jre6
    extends Platform {
        Jre6() {
        }

        static Jre6 build() {
            return new Jre6();
        }
    }

    static class Jre7
    extends Platform {
        Jre7() {
        }

        static Jre7 buildIfSupported() {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new Jre7();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public AssertionError assertionError(String message, Throwable cause) {
            return new AssertionError(message, cause);
        }
    }

    static final class Jre8
    extends Jre7 {
        Jre8() {
        }

        static Jre8 buildIfSupported() {
            try {
                Class.forName("java.io.UncheckedIOException");
                return new Jre8();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public RuntimeException uncheckedIOException(IOException e) {
            return new UncheckedIOException(e);
        }
    }
}

