/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public final class DelayLimiter<C> {
    final Ticker ticker;
    final ConcurrentHashMap<C, Suppression<C>> cache = new ConcurrentHashMap();
    final DelayQueue<Suppression<C>> suppressions = new DelayQueue();
    final long ttlNanos;
    final long cardinality;

    public static <C> DelayLimiter<C> create() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    DelayLimiter(Builder builder) {
        this.ticker = builder.ticker;
        this.ttlNanos = builder.ttlNanos;
        this.cardinality = builder.cardinality;
    }

    public boolean shouldInvoke(C context) {
        this.cleanupExpiredSuppressions();
        if (this.cache.containsKey(context)) {
            return false;
        }
        Suppression<C> suppression = new Suppression<C>(this.ticker, context, this.ticker.read() + this.ttlNanos);
        if (this.cache.putIfAbsent(context, suppression) != null) {
            return false;
        }
        this.suppressions.offer(suppression);
        if ((long)this.suppressions.size() > this.cardinality) {
            this.removeOneSuppression();
        }
        return true;
    }

    void removeOneSuppression() {
        Suppression eldest;
        while ((eldest = (Suppression)this.suppressions.peek()) != null) {
            if (!this.suppressions.remove(eldest)) continue;
            this.cache.remove(eldest.context, eldest);
            break;
        }
    }

    public void invalidate(C context) {
        Suppression<C> suppression = this.cache.remove(context);
        if (suppression != null) {
            this.suppressions.remove(suppression);
        }
    }

    public void clear() {
        this.cache.clear();
        this.suppressions.clear();
    }

    void cleanupExpiredSuppressions() {
        Suppression expiredSuppression;
        while ((expiredSuppression = (Suppression)this.suppressions.poll()) != null) {
            this.cache.remove(expiredSuppression.context, expiredSuppression);
        }
    }

    static final class Suppression<C>
    implements Delayed {
        final Ticker ticker;
        final C context;
        final long expiration;

        Suppression(Ticker ticker, C context, long expiration) {
            this.ticker = ticker;
            this.context = context;
            this.expiration = expiration;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiration - this.ticker.read(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.signum(this.expiration - ((Suppression)o).expiration);
        }
    }

    static class Ticker {
        Ticker() {
        }

        long read() {
            return System.nanoTime();
        }
    }

    public static final class Builder {
        Ticker ticker = new Ticker();
        long ttlNanos = TimeUnit.HOURS.toNanos(1L);
        int cardinality = 20000;

        public Builder ttl(int ttl) {
            if (ttl <= 0) {
                throw new IllegalArgumentException("ttl <= 0");
            }
            this.ttlNanos = TimeUnit.MILLISECONDS.toNanos(ttl);
            return this;
        }

        public Builder cardinality(int cardinality) {
            if (cardinality <= 0) {
                throw new IllegalArgumentException("cardinality <= 0");
            }
            this.cardinality = cardinality;
            return this;
        }

        Builder ticker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        public <C> DelayLimiter<C> build() {
            return new DelayLimiter(this);
        }

        Builder() {
        }
    }
}

