/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.test.web.servlet.htmlunit.WebRequestMatcher;
import org.springframework.util.Assert;

public final class DelegatingWebConnection
implements WebConnection {
    private final List<DelegateWebConnection> connections;
    private final WebConnection defaultConnection;

    public DelegatingWebConnection(WebConnection defaultConnection, List<DelegateWebConnection> connections) {
        Assert.notNull((Object)defaultConnection, "Default WebConnection must not be null");
        Assert.notEmpty(connections, "Connections List must not be empty");
        this.connections = connections;
        this.defaultConnection = defaultConnection;
    }

    public DelegatingWebConnection(WebConnection defaultConnection, DelegateWebConnection ... connections) {
        this(defaultConnection, Arrays.asList(connections));
    }

    public WebResponse getResponse(WebRequest request) throws IOException {
        for (DelegateWebConnection connection : this.connections) {
            if (!connection.getMatcher().matches(request)) continue;
            return connection.getDelegate().getResponse(request);
        }
        return this.defaultConnection.getResponse(request);
    }

    public void close() {
    }

    public static final class DelegateWebConnection {
        private final WebRequestMatcher matcher;
        private final WebConnection delegate;

        public DelegateWebConnection(WebRequestMatcher matcher, WebConnection delegate) {
            this.matcher = matcher;
            this.delegate = delegate;
        }

        private WebRequestMatcher getMatcher() {
            return this.matcher;
        }

        private WebConnection getDelegate() {
            return this.delegate;
        }
    }
}

